/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.PMMLObject;

public abstract class ServiceFactory<K extends PMMLObject, S>
implements Serializable {
    private Class<K> keyClazz = null;
    private Class<S> serviceClazz = null;
    private transient ListMultimap<Class<? extends K>, Class<? extends S>> serviceProviderClazzes = null;

    protected ServiceFactory() {
    }

    protected ServiceFactory(Class<K> keyClazz, Class<S> serviceClazz) {
        this.setKeyClass(keyClazz);
        this.setServiceClass(serviceClazz);
    }

    public List<Class<? extends S>> getServiceProviderClasses(Class<? extends K> objectClazz) throws ClassNotFoundException, IOException {
        Class<K> keyClazz = this.getKeyClass();
        ListMultimap<Class<K>, Class<S>> serviceProviderClazzes = this.getServiceProviderClasses();
        Class<K> clazz = objectClazz;
        while (clazz != null) {
            if (serviceProviderClazzes.containsKey(clazz)) {
                return serviceProviderClazzes.get(clazz);
            }
            Class<K> superClazz = clazz.getSuperclass();
            try {
                clazz = superClazz.asSubclass(keyClazz);
            }
            catch (ClassCastException cce) {
                break;
            }
        }
        return Collections.emptyList();
    }

    public ListMultimap<Class<? extends K>, Class<? extends S>> getServiceProviderClasses() throws ClassNotFoundException, IOException {
        if (this.serviceProviderClazzes == null) {
            Class keyClazz = this.getKeyClass();
            Class serviceClazz = this.getServiceClass();
            List<Class<S>> serviceProviderClazzes = ServiceFactory.loadServiceProviderClasses(serviceClazz);
            this.serviceProviderClazzes = Multimaps.index(serviceProviderClazzes, serviceProviderClazz -> ServiceFactory.getKey(keyClazz, serviceClazz, serviceProviderClazz));
        }
        return this.serviceProviderClazzes;
    }

    public Class<K> getKeyClass() {
        return this.keyClazz;
    }

    private void setKeyClass(Class<K> keyClazz) {
        this.keyClazz = Objects.requireNonNull(keyClazz);
    }

    public Class<S> getServiceClass() {
        return this.serviceClazz;
    }

    private void setServiceClass(Class<S> serviceClazz) {
        this.serviceClazz = Objects.requireNonNull(serviceClazz);
    }

    protected static <S> List<Class<? extends S>> loadServiceProviderClasses(Class<S> serviceClazz) throws ClassNotFoundException, IOException {
        Thread thread = Thread.currentThread();
        ClassLoader clazzLoader = thread.getContextClassLoader();
        if (clazzLoader == null) {
            clazzLoader = ClassLoader.getSystemClassLoader();
        }
        ArrayList<Class<S>> result = new ArrayList<Class<S>>();
        Enumeration<URL> urls = clazzLoader.getResources("META-INF/services/" + serviceClazz.getName());
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream is = url.openStream();
            Throwable throwable = null;
            try {
                List<Class<S>> serviceProviderClazzes = ServiceFactory.loadServiceProviderClasses(is, clazzLoader, serviceClazz);
                result.addAll(serviceProviderClazzes);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return result;
    }

    private static <S> List<Class<? extends S>> loadServiceProviderClasses(InputStream is, ClassLoader clazzLoader, Class<S> serviceClazz) throws ClassNotFoundException, IOException {
        String line;
        ArrayList<Class<S>> result = new ArrayList<Class<S>>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"), 1024);
        while ((line = reader.readLine()) != null) {
            int hash = line.indexOf(35);
            if (hash > -1) {
                line = line.substring(0, hash);
            }
            if ((line = line.trim()).isEmpty()) continue;
            Class<?> serviceProviderClazz = Class.forName(line, false, clazzLoader);
            if (!serviceClazz.isAssignableFrom(serviceProviderClazz)) {
                throw new IllegalArgumentException(line);
            }
            result.add(serviceProviderClazz);
        }
        reader.close();
        return result;
    }

    protected static <K extends PMMLObject, S> Class<? extends K> getKey(Class<K> keyClazz, Class<S> serviceClazz, Class<? extends S> serviceProviderClazz) {
        Class<S> clazz = serviceProviderClazz;
        while (clazz != null) {
            Class<S> superClazz = clazz.getSuperclass();
            if (serviceClazz.equals(superClazz)) {
                ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
                Type[] arguments = parameterizedType.getActualTypeArguments();
                if (arguments.length != 1) {
                    throw new IllegalArgumentException(clazz.getName());
                }
                Class argumentClazz = (Class)arguments[0];
                return argumentClazz.asSubclass(keyClazz);
            }
            clazz = superClazz;
        }
        throw new IllegalArgumentException(serviceProviderClazz.getName());
    }
}

