/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.nearest_neighbor;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Distance;
import org.dmg.pmml.Field;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Measure;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Similarity;
import org.dmg.pmml.nearest_neighbor.InstanceField;
import org.dmg.pmml.nearest_neighbor.InstanceFields;
import org.dmg.pmml.nearest_neighbor.KNNInput;
import org.dmg.pmml.nearest_neighbor.KNNInputs;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.dmg.pmml.nearest_neighbor.PMMLAttributes;
import org.dmg.pmml.nearest_neighbor.TrainingInstances;
import org.jpmml.evaluator.AffinityDistribution;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.DefaultDataField;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InlineTableUtil;
import org.jpmml.evaluator.InputFieldUtil;
import org.jpmml.evaluator.InvisibleFieldException;
import org.jpmml.evaluator.MeasureUtil;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.MissingFieldValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueAggregator;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.VoteAggregator;
import org.jpmml.model.InvalidAttributeException;
import org.jpmml.model.InvalidElementException;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.visitors.ActiveFieldFinder;

public class NearestNeighborModelEvaluator
extends ModelEvaluator<NearestNeighborModel> {
    private Table<Integer, String, FieldValue> trainingInstances = null;
    private Map<Integer, ?> trainingInstanceCentroids = null;

    private NearestNeighborModelEvaluator() {
    }

    public NearestNeighborModelEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, NearestNeighborModel.class));
    }

    public NearestNeighborModelEvaluator(PMML pmml, NearestNeighborModel nearestNeighborModel) {
        super(pmml, nearestNeighborModel);
        ComparisonMeasure comparisonMeasure = nearestNeighborModel.requireComparisonMeasure();
        TrainingInstances trainingInstances = nearestNeighborModel.requireTrainingInstances();
        List instanceFields = trainingInstances.requireInstanceFields().requireInstanceFields();
        List knnInputs = nearestNeighborModel.requireKNNInputs().requireKNNInputs();
    }

    @Override
    public String getSummary() {
        return "k-Nearest neighbors model";
    }

    @Override
    public DefaultDataField getDefaultDataField() {
        MiningFunction miningFunction = this.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: 
            case CLASSIFICATION: 
            case MIXED: {
                return null;
            }
        }
        return super.getDefaultDataField();
    }

    @Override
    protected <V extends Number> Map<String, AffinityDistribution<V>> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateMixed(valueFactory, context);
    }

    @Override
    protected <V extends Number> Map<String, AffinityDistribution<V>> evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateMixed(valueFactory, context);
    }

    @Override
    protected <V extends Number> Map<String, AffinityDistribution<V>> evaluateMixed(ValueFactory<V> valueFactory, EvaluationContext context) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        Table<Integer, String, FieldValue> table = this.getTrainingInstances();
        List<InstanceResult<V>> instanceResults = this.evaluateInstanceRows(valueFactory, context);
        Ordering ordering = Ordering.natural().reverse();
        List<InstanceResult<V>> nearestInstanceResults = ordering.sortedCopy(instanceResults);
        Integer numberOfNeighbors = nearestNeighborModel.requireNumberOfNeighbors();
        nearestInstanceResults = nearestInstanceResults.subList(0, numberOfNeighbors);
        Function<Integer, String> function = new Function<Integer, String>(){

            public String apply(Integer row) {
                return row.toString();
            }
        };
        String instanceIdVariable = nearestNeighborModel.getInstanceIdVariable();
        if (instanceIdVariable != null) {
            function = this.createIdentifierResolver(instanceIdVariable, table);
        }
        LinkedHashMap<String, AffinityDistribution<AffinityDistribution<V>>> results = new LinkedHashMap<String, AffinityDistribution<AffinityDistribution<V>>>();
        List<TargetField> targetFields = this.getTargetFields();
        for (TargetField targetField : targetFields) {
            Object value;
            String name = targetField.getFieldName();
            OpType opType = targetField.getOpType();
            switch (opType) {
                case CONTINUOUS: {
                    value = this.calculateContinuousTarget(valueFactory, name, nearestInstanceResults, table);
                    break;
                }
                case CATEGORICAL: {
                    value = this.calculateCategoricalTarget(valueFactory, name, nearestInstanceResults, table);
                    break;
                }
                default: {
                    throw new InvalidElementException((PMMLObject)nearestNeighborModel);
                }
            }
            value = TypeUtil.parseOrCast(targetField.getDataType(), value);
            AffinityDistribution<V> result = this.createAffinityDistribution(instanceResults, function, value);
            results.put(name, result);
        }
        return results;
    }

    @Override
    protected <V extends Number> Map<String, AffinityDistribution<V>> evaluateClustering(ValueFactory<V> valueFactory, EvaluationContext context) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        Table<Integer, String, FieldValue> table = this.getTrainingInstances();
        List<InstanceResult<V>> instanceResults = this.evaluateInstanceRows(valueFactory, context);
        String instanceIdVariable = nearestNeighborModel.getInstanceIdVariable();
        if (instanceIdVariable == null) {
            throw new MissingAttributeException((PMMLObject)nearestNeighborModel, PMMLAttributes.NEARESTNEIGHBORMODEL_INSTANCEIDVARIABLE);
        }
        Function<Integer, String> function = this.createIdentifierResolver(instanceIdVariable, table);
        AffinityDistribution<V> result = this.createAffinityDistribution(instanceResults, function, null);
        return Collections.singletonMap(this.getTargetName(), result);
    }

    private <V extends Number> List<InstanceResult<V>> evaluateInstanceRows(ValueFactory<V> valueFactory, EvaluationContext context) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        ComparisonMeasure comparisonMeasure = nearestNeighborModel.requireComparisonMeasure();
        ArrayList<FieldValue> values = new ArrayList<FieldValue>();
        KNNInputs knnInputs = nearestNeighborModel.requireKNNInputs();
        for (KNNInput knnInput : knnInputs) {
            FieldValue value = context.evaluate(knnInput.requireField());
            values.add(value);
        }
        Measure measure = comparisonMeasure.requireMeasure();
        if (measure instanceof Similarity) {
            return this.evaluateSimilarity(valueFactory, comparisonMeasure, knnInputs.getKNNInputs(), values);
        }
        if (measure instanceof Distance) {
            return this.evaluateDistance(valueFactory, comparisonMeasure, knnInputs.getKNNInputs(), values);
        }
        throw new UnsupportedElementException((PMMLObject)measure);
    }

    private <V extends Number> List<InstanceResult<V>> evaluateSimilarity(ValueFactory<V> valueFactory, ComparisonMeasure comparisonMeasure, List<KNNInput> knnInputs, List<FieldValue> values) {
        BitSet flags = MeasureUtil.toBitSet(values);
        Map<Integer, ?> centroidMap = this.getTrainingInstanceCentroids();
        ArrayList<InstanceResult<V>> result = new ArrayList<InstanceResult<V>>(centroidMap.size());
        Set<Integer> rowKeys = centroidMap.keySet();
        for (Integer rowKey : rowKeys) {
            BitSet instanceFlags = (BitSet)centroidMap.get(rowKey);
            Value<V> similarity = MeasureUtil.evaluateSimilarity(valueFactory, comparisonMeasure, knnInputs, flags, instanceFlags);
            result.add(new InstanceResult.Similarity(rowKey, similarity));
        }
        return result;
    }

    private <V extends Number> List<InstanceResult<V>> evaluateDistance(ValueFactory<V> valueFactory, ComparisonMeasure comparisonMeasure, List<KNNInput> knnInputs, List<FieldValue> values) {
        Map<Integer, ?> centroidMap = this.getTrainingInstanceCentroids();
        ArrayList<InstanceResult<V>> result = new ArrayList<InstanceResult<V>>(centroidMap.size());
        Value<V> adjustment = MeasureUtil.calculateAdjustment(valueFactory, values);
        Set<Integer> rowKeys = centroidMap.keySet();
        for (Integer rowKey : rowKeys) {
            List instanceValues = (List)centroidMap.get(rowKey);
            Value<V> distance = MeasureUtil.evaluateDistance(valueFactory, comparisonMeasure, knnInputs, values, instanceValues, adjustment);
            result.add(new InstanceResult.Distance(rowKey, distance));
        }
        return result;
    }

    private <V extends Number> V calculateContinuousTarget(ValueFactory<V> valueFactory, String name, List<InstanceResult<V>> instanceResults, Table<Integer, String, FieldValue> table) {
        ValueAggregator aggregator;
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        Number threshold = nearestNeighborModel.getThreshold();
        NearestNeighborModel.ContinuousScoringMethod continuousScoringMethod = nearestNeighborModel.getContinuousScoringMethod();
        switch (continuousScoringMethod) {
            case AVERAGE: {
                aggregator = new ValueAggregator.UnivariateStatistic<V>(valueFactory);
                break;
            }
            case WEIGHTED_AVERAGE: {
                aggregator = new ValueAggregator.WeightedUnivariateStatistic<V>(valueFactory);
                break;
            }
            case MEDIAN: {
                aggregator = new ValueAggregator.Median<V>(valueFactory, instanceResults.size());
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)nearestNeighborModel, (Enum<?>)continuousScoringMethod);
            }
        }
        block14: for (InstanceResult<V> instanceResult : instanceResults) {
            FieldValue value = (FieldValue)table.get((Object)instanceResult.getId(), (Object)name);
            if (FieldValueUtil.isMissing(value)) {
                throw new MissingFieldValueException(name);
            }
            Number targetValue = value.asNumber();
            switch (continuousScoringMethod) {
                case AVERAGE: 
                case MEDIAN: {
                    aggregator.add(targetValue);
                    continue block14;
                }
                case WEIGHTED_AVERAGE: {
                    InstanceResult.Distance distance = TypeUtil.cast(InstanceResult.Distance.class, instanceResult);
                    Value weight = distance.getWeight(threshold);
                    aggregator.add(targetValue, (Number)weight.getValue());
                    continue block14;
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)nearestNeighborModel, (Enum<?>)continuousScoringMethod);
        }
        switch (continuousScoringMethod) {
            case AVERAGE: {
                return aggregator.average().getValue();
            }
            case WEIGHTED_AVERAGE: {
                return aggregator.weightedAverage().getValue();
            }
            case MEDIAN: {
                return aggregator.median().getValue();
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)nearestNeighborModel, (Enum<?>)continuousScoringMethod);
    }

    private <V extends Number> Object calculateCategoricalTarget(ValueFactory<V> valueFactory, String name, List<InstanceResult<V>> instanceResults, Table<Integer, String, FieldValue> table) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        Number threshold = nearestNeighborModel.getThreshold();
        VoteAggregator<Object, V> aggregator = new VoteAggregator<Object, V>(valueFactory);
        NearestNeighborModel.CategoricalScoringMethod categoricalScoringMethod = nearestNeighborModel.getCategoricalScoringMethod();
        block4: for (InstanceResult<V> instanceResult : instanceResults) {
            FieldValue value = (FieldValue)table.get((Object)instanceResult.getId(), (Object)name);
            if (FieldValueUtil.isMissing(value)) {
                throw new MissingFieldValueException(name);
            }
            Object targetValue = value.getValue();
            switch (categoricalScoringMethod) {
                case MAJORITY_VOTE: {
                    aggregator.add(targetValue);
                    continue block4;
                }
                case WEIGHTED_MAJORITY_VOTE: {
                    InstanceResult.Distance distance = TypeUtil.cast(InstanceResult.Distance.class, instanceResult);
                    Value weight = distance.getWeight(threshold);
                    aggregator.add(targetValue, (Number)weight.getValue());
                    continue block4;
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)nearestNeighborModel, (Enum<?>)categoricalScoringMethod);
        }
        Set winners = aggregator.getWinners();
        if (winners.size() > 1) {
            LinkedHashMultiset multiset = LinkedHashMultiset.create();
            Map column = table.column((Object)name);
            multiset.addAll(Collections2.transform(column.values(), FieldValue::getValue));
            aggregator.clear();
            for (Object winner : winners) {
                aggregator.add(winner, multiset.count(winner));
            }
            winners = aggregator.getWinners();
            if (winners.size() > 1) {
                return Collections.min(winners);
            }
        }
        return Iterables.getFirst(winners, null);
    }

    private Function<Integer, String> createIdentifierResolver(final String name, final Table<Integer, String, FieldValue> table) {
        Function<Integer, String> function = new Function<Integer, String>(){

            public String apply(Integer row) {
                FieldValue value = (FieldValue)table.get((Object)row, (Object)name);
                if (FieldValueUtil.isMissing(value)) {
                    throw new MissingFieldValueException(name);
                }
                return value.asString();
            }
        };
        return function;
    }

    private <V extends Number> AffinityDistribution<V> createAffinityDistribution(List<InstanceResult<V>> instanceResults, Function<Integer, String> function, Object result) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        ComparisonMeasure comparisonMeasure = nearestNeighborModel.requireComparisonMeasure();
        ValueMap<Object, Value<V>> values = new ValueMap<Object, Value<V>>(2 * instanceResults.size());
        for (InstanceResult<V> instanceResult : instanceResults) {
            values.put(function.apply((Object)instanceResult.getId()), instanceResult.getValue());
        }
        Measure measure = comparisonMeasure.requireMeasure();
        if (measure instanceof Similarity) {
            return new AffinityDistribution(Classification.Type.SIMILARITY, values, result);
        }
        if (measure instanceof Distance) {
            return new AffinityDistribution(Classification.Type.DISTANCE, values, result);
        }
        throw new UnsupportedElementException((PMMLObject)measure);
    }

    private Table<Integer, String, FieldValue> getTrainingInstances() {
        if (this.trainingInstances == null) {
            this.trainingInstances = ImmutableTable.copyOf(NearestNeighborModelEvaluator.parseTrainingInstances(this));
        }
        return this.trainingInstances;
    }

    private Map<Integer, ?> getTrainingInstanceCentroids() {
        if (this.trainingInstanceCentroids == null) {
            NearestNeighborModel nearestNeightborModel = (NearestNeighborModel)this.getModel();
            ComparisonMeasure comparisonMeasure = nearestNeightborModel.requireComparisonMeasure();
            Map<Integer, List<FieldValue>> trainingInstanceValues = NearestNeighborModelEvaluator.parseTrainingInstanceValues(this);
            Measure measure = comparisonMeasure.requireMeasure();
            if (measure instanceof Distance) {
                this.trainingInstanceCentroids = ImmutableMap.copyOf(NearestNeighborModelEvaluator.toImmutableListMap(trainingInstanceValues));
            } else if (measure instanceof Similarity) {
                Function<List<FieldValue>, BitSet> function = new Function<List<FieldValue>, BitSet>(){

                    public BitSet apply(List<FieldValue> values) {
                        return MeasureUtil.toBitSet(values);
                    }
                };
                this.trainingInstanceCentroids = ImmutableMap.copyOf((Map)Maps.transformValues(trainingInstanceValues, (Function)function));
            }
        }
        return this.trainingInstanceCentroids;
    }

    private static Table<Integer, String, FieldValue> parseTrainingInstances(NearestNeighborModelEvaluator modelEvaluator) {
        Iterator field;
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)modelEvaluator.getModel();
        String instanceIdVariable = nearestNeighborModel.getInstanceIdVariable();
        HashSet<String> names = new HashSet<String>();
        names.addAll(ActiveFieldFinder.getFieldNames((PMMLObject[])new PMMLObject[]{nearestNeighborModel}));
        List<TargetField> targetFields = modelEvaluator.getTargetFields();
        for (TargetField targetField : targetFields) {
            names.add(targetField.getFieldName());
        }
        TrainingInstances trainingInstances = nearestNeighborModel.requireTrainingInstances();
        ArrayList<FieldLoader> fieldLoaders = new ArrayList<FieldLoader>();
        InstanceFields instanceFields = trainingInstances.getInstanceFields();
        for (InstanceField instanceField : instanceFields) {
            String fieldName = instanceField.requireField();
            String column = instanceField.getColumn();
            if (instanceIdVariable != null && instanceIdVariable.equals(fieldName)) {
                fieldLoaders.add(new IdentifierLoader(fieldName, column));
                continue;
            }
            if (!names.contains(fieldName)) continue;
            field = modelEvaluator.resolveField(fieldName);
            if (field == null) {
                throw new MissingFieldException(instanceField);
            }
            if (field instanceof DataField) {
                DataField dataField = (DataField)field;
                MiningField miningField = modelEvaluator.getMiningField(fieldName);
                if (miningField == null) {
                    throw new InvisibleFieldException(instanceField);
                }
                fieldLoaders.add(new DataFieldLoader(fieldName, column, dataField, miningField));
                continue;
            }
            if (field instanceof DerivedField) {
                DerivedField derivedField = (DerivedField)field;
                boolean inherited = modelEvaluator.getDerivedField(fieldName) == null && modelEvaluator.getLocalDerivedField(fieldName) == null;
                MiningField miningField = modelEvaluator.getMiningField(fieldName);
                if (miningField == null && inherited) {
                    throw new InvisibleFieldException(instanceField);
                }
                fieldLoaders.add(new DerivedFieldLoader(fieldName, column, derivedField, miningField));
                continue;
            }
            throw new InvalidAttributeException((PMMLObject)instanceField, PMMLAttributes.INSTANCEFIELD_FIELD, (Object)fieldName);
        }
        HashBasedTable result = HashBasedTable.create();
        InlineTable inlineTable = InlineTableUtil.getInlineTable(trainingInstances);
        if (inlineTable != null) {
            Table<Integer, String, Object> table = InlineTableUtil.getContent(inlineTable);
            Set rowKeys = table.rowKeySet();
            field = rowKeys.iterator();
            while (field.hasNext()) {
                Integer rowKey = (Integer)field.next();
                Map rowValues = table.row((Object)rowKey);
                for (FieldLoader fieldLoader : fieldLoaders) {
                    result.put((Object)rowKey, (Object)fieldLoader.getName(), (Object)fieldLoader.load(rowValues));
                }
            }
        }
        KNNInputs knnInputs = nearestNeighborModel.requireKNNInputs();
        for (KNNInput knnInput : knnInputs) {
            String fieldName = knnInput.requireField();
            Field<?> field2 = modelEvaluator.resolveField(fieldName);
            if (!(field2 instanceof DerivedField)) continue;
            DerivedField derivedField = (DerivedField)field2;
            Set rowKeys = result.rowKeySet();
            for (Integer rowKey : rowKeys) {
                Map rowValues = result.row((Object)rowKey);
                if (rowValues.containsKey(fieldName)) continue;
                ModelEvaluationContext context = modelEvaluator.createEvaluationContext();
                context.declareAll(rowValues);
                FieldValue value = ExpressionUtil.evaluate(derivedField, (EvaluationContext)context);
                result.put((Object)rowKey, (Object)fieldName, (Object)value);
            }
        }
        Integer numberOfNeighbors = nearestNeighborModel.requireNumberOfNeighbors();
        if (numberOfNeighbors < 0 || result.size() < numberOfNeighbors) {
            throw new InvalidAttributeException((PMMLObject)nearestNeighborModel, PMMLAttributes.NEARESTNEIGHBORMODEL_NUMBEROFNEIGHBORS, (Object)numberOfNeighbors);
        }
        return result;
    }

    private static Map<Integer, List<FieldValue>> parseTrainingInstanceValues(NearestNeighborModelEvaluator modelEvaluator) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)modelEvaluator.getModel();
        LinkedHashMap<Integer, List<FieldValue>> result = new LinkedHashMap<Integer, List<FieldValue>>();
        Table<Integer, String, FieldValue> table = modelEvaluator.getTrainingInstances();
        KNNInputs knnInputs = nearestNeighborModel.requireKNNInputs();
        ImmutableSortedSet rowKeys = ImmutableSortedSet.copyOf((Collection)table.rowKeySet());
        for (Integer rowKey : rowKeys) {
            ArrayList<FieldValue> values = new ArrayList<FieldValue>();
            Map rowValues = table.row((Object)rowKey);
            for (KNNInput knnInput : knnInputs) {
                FieldValue value = (FieldValue)rowValues.get(knnInput.requireField());
                values.add(value);
            }
            result.put(rowKey, values);
        }
        return result;
    }

    private static abstract class InstanceResult<V extends Number>
    implements Comparable<InstanceResult<V>> {
        private Integer id = null;
        private Value<V> value = null;

        private InstanceResult(Integer id, Value<V> value) {
            this.setId(id);
            this.setValue(value);
        }

        public Integer getId() {
            return this.id;
        }

        private void setId(Integer id) {
            this.id = id;
        }

        public Value<V> getValue() {
            return this.value;
        }

        private void setValue(Value<V> value) {
            this.value = value;
        }

        private static class Distance<V extends Number>
        extends InstanceResult<V> {
            private Distance(Integer id, Value<V> value) {
                super(id, value);
            }

            @Override
            public int compareTo(InstanceResult<V> that) {
                if (that instanceof Distance) {
                    return Classification.Type.DISTANCE.compareValues(this.getValue(), that.getValue());
                }
                throw new ClassCastException();
            }

            public Value<V> getWeight(Number threshold) {
                Value value = this.getValue();
                value = value.copy();
                value.add(threshold).reciprocal();
                return value;
            }
        }

        private static class Similarity<V extends Number>
        extends InstanceResult<V> {
            private Similarity(Integer id, Value<V> value) {
                super(id, value);
            }

            @Override
            public int compareTo(InstanceResult<V> that) {
                if (that instanceof Similarity) {
                    return Classification.Type.SIMILARITY.compareValues(this.getValue(), that.getValue());
                }
                throw new ClassCastException();
            }
        }
    }

    private static class DerivedFieldLoader
    extends FieldLoader {
        private DerivedField derivedField = null;
        private MiningField miningField = null;

        private DerivedFieldLoader(String name, String column, DerivedField derivedField, MiningField miningField) {
            super(name, column);
            this.setDerivedField(derivedField);
            this.setMiningField(miningField);
        }

        @Override
        public FieldValue prepare(Object value) {
            final DerivedField derivedField = this.getDerivedField();
            MiningField miningField = this.getMiningField();
            if (miningField != null) {
                return InputFieldUtil.prepareInputValue(derivedField, miningField, value);
            }
            TypeInfo typeInfo = new TypeInfo(){

                @Override
                public OpType getOpType() {
                    return derivedField.requireOpType();
                }

                @Override
                public DataType getDataType() {
                    return derivedField.requireDataType();
                }

                @Override
                public List<?> getOrdering() {
                    List<?> ordering = FieldUtil.getValidValues(derivedField);
                    return ordering;
                }
            };
            return FieldValueUtil.create(typeInfo, value);
        }

        public DerivedField getDerivedField() {
            return this.derivedField;
        }

        private void setDerivedField(DerivedField derivedField) {
            this.derivedField = derivedField;
        }

        public MiningField getMiningField() {
            return this.miningField;
        }

        private void setMiningField(MiningField miningField) {
            this.miningField = miningField;
        }
    }

    private static class DataFieldLoader
    extends FieldLoader {
        private DataField dataField = null;
        private MiningField miningField = null;

        private DataFieldLoader(String name, String column, DataField dataField, MiningField miningField) {
            super(name, column);
            this.setDataField(dataField);
            this.setMiningField(miningField);
        }

        @Override
        public FieldValue prepare(Object value) {
            return InputFieldUtil.prepareInputValue(this.getDataField(), this.getMiningField(), value);
        }

        public DataField getDataField() {
            return this.dataField;
        }

        private void setDataField(DataField dataField) {
            this.dataField = dataField;
        }

        public MiningField getMiningField() {
            return this.miningField;
        }

        private void setMiningField(MiningField miningField) {
            this.miningField = miningField;
        }
    }

    private static class IdentifierLoader
    extends FieldLoader {
        private IdentifierLoader(String name, String column) {
            super(name, column);
        }

        @Override
        public FieldValue prepare(Object value) {
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, value);
        }
    }

    private static abstract class FieldLoader {
        private String name = null;
        private String column = null;

        private FieldLoader(String name, String column) {
            this.setName(name);
            this.setColumn(column);
        }

        public abstract FieldValue prepare(Object var1);

        public FieldValue load(Map<String, Object> values) {
            Object value = values.get(this.getColumn());
            return this.prepare(value);
        }

        public String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        public String getColumn() {
            return this.column;
        }

        private void setColumn(String column) {
            this.column = column;
        }
    }
}

