/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.neural_network;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.neural_network.Connection;
import org.dmg.pmml.neural_network.NeuralEntity;
import org.dmg.pmml.neural_network.NeuralInput;
import org.dmg.pmml.neural_network.NeuralInputs;
import org.dmg.pmml.neural_network.NeuralLayer;
import org.dmg.pmml.neural_network.NeuralNetwork;
import org.dmg.pmml.neural_network.NeuralOutput;
import org.dmg.pmml.neural_network.NeuralOutputs;
import org.dmg.pmml.neural_network.Neuron;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.NormalizationUtil;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.neural_network.NeuralNetworkUtil;
import org.jpmml.evaluator.neural_network.NeuronProbabilityDistribution;
import org.jpmml.model.InvalidAttributeException;
import org.jpmml.model.InvalidElementException;
import org.jpmml.model.InvalidElementListException;
import org.jpmml.model.MisplacedElementException;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.visitors.AbstractVisitor;

public class NeuralNetworkEvaluator
extends ModelEvaluator<NeuralNetwork>
implements HasEntityRegistry<NeuralEntity> {
    private BiMap<String, NeuralEntity> entityRegistry = ImmutableBiMap.of();
    private Map<String, List<NeuralOutput>> neuralOutputMap = null;

    private NeuralNetworkEvaluator() {
    }

    public NeuralNetworkEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, NeuralNetwork.class));
    }

    public NeuralNetworkEvaluator(PMML pmml, NeuralNetwork neuralNetwork) {
        super(pmml, neuralNetwork);
        List neuralInputs = neuralNetwork.requireNeuralInputs().requireNeuralInputs();
        List neuralLayers = neuralNetwork.requireNeuralLayers();
        List<NeuralEntity> neuralEntities = NeuralNetworkEvaluator.collectNeuralEntities(neuralNetwork);
        this.entityRegistry = ImmutableBiMap.copyOf(EntityUtil.buildBiMap(neuralEntities));
        List neuralOutputs = neuralNetwork.requireNeuralOutputs().requireNeuralOutputs();
    }

    @Override
    public String getSummary() {
        return "Neural network";
    }

    @Override
    public BiMap<String, NeuralEntity> getEntityRegistry() {
        return this.entityRegistry;
    }

    @Override
    protected <V extends Number> Map<String, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        List<TargetField> targetFields = this.getTargetFields();
        ValueMap<String, V> values = this.evaluateRaw(valueFactory, context);
        if (values == null) {
            if (targetFields.size() == 1) {
                TargetField targetField = targetFields.get(0);
                return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
            }
            LinkedHashMap results = new LinkedHashMap();
            for (TargetField targetField : targetFields) {
                results.putAll(TargetUtil.evaluateRegressionDefault(valueFactory, targetField));
            }
            return results;
        }
        Map<String, List<NeuralOutput>> neuralOutputMap = this.getNeuralOutputMap();
        LinkedHashMap results = null;
        for (TargetField targetField : targetFields) {
            String name = targetField.getFieldName();
            List<NeuralOutput> neuralOutputs = neuralOutputMap.get(name);
            if (neuralOutputs == null) {
                throw new InvalidElementException((PMMLObject)neuralNetwork);
            }
            if (neuralOutputs.size() != 1) {
                throw new InvalidElementListException(neuralOutputs);
            }
            NeuralOutput neuralOutput = neuralOutputs.get(0);
            String id = neuralOutput.requireOutputNeuron();
            Value value = (Value)values.get(id);
            if (value == null) {
                throw new InvalidAttributeException((PMMLObject)neuralOutput, org.dmg.pmml.neural_network.PMMLAttributes.NEURALOUTPUT_OUTPUTNEURON, (Object)id);
            }
            value = value.copy();
            Expression expression = this.getOutputExpression(neuralOutput);
            if (!(expression instanceof FieldRef)) {
                if (expression instanceof NormContinuous) {
                    NormContinuous normContinuous = (NormContinuous)expression;
                    NormalizationUtil.denormalize(normContinuous, value);
                } else {
                    throw new MisplacedElementException((PMMLObject)expression);
                }
            }
            if (targetFields.size() == 1) {
                return TargetUtil.evaluateRegression(targetField, value);
            }
            if (results == null) {
                results = new LinkedHashMap();
            }
            results.putAll(TargetUtil.evaluateRegression(targetField, value));
        }
        return results;
    }

    @Override
    protected <V extends Number> Map<String, ? extends Classification<?, V>> evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        List<TargetField> targetFields = this.getTargetFields();
        ValueMap<String, V> values = this.evaluateRaw(valueFactory, context);
        if (values == null) {
            if (targetFields.size() == 1) {
                TargetField targetField = targetFields.get(0);
                return TargetUtil.evaluateClassificationDefault(valueFactory, targetField);
            }
            LinkedHashMap results = new LinkedHashMap();
            for (TargetField targetField : targetFields) {
                results.putAll(TargetUtil.evaluateClassificationDefault(valueFactory, targetField));
            }
            return results;
        }
        Map<String, List<NeuralOutput>> neuralOutputMap = this.getNeuralOutputMap();
        final BiMap<String, NeuralEntity> entityRegistry = this.getEntityRegistry();
        LinkedHashMap results = null;
        for (TargetField targetField : targetFields) {
            String name = targetField.getFieldName();
            List<NeuralOutput> neuralOutputs = neuralOutputMap.get(name);
            if (neuralOutputs == null) {
                throw new InvalidElementException((PMMLObject)neuralNetwork);
            }
            NeuronProbabilityDistribution result = new NeuronProbabilityDistribution<V>(new ValueMap(2 * neuralOutputs.size())){

                @Override
                public BiMap<String, NeuralEntity> getEntityRegistry() {
                    return entityRegistry;
                }
            };
            for (NeuralOutput neuralOutput : neuralOutputs) {
                String id = neuralOutput.requireOutputNeuron();
                NeuralEntity entity = (NeuralEntity)entityRegistry.get((Object)id);
                if (entity == null) {
                    throw new InvalidAttributeException((PMMLObject)neuralOutput, org.dmg.pmml.neural_network.PMMLAttributes.NEURALOUTPUT_OUTPUTNEURON, (Object)id);
                }
                Value value = (Value)values.get(id);
                if (value == null) {
                    throw new InvalidAttributeException((PMMLObject)neuralOutput, org.dmg.pmml.neural_network.PMMLAttributes.NEURALOUTPUT_OUTPUTNEURON, (Object)id);
                }
                Expression expression = this.getOutputExpression(neuralOutput);
                if (expression instanceof NormDiscrete) {
                    NormDiscrete normDiscrete = (NormDiscrete)expression;
                    Object targetCategory = normDiscrete.requireValue();
                    result.put(entity, targetCategory, value);
                    continue;
                }
                throw new MisplacedElementException((PMMLObject)expression);
            }
            if (targetFields.size() == 1) {
                return TargetUtil.evaluateClassification(targetField, result);
            }
            if (results == null) {
                results = new LinkedHashMap();
            }
            results.putAll(TargetUtil.evaluateClassification(targetField, result));
        }
        return results;
    }

    private Expression getOutputExpression(NeuralOutput neuralOutput) {
        DerivedField derivedField = neuralOutput.requireDerivedField();
        Expression expression = derivedField.requireExpression();
        if (expression instanceof FieldRef) {
            FieldRef fieldRef = (FieldRef)expression;
            String fieldName = fieldRef.requireField();
            Field<?> field = this.resolveField(fieldName);
            if (field == null) {
                throw new MissingFieldException(fieldRef);
            }
            if (field instanceof DataField) {
                return expression;
            }
            if (field instanceof DerivedField) {
                DerivedField targetDerivedField = (DerivedField)field;
                return targetDerivedField.requireExpression();
            }
            throw new InvalidAttributeException((PMMLObject)fieldRef, PMMLAttributes.FIELDREF_FIELD, (Object)fieldName);
        }
        return expression;
    }

    private <V extends Number> ValueMap<String, V> evaluateRaw(ValueFactory<V> valueFactory, EvaluationContext context) {
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        BiMap<String, NeuralEntity> entityRegistry = this.getEntityRegistry();
        ValueMap<String, Value<V>> result = new ValueMap<String, Value<V>>(2 * entityRegistry.size());
        NeuralInputs neuralInputs = neuralNetwork.requireNeuralInputs();
        for (NeuralInput neuralInput : neuralInputs) {
            DerivedField derivedField = neuralInput.requireDerivedField();
            FieldValue value = ExpressionUtil.evaluateTypedExpressionContainer(derivedField, context);
            if (FieldValueUtil.isMissing(value)) {
                return null;
            }
            Value<V> output = valueFactory.newValue(value.asNumber());
            result.put(neuralInput.requireId(), output);
        }
        ArrayList outputs = new ArrayList();
        List neuralLayers = neuralNetwork.requireNeuralLayers();
        block16: for (NeuralLayer neuralLayer : neuralLayers) {
            outputs.clear();
            NeuralLayer locatable = neuralLayer;
            NeuralNetwork.ActivationFunction activationFunction = neuralLayer.getActivationFunction();
            if (activationFunction == null) {
                locatable = neuralNetwork;
                activationFunction = neuralNetwork.requireActivationFunction();
            }
            Number threshold = null;
            Number leakage = null;
            Number altitude = null;
            Number width = null;
            switch (activationFunction) {
                case THRESHOLD: 
                case LOGISTIC: 
                case TANH: 
                case IDENTITY: 
                case EXPONENTIAL: 
                case RECIPROCAL: 
                case SQUARE: 
                case GAUSS: 
                case SINE: 
                case COSINE: 
                case ELLIOTT: 
                case ARCTAN: 
                case RECTIFIER: {
                    threshold = neuralLayer.getThreshold();
                    if (threshold == null) {
                        threshold = neuralNetwork.getThreshold();
                    }
                    if ((leakage = neuralLayer.getLeakage()) != null) break;
                    leakage = neuralNetwork.getLeakage();
                    break;
                }
                case RADIAL_BASIS: {
                    altitude = neuralLayer.getAltitude();
                    if (altitude == null) {
                        altitude = neuralNetwork.getAltitude();
                    }
                    if ((width = neuralLayer.getWidth()) != null) break;
                    width = neuralNetwork.getWidth();
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)locatable, (Enum<?>)activationFunction);
                }
            }
            List neurons = neuralLayer.getNeurons();
            int max = neurons.size();
            for (int i = 0; i < max; ++i) {
                Neuron neuron = (Neuron)neurons.get(i);
                Value<V> output = valueFactory.newValue();
                List connections = neuron.requireConnections();
                block18: for (int j = 0; j < connections.size(); ++j) {
                    Connection connection = (Connection)connections.get(j);
                    String id = connection.requireFrom();
                    Number weight = connection.requireWeight();
                    Value input = (Value)result.get(id);
                    if (input == null) {
                        throw new InvalidAttributeException((PMMLObject)connection, org.dmg.pmml.neural_network.PMMLAttributes.CONNECTION_FROM, (Object)id);
                    }
                    switch (activationFunction) {
                        case THRESHOLD: 
                        case LOGISTIC: 
                        case TANH: 
                        case IDENTITY: 
                        case EXPONENTIAL: 
                        case RECIPROCAL: 
                        case SQUARE: 
                        case GAUSS: 
                        case SINE: 
                        case COSINE: 
                        case ELLIOTT: 
                        case ARCTAN: 
                        case RECTIFIER: {
                            output.add(weight, (Number)input.getValue());
                            continue block18;
                        }
                        case RADIAL_BASIS: {
                            input = input.copy();
                            output.add(input.subtract(weight).square());
                            continue block18;
                        }
                        default: {
                            throw new UnsupportedAttributeException((PMMLObject)locatable, (Enum<?>)activationFunction);
                        }
                    }
                }
                switch (activationFunction) {
                    case THRESHOLD: 
                    case LOGISTIC: 
                    case TANH: 
                    case IDENTITY: 
                    case EXPONENTIAL: 
                    case RECIPROCAL: 
                    case SQUARE: 
                    case GAUSS: 
                    case SINE: 
                    case COSINE: 
                    case ELLIOTT: 
                    case ARCTAN: 
                    case RECTIFIER: {
                        Number neuronBias = neuron.getBias();
                        if (neuronBias != null) {
                            output.add(neuronBias);
                        }
                        NeuralNetworkUtil.activateNeuronOutput(activationFunction, threshold, leakage, output);
                        break;
                    }
                    case RADIAL_BASIS: {
                        Number neuronWidth = neuron.getWidth();
                        if (neuronWidth == null) {
                            if (width == null) {
                                throw new MissingAttributeException((PMMLObject)neuralNetwork, org.dmg.pmml.neural_network.PMMLAttributes.NEURALNETWORK_WIDTH);
                            }
                            neuronWidth = width;
                        }
                        Value<V> denominator = valueFactory.newValue(neuronWidth).square().multiply(Numbers.DOUBLE_MINUS_TWO);
                        output.divide(denominator);
                        if (altitude.doubleValue() != 1.0) {
                            Value<V> value = valueFactory.newValue(altitude).ln().multiply(connections.size());
                            output.add(value);
                        }
                        output.exp();
                        break;
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)locatable, (Enum<?>)activationFunction);
                    }
                }
                result.put(neuron.requireId(), output);
                outputs.add(output);
            }
            locatable = neuralLayer;
            NeuralNetwork.NormalizationMethod normalizationMethod = neuralLayer.getNormalizationMethod();
            if (normalizationMethod == null) {
                locatable = neuralNetwork;
                normalizationMethod = neuralNetwork.getNormalizationMethod();
            }
            switch (normalizationMethod) {
                case NONE: 
                case SIMPLEMAX: 
                case SOFTMAX: {
                    NeuralNetworkUtil.normalizeNeuralLayerOutputs(normalizationMethod, outputs);
                    continue block16;
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)locatable, (Enum<?>)normalizationMethod);
        }
        return result;
    }

    private Map<String, List<NeuralOutput>> getNeuralOutputMap() {
        if (this.neuralOutputMap == null) {
            this.neuralOutputMap = ImmutableMap.copyOf(NeuralNetworkEvaluator.toImmutableListMap(this.parseNeuralOutputs()));
        }
        return this.neuralOutputMap;
    }

    private Map<String, List<NeuralOutput>> parseNeuralOutputs() {
        NeuralNetwork neuralNetwork = (NeuralNetwork)this.getModel();
        ArrayListMultimap result = ArrayListMultimap.create();
        NeuralOutputs neuralOutputs = neuralNetwork.requireNeuralOutputs();
        for (NeuralOutput neuralOutput : neuralOutputs) {
            Expression expression = this.getOutputExpression(neuralOutput);
            if (expression instanceof HasFieldReference) {
                HasFieldReference hasFieldReference = (HasFieldReference)expression;
                result.put((Object)hasFieldReference.requireField(), (Object)neuralOutput);
                continue;
            }
            throw new MisplacedElementException((PMMLObject)expression);
        }
        return new LinkedHashMap<String, List<NeuralOutput>>(Multimaps.asMap((ListMultimap)result));
    }

    private static List<NeuralEntity> collectNeuralEntities(NeuralNetwork neuralNetwork) {
        final ArrayList<NeuralEntity> result = new ArrayList<NeuralEntity>();
        AbstractVisitor visitor = new AbstractVisitor(){

            public VisitorAction visit(NeuralEntity neuralEntity) {
                result.add(neuralEntity);
                return super.visit(neuralEntity);
            }
        };
        visitor.applyTo((Visitable)neuralNetwork);
        return result;
    }
}

