/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.False;
import org.dmg.pmml.HasPredicate;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.HasValueSet;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.JavaPredicate;
import org.jpmml.model.InvalidElementListException;
import org.jpmml.model.PMMLException;
import org.jpmml.model.UnsupportedAttributeException;
import org.jpmml.model.UnsupportedElementException;

public class PredicateUtil {
    private PredicateUtil() {
    }

    public static <E extends PMMLObject> Boolean evaluatePredicateContainer(E hasPredicate, EvaluationContext context) {
        return PredicateUtil.evaluate(((HasPredicate)hasPredicate).requirePredicate(), context);
    }

    public static Boolean evaluate(Predicate predicate, EvaluationContext context) {
        try {
            return PredicateUtil.evaluatePredicate(predicate, context);
        }
        catch (PMMLException pe) {
            throw pe.ensureContext((PMMLObject)predicate);
        }
    }

    static Boolean evaluatePredicate(Predicate predicate, EvaluationContext context) {
        if (predicate instanceof SimplePredicate) {
            return PredicateUtil.evaluateSimplePredicate((SimplePredicate)predicate, context);
        }
        if (predicate instanceof SimpleSetPredicate) {
            return PredicateUtil.evaluateSimpleSetPredicate((SimpleSetPredicate)predicate, context);
        }
        if (predicate instanceof CompoundPredicate) {
            return PredicateUtil.evaluateCompoundPredicate((CompoundPredicate)predicate, context);
        }
        if (predicate instanceof True) {
            return PredicateUtil.evaluateTrue((True)predicate);
        }
        if (predicate instanceof False) {
            return PredicateUtil.evaluateFalse((False)predicate);
        }
        if (predicate instanceof JavaPredicate) {
            return PredicateUtil.evaluateJavaPredicate((JavaPredicate)predicate, context);
        }
        throw new UnsupportedElementException((PMMLObject)predicate);
    }

    public static Boolean evaluateSimplePredicate(SimplePredicate simplePredicate, EvaluationContext context) {
        FieldValue value = context.evaluate(simplePredicate.requireField());
        SimplePredicate.Operator operator = simplePredicate.requireOperator();
        switch (operator) {
            case IS_MISSING: {
                return FieldValueUtil.isMissing(value);
            }
            case IS_NOT_MISSING: {
                return !FieldValueUtil.isMissing(value);
            }
        }
        if (FieldValueUtil.isMissing(value)) {
            return null;
        }
        switch (operator) {
            case EQUAL: {
                return value.equals((HasValue<?>)simplePredicate);
            }
            case NOT_EQUAL: {
                return !value.equals((HasValue<?>)simplePredicate);
            }
        }
        int order = value.compareTo((HasValue<?>)simplePredicate);
        switch (operator) {
            case LESS_THAN: {
                return order < 0;
            }
            case LESS_OR_EQUAL: {
                return order <= 0;
            }
            case GREATER_OR_EQUAL: {
                return order >= 0;
            }
            case GREATER_THAN: {
                return order > 0;
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)simplePredicate, (Enum)operator);
    }

    public static Boolean evaluateSimpleSetPredicate(SimpleSetPredicate simpleSetPredicate, EvaluationContext context) {
        FieldValue value = context.evaluate(simpleSetPredicate.requireField());
        if (FieldValueUtil.isMissing(value)) {
            return null;
        }
        SimpleSetPredicate.BooleanOperator booleanOperator = simpleSetPredicate.requireBooleanOperator();
        switch (booleanOperator) {
            case IS_IN: {
                return value.isIn((HasValueSet<?>)simpleSetPredicate);
            }
            case IS_NOT_IN: {
                return !value.isIn((HasValueSet<?>)simpleSetPredicate);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)simpleSetPredicate, (Enum)booleanOperator);
    }

    public static Boolean evaluateCompoundPredicate(CompoundPredicate compoundPredicate, EvaluationContext context) {
        CompoundPredicateResult result = PredicateUtil.evaluateCompoundPredicateInternal(compoundPredicate, context);
        return result.getResult();
    }

    public static CompoundPredicateResult evaluateCompoundPredicateInternal(CompoundPredicate compoundPredicate, EvaluationContext context) {
        List predicates = compoundPredicate.requirePredicates();
        if (predicates.size() < 2) {
            throw new InvalidElementListException(predicates);
        }
        Predicate predicate = (Predicate)predicates.get(0);
        Boolean result = PredicateUtil.evaluate(predicate, context);
        CompoundPredicate.BooleanOperator booleanOperator = compoundPredicate.requireBooleanOperator();
        switch (booleanOperator) {
            case AND: 
            case OR: 
            case XOR: {
                break;
            }
            case SURROGATE: {
                if (result == null) break;
                return new CompoundPredicateResult(result, false);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)compoundPredicate, (Enum)booleanOperator);
            }
        }
        int max = predicates.size();
        block10: for (int i = 1; i < max; ++i) {
            predicate = (Predicate)predicates.get(i);
            Boolean value = PredicateUtil.evaluate(predicate, context);
            switch (booleanOperator) {
                case AND: {
                    result = PredicateUtil.binaryAnd(result, value);
                    continue block10;
                }
                case OR: {
                    result = PredicateUtil.binaryOr(result, value);
                    continue block10;
                }
                case XOR: {
                    result = PredicateUtil.binaryXor(result, value);
                    continue block10;
                }
                case SURROGATE: {
                    if (value == null) continue block10;
                    return new CompoundPredicateResult(value, true);
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)compoundPredicate, (Enum)booleanOperator);
                }
            }
        }
        return new CompoundPredicateResult(result, false);
    }

    public static Boolean evaluateTrue(True truePredicate) {
        return Boolean.TRUE;
    }

    public static Boolean evaluateFalse(False falsePredicate) {
        return Boolean.FALSE;
    }

    public static Boolean evaluateJavaPredicate(JavaPredicate javaPredicate, EvaluationContext context) {
        Boolean result = javaPredicate.evaluate(context);
        return result;
    }

    public static Boolean binaryAnd(Boolean left, Boolean right) {
        if (left == null) {
            if (right == null || right.booleanValue()) {
                return null;
            }
            return Boolean.FALSE;
        }
        if (right == null) {
            if (left == null || left.booleanValue()) {
                return null;
            }
            return Boolean.FALSE;
        }
        return left & right;
    }

    public static Boolean binaryOr(Boolean left, Boolean right) {
        if (left != null && left.booleanValue()) {
            return Boolean.TRUE;
        }
        if (right != null && right.booleanValue()) {
            return Boolean.TRUE;
        }
        if (left == null || right == null) {
            return null;
        }
        return left | right;
    }

    public static Boolean binaryXor(Boolean left, Boolean right) {
        if (left == null || right == null) {
            return null;
        }
        return left ^ right;
    }

    public static class CompoundPredicateResult {
        private Boolean result = null;
        private boolean alternative = false;

        private CompoundPredicateResult(Boolean result, boolean alternative) {
            this.setResult(result);
            this.setAlternative(alternative);
        }

        public Boolean getResult() {
            return this.result;
        }

        private void setResult(Boolean result) {
            this.result = result;
        }

        public boolean isAlternative() {
            return this.alternative;
        }

        private void setAlternative(boolean alternative) {
            this.alternative = alternative;
        }
    }
}

