/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jpmml.evaluator.KeyValueAggregator;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.Vector;

public class VoteAggregator<K, V extends Number>
extends KeyValueAggregator<K, V> {
    public VoteAggregator(ValueFactory<V> valueFactory) {
        super(valueFactory, 0);
    }

    public void add(K key) {
        this.add(key, Numbers.DOUBLE_ONE);
    }

    public ValueMap<K, V> sumMap() {
        return new ValueMap(this.asTransformedMap(Vector::sum));
    }

    public Set<K> getWinners() {
        LinkedHashSet result = new LinkedHashSet();
        ValueMap<K, V> sumMap = this.sumMap();
        Value maxValue = (Value)Collections.max(sumMap.values());
        Set entries = sumMap.entrySet();
        for (Map.Entry entry : entries) {
            Object key = entry.getKey();
            Value value = (Value)entry.getValue();
            if (maxValue.compareTo(value) != 0) continue;
            result.add(key);
        }
        return result;
    }
}

