/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.AbstractComputable;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.HasPrediction;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.ReportUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.model.ToStringHelper;

public class Classification<K, V extends Number>
extends AbstractComputable
implements HasPrediction {
    private Type type = null;
    private ValueMap<K, V> values = null;
    private Object result = null;

    protected Classification(Type type, ValueMap<K, V> values) {
        this.setType(type);
        this.setValues(values);
    }

    @Override
    public Object getResult() {
        if (this.result == null) {
            throw new EvaluationException("Classification result has not been computed");
        }
        return this.result;
    }

    protected void setResult(Object result) {
        this.result = result;
    }

    protected void computeResult(DataType dataType) {
        Map.Entry<K, Value<V>> entry = this.getWinner();
        if (entry == null) {
            throw new EvaluationException("Empty classification");
        }
        K key = entry.getKey();
        Value<V> value = entry.getValue();
        Object result = TypeUtil.parseOrCast(dataType, key);
        this.setResult(result);
    }

    @Override
    public Object getPrediction() {
        return this.getResult();
    }

    @Override
    public Report getPredictionReport() {
        Map.Entry<K, Value<V>> entry = this.getWinner();
        if (entry == null) {
            return null;
        }
        K key = entry.getKey();
        Value<V> value = entry.getValue();
        return ReportUtil.getReport(value);
    }

    @Override
    protected ToStringHelper toStringHelper() {
        Type type = this.getType();
        ValueMap<K, V> values = this.getValues();
        ToStringHelper helper = super.toStringHelper().add(type.entryKey(), values.entrySet());
        return helper;
    }

    public void put(K key, Value<V> value) {
        ValueMap<K, Value<V>> values = this.getValues();
        if (values.containsKey(key)) {
            throw new EvaluationException("Value for key " + EvaluationException.formatKey(key) + " has already been defined");
        }
        values.put(key, value);
    }

    public Double getValue(K key) {
        Type type = this.getType();
        ValueMap<K, V> values = this.getValues();
        Value value = (Value)values.get(key);
        return type.getValue(value);
    }

    public Report getValueReport(K key) {
        ValueMap<K, V> values = this.getValues();
        Value value = (Value)values.get(key);
        return ReportUtil.getReport(value);
    }

    protected Map.Entry<K, Value<V>> getWinner() {
        return Classification.getWinner(this.getType(), this.entrySet());
    }

    protected List<Map.Entry<K, Value<V>>> getWinnerRanking() {
        return Classification.getWinnerList(this.getType(), this.entrySet());
    }

    protected List<K> getWinnerKeys() {
        return Classification.entryKeys(this.getWinnerRanking());
    }

    protected List<Double> getWinnerValues() {
        return Lists.transform(Classification.entryValues(this.getWinnerRanking()), Value::doubleValue);
    }

    protected Set<K> keySet() {
        ValueMap<K, V> values = this.getValues();
        return values.keySet();
    }

    protected Set<Map.Entry<K, Value<V>>> entrySet() {
        ValueMap<K, V> values = this.getValues();
        return values.entrySet();
    }

    public Type getType() {
        return this.type;
    }

    private void setType(Type type) {
        this.type = Objects.requireNonNull(type);
    }

    public ValueMap<K, V> getValues() {
        return this.values;
    }

    private void setValues(ValueMap<K, V> values) {
        this.values = Objects.requireNonNull(values);
    }

    public static <K, V extends Number> Map.Entry<K, Value<V>> getWinner(Type type, Collection<Map.Entry<K, Value<V>>> entries) {
        Ordering<Map.Entry<K, Value<V>>> ordering = Classification.createOrdering(type);
        try {
            return (Map.Entry)ordering.max(entries);
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
    }

    public static <K, V extends Number> List<Map.Entry<K, Value<V>>> getWinnerList(Type type, Collection<Map.Entry<K, Value<V>>> entries) {
        Ordering ordering = Classification.createOrdering(type).reverse();
        return ordering.sortedCopy(entries);
    }

    protected static <K, V extends Number> Ordering<Map.Entry<K, Value<V>>> createOrdering(Type type) {
        return Ordering.from((left, right) -> type.compareValues((Value)left.getValue(), (Value)right.getValue()));
    }

    public static <K, V> List<K> entryKeys(List<Map.Entry<K, V>> entries) {
        return Lists.transform(entries, Map.Entry::getKey);
    }

    public static <K, V> List<V> entryValues(List<Map.Entry<K, V>> entries) {
        return Lists.transform(entries, Map.Entry::getValue);
    }

    public static enum Type {
        PROBABILITY(true, (Range<Double>)Range.closed((Comparable)Numbers.DOUBLE_ZERO, (Comparable)Numbers.DOUBLE_ONE)),
        CONFIDENCE(true, (Range<Double>)Range.atLeast((Comparable)Numbers.DOUBLE_ZERO)),
        DISTANCE(false, Range.atLeast((Comparable)Numbers.DOUBLE_ZERO)){

            @Override
            public Double getDefaultValue() {
                return Double.POSITIVE_INFINITY;
            }
        }
        ,
        SIMILARITY(true, (Range<Double>)Range.atLeast((Comparable)Numbers.DOUBLE_ZERO)),
        VOTE(true, (Range<Double>)Range.atLeast((Comparable)Numbers.DOUBLE_ZERO));

        private boolean ordering;
        private Range<Double> range;

        private Type(boolean ordering, Range<Double> range) {
            this.setOrdering(ordering);
            this.setRange(range);
        }

        public <V extends Number> Double getValue(Value<V> value) {
            if (value == null) {
                return this.getDefaultValue();
            }
            return value.doubleValue();
        }

        public <V extends Number> int compareValues(Value<V> left, Value<V> right) {
            boolean ordering = this.getOrdering();
            int result = left.compareTo(right);
            return ordering ? result : -result;
        }

        public <V extends Number> boolean isValidValue(Value<V> value) {
            Range<Double> range = this.getRange();
            return range.contains((Comparable)Double.valueOf(value.doubleValue()));
        }

        public Double getDefaultValue() {
            return Numbers.DOUBLE_ZERO;
        }

        public String entryKey() {
            String name = this.name();
            return name.toLowerCase() + "_entries";
        }

        public boolean getOrdering() {
            return this.ordering;
        }

        private void setOrdering(boolean ordering) {
            this.ordering = ordering;
        }

        public Range<Double> getRange() {
            return this.range;
        }

        private void setRange(Range<Double> range) {
            this.range = range;
        }
    }
}

