/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.jpmml.evaluator.NotImplementedException;
import org.jpmml.evaluator.Operation;
import org.jpmml.evaluator.Value;

public class FloatValue
extends Value<Float> {
    protected float value = 0.0f;
    public static final double E = 2.7182817;
    public static final double PI = 3.1415927;

    @Operation(value="${0}")
    public FloatValue(float value) {
        this.value = value;
    }

    @Operation(value="${0}")
    public FloatValue(Number value) {
        this.value = value.floatValue();
    }

    @Override
    public int compareTo(Value<Float> that) {
        return Float.compare(this.floatValue(), that.floatValue());
    }

    public String toString() {
        return Float.toString(this.value);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public boolean equals(Object object) {
        if (object instanceof FloatValue) {
            FloatValue that = (FloatValue)object;
            return Float.floatToIntBits(this.value) == Float.floatToIntBits(that.value);
        }
        return false;
    }

    public FloatValue copy() {
        return new FloatValue(this.value);
    }

    public FloatValue reset(Number value) {
        this.value = value.floatValue();
        return this;
    }

    public FloatValue add(Number value) {
        this.value += value.floatValue();
        return this;
    }

    public FloatValue add(Value<? extends Number> value) {
        this.value += value.floatValue();
        return this;
    }

    public FloatValue add(Number coefficient, Number factor) {
        this.value += coefficient.floatValue() * factor.floatValue();
        return this;
    }

    public FloatValue add(Number coefficient, Number firstFactor, Number secondFactor) {
        this.value += coefficient.floatValue() * firstFactor.floatValue() * secondFactor.floatValue();
        return this;
    }

    public FloatValue add(Number coefficient, Number ... factors) {
        float value = coefficient.floatValue();
        for (Number factor : factors) {
            value *= factor.floatValue();
        }
        this.value += value;
        return this;
    }

    public FloatValue add(Number coefficient, Number factor, int exponent) {
        this.value += coefficient.floatValue() * FloatValue.pow(factor.floatValue(), exponent);
        return this;
    }

    public FloatValue subtract(Number value) {
        this.value -= value.floatValue();
        return this;
    }

    public FloatValue subtract(Value<? extends Number> value) {
        this.value -= value.floatValue();
        return this;
    }

    public FloatValue multiply(Number value) {
        this.value *= value.floatValue();
        return this;
    }

    public FloatValue multiply(Value<? extends Number> value) {
        this.value *= value.floatValue();
        return this;
    }

    public FloatValue multiply(Number factor, Number exponent) {
        this.value *= FloatValue.pow(factor.floatValue(), exponent.floatValue());
        return this;
    }

    public FloatValue divide(Number value) {
        this.value /= value.floatValue();
        return this;
    }

    public FloatValue divide(Value<? extends Number> value) {
        this.value /= value.floatValue();
        return this;
    }

    public FloatValue residual(Value<? extends Number> value) {
        this.value = 1.0f - value.floatValue();
        return this;
    }

    public FloatValue square() {
        this.value *= this.value;
        return this;
    }

    public FloatValue power(Number value) {
        this.value = FloatValue.pow(this.value, value.floatValue());
        return this;
    }

    public FloatValue reciprocal() {
        this.value = 1.0f / this.value;
        return this;
    }

    public FloatValue elliott() {
        this.value /= 1.0f + Math.abs(this.value);
        return this;
    }

    public FloatValue exp() {
        this.value = FloatValue.exp(this.value);
        return this;
    }

    public FloatValue ln() {
        this.value = (float)Math.log(this.value);
        return this;
    }

    public FloatValue gauss() {
        this.value = FloatValue.exp(-(this.value * this.value));
        return this;
    }

    public FloatValue inverseLogit() {
        this.value = 1.0f / (1.0f + FloatValue.exp(-this.value));
        return this;
    }

    public FloatValue inverseCloglog() {
        this.value = 1.0f - FloatValue.exp(-FloatValue.exp(this.value));
        return this;
    }

    public FloatValue inverseLoglog() {
        this.value = FloatValue.exp(-FloatValue.exp(-this.value));
        return this;
    }

    public FloatValue inverseLogc() {
        this.value = 1.0f - FloatValue.exp(this.value);
        return this;
    }

    public FloatValue inverseNegbin(Number value) {
        this.value = 1.0f / (value.floatValue() * (FloatValue.exp(-this.value) - 1.0f));
        return this;
    }

    public FloatValue inverseOddspower(Number value) {
        return this.inverseOddspowerInternal(value.floatValue());
    }

    private FloatValue inverseOddspowerInternal(float value) {
        this.value = value < 0.0f || value > 0.0f ? 1.0f / (1.0f + FloatValue.pow(1.0f + value * this.value, -(1.0f / value))) : 1.0f / (1.0f + FloatValue.exp(-this.value));
        return this;
    }

    public FloatValue inversePower(Number value) {
        return this.inversePowerInternal(value.floatValue());
    }

    private FloatValue inversePowerInternal(float value) {
        this.value = value < 0.0f || value > 0.0f ? FloatValue.pow(this.value, 1.0f / value) : FloatValue.exp(this.value);
        return this;
    }

    public FloatValue inverseCauchit() {
        this.value = 0.5f + 0.31830987f * (float)Math.atan(this.value);
        return this;
    }

    public FloatValue inverseProbit() {
        throw new NotImplementedException();
    }

    public FloatValue sin() {
        this.value = (float)Math.sin(this.value);
        return this;
    }

    public FloatValue cos() {
        this.value = (float)Math.cos(this.value);
        return this;
    }

    public FloatValue arctan() {
        this.value = 2.0f * (float)Math.atan(this.value) / (float)Math.PI;
        return this;
    }

    public FloatValue tanh() {
        this.value = (float)Math.tanh(this.value);
        return this;
    }

    public FloatValue threshold(Number value) {
        this.value = this.value > value.floatValue() ? 1.0f : 0.0f;
        return this;
    }

    public FloatValue relu() {
        this.value = Math.max(this.value, 0.0f);
        return this;
    }

    public FloatValue abs() {
        this.value = Math.abs(this.value);
        return this;
    }

    public FloatValue gaussSim(Number value) {
        return this.gaussSimInternal(value.floatValue());
    }

    private FloatValue gaussSimInternal(float value) {
        this.value = FloatValue.exp(-((float)Math.log(2.0)) * this.value * this.value / (value * value));
        return this;
    }

    public FloatValue restrict(Number lowValue, Number highValue) {
        this.value = Math.max(this.value, lowValue.floatValue());
        this.value = Math.min(this.value, highValue.floatValue());
        return this;
    }

    public FloatValue round() {
        this.value = Math.round(this.value);
        return this;
    }

    public FloatValue ceiling() {
        this.value = (float)Math.ceil(this.value);
        return this;
    }

    public FloatValue floor() {
        this.value = (float)Math.floor(this.value);
        return this;
    }

    public FloatValue normalize(Number leftOrig, Number leftNorm, Number rightOrig, Number rightNorm) {
        return this.normalizeInternal(leftOrig.floatValue(), leftNorm.floatValue(), rightOrig.floatValue(), rightNorm.floatValue());
    }

    private FloatValue normalizeInternal(float leftOrig, float leftNorm, float rightOrig, float rightNorm) {
        this.value = leftNorm + (this.value - leftOrig) / (rightOrig - leftOrig) * (rightNorm - leftNorm);
        return this;
    }

    public FloatValue denormalize(Number leftOrig, Number leftNorm, Number rightOrig, Number rightNorm) {
        return this.denormalizeInternal(leftOrig.floatValue(), leftNorm.floatValue(), rightOrig.floatValue(), rightNorm.floatValue());
    }

    private FloatValue denormalizeInternal(float leftOrig, float leftNorm, float rightOrig, float rightNorm) {
        this.value = (this.value - leftNorm) / (rightNorm - leftNorm) * (rightOrig - leftOrig) + leftOrig;
        return this;
    }

    @Override
    public boolean isZero() {
        return this.value == 0.0f;
    }

    @Override
    public boolean isOne() {
        return this.value == 1.0f;
    }

    @Override
    public boolean equals(Number value) {
        return this.value == value.floatValue();
    }

    @Override
    public int compareTo(Number value) {
        return Float.compare(this.value, value.floatValue());
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public static float exp(float value) {
        return (float)Math.pow(2.7182817, value);
    }

    public static float pow(float value, float power) {
        return (float)Math.pow(value, power);
    }
}

