/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.XPathUtil;

public class PMMLUtil {
    private PMMLUtil() {
    }

    public static Model findModel(PMML pmml, final String modelName) {
        Model model;
        if (modelName != null) {
            Predicate<Model> predicate = new Predicate<Model>(){

                public boolean apply(Model model) {
                    return Objects.equals(model.getModelName(), modelName);
                }
            };
            model = PMMLUtil.findModel(pmml, predicate, "<Model>@modelName=" + modelName);
        } else {
            Predicate<Model> predicate = new Predicate<Model>(){

                public boolean apply(Model model) {
                    return model.isScorable();
                }
            };
            model = PMMLUtil.findModel(pmml, predicate, "<Model>@isScorable=true");
        }
        return model;
    }

    public static <M extends Model> M findModel(PMML pmml, final Class<? extends M> clazz) {
        Predicate<Model> predicate = new Predicate<Model>(){

            public boolean apply(Model model) {
                return clazz.isInstance(model) && model.isScorable();
            }
        };
        Model model = PMMLUtil.findModel(pmml, predicate, XPathUtil.formatElement(clazz) + "@isScorable=true");
        return (M)((Model)clazz.cast(model));
    }

    private static Model findModel(PMML pmml, Predicate<Model> predicate, String predicateXPath) {
        if (pmml.hasModels()) {
            List models = pmml.getModels();
            for (Model model : models) {
                if (!predicate.apply((Object)model)) continue;
                return model;
            }
        }
        throw new MissingElementException(MissingElementException.formatMessage((String)(XPathUtil.formatElement(pmml.getClass()) + "/" + predicateXPath)), (PMMLObject)pmml);
    }
}

