/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jpmml.evaluator.Table;

@IgnoreJRERequirement
public class ColumnCollector
implements Collector<Object, List<Object>, Table> {
    private Table table = null;
    private String column = null;

    public ColumnCollector(Table table, String column) {
        this.setTable(table);
        this.setColumn(column);
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    @Override
    public Supplier<List<Object>> supplier() {
        return () -> new ArrayList();
    }

    @Override
    public BiConsumer<List<Object>, Object> accumulator() {
        return (elements, element) -> elements.add(element);
    }

    @Override
    public BinaryOperator<List<Object>> combiner() {
        return (left, right) -> {
            left.addAll(right);
            return left;
        };
    }

    @Override
    public Function<List<Object>, Table> finisher() {
        return elements -> {
            Table table = this.getTable();
            String column = this.getColumn();
            if (table.getNumberOfColumns() > 0 && elements.size() != table.getNumberOfRows()) {
                throw new IllegalArgumentException();
            }
            List<?> prevValues = table.getValues(column);
            Table.Row row = null;
            for (Object element : elements) {
                if (row == null) {
                    row = this.createFinisherRow(table);
                }
                if (element instanceof Exception) {
                    Exception exception = (Exception)element;
                    row.setException(exception);
                    if (prevValues != null) {
                        row.remove(column);
                    }
                } else {
                    row.put(column, element);
                }
                row.advance();
            }
            table.canonicalize();
            return table;
        };
    }

    protected Table.Row createFinisherRow(Table table) {
        return table.createWriterRow(0);
    }

    public Table getTable() {
        return this.table;
    }

    private void setTable(Table table) {
        this.table = Objects.requireNonNull(table);
    }

    public String getColumn() {
        return this.column;
    }

    private void setColumn(String column) {
        this.column = column;
    }
}

