/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.apache.commons.math3.stat.descriptive.summary.Product;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jpmml.evaluator.AggregableMap;
import org.jpmml.evaluator.LaggableMap;
import org.jpmml.evaluator.TableSpliterator;
import org.jpmml.evaluator.TypeUtil;

public class Table {
    private List<String> columns = null;
    private int initialCapacity = 0;
    private List<Exception> exceptions = null;
    private Map<String, List<?>> values = new HashMap();

    public Table(int initialCapacity) {
        this(new ArrayList<String>(), initialCapacity);
    }

    public Table(List<String> columns, int initialCapacity) {
        this.setColumns(columns);
        this.setInitialCapacity(initialCapacity);
        this.setExceptions(this.createList());
    }

    public int getNumberOfRows() {
        List<Exception> exceptions = this.getExceptions();
        int result = exceptions.size();
        Map<String, List<?>> columnValues = this.getValues();
        Set<Map.Entry<String, List<?>>> entries = columnValues.entrySet();
        for (Map.Entry entry : entries) {
            List values = (List)entry.getValue();
            result = Math.max(result, values.size());
        }
        return result;
    }

    public int getNumberOfColumns() {
        List<String> columns = this.getColumns();
        return columns.size();
    }

    public void canonicalize() {
        List<String> columns = this.getColumns();
        int numberOfRows = this.getNumberOfRows();
        List<Exception> exceptions = this.getExceptions();
        Table.ensureSize(exceptions, numberOfRows);
        for (String column : columns) {
            List<Object> values = this.getValues(column);
            if (values == null) {
                values = this.createList(numberOfRows);
                this.setValues(column, values);
            }
            Table.ensureSize(values, numberOfRows);
        }
    }

    protected boolean ensureColumn(String column) {
        List<String> columns = this.getColumns();
        if (!columns.contains(column)) {
            columns.add(column);
            return true;
        }
        return false;
    }

    public boolean addColumn(String column) {
        return this.ensureColumn(column);
    }

    public boolean removeColumn(String column) {
        List<String> columns = this.getColumns();
        boolean result = columns.remove(column);
        if (result) {
            Map<String, List<?>> columnValues = this.getValues();
            columnValues.remove(column);
        }
        return result;
    }

    public Row createReaderRow(int origin) {
        return new Row(origin, this.getNumberOfRows());
    }

    public Row createReaderRow(int origin, int fence) {
        return new Row(origin, fence);
    }

    public Row createWriterRow(int origin) {
        return new Row(origin, -1);
    }

    @IgnoreJRERequirement
    public TableSpliterator spliterator() {
        return new TableSpliterator(this).init();
    }

    @IgnoreJRERequirement
    public Stream<Row> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @IgnoreJRERequirement
    public Stream<Row> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    public boolean hasExceptions() {
        List<Exception> exceptions = this.getExceptions();
        for (int i = 0; i < exceptions.size(); ++i) {
            Exception exception = exceptions.get(i);
            if (exception == null) continue;
            return true;
        }
        return false;
    }

    public Exception getException(int index) {
        List<Exception> exceptions = this.getExceptions();
        return Table.get(exceptions, index);
    }

    public void setException(int index, Exception exception) {
        List<Exception> exceptions = this.getExceptions();
        Table.set(exceptions, index, exception);
    }

    public void clearExceptions() {
        List<Exception> exceptions = this.getExceptions();
        Table.clear(exceptions);
    }

    @IgnoreJRERequirement
    public void apply(Function<?, ?> function) {
        Map<String, List<?>> columnValues = this.getValues();
        Set<Map.Entry<String, List<?>>> entries = columnValues.entrySet();
        for (Map.Entry entry : entries) {
            List values = (List)entry.getValue();
            Table.transform(values, function);
        }
    }

    @IgnoreJRERequirement
    public void apply(String column, Function<?, ?> function) {
        List<?> values = this.getValues(column);
        if (values != null) {
            Table.transform(values, function);
        }
    }

    protected List<?> ensureValues(String column) {
        Map<String, List<?>> columnValues = this.getValues();
        List<Object> values = columnValues.get(column);
        if (values == null) {
            this.ensureColumn(column);
            values = this.createList();
            columnValues.put(column, values);
        }
        return values;
    }

    public List<?> getValues(String column) {
        Map<String, List<?>> columnValues = this.getValues();
        return columnValues.get(column);
    }

    public void setValues(String column, List<?> values) {
        Map<String, List<?>> columnValues = this.getValues();
        this.ensureColumn(column);
        columnValues.put(column, values);
    }

    private <E> List<E> createList() {
        return this.createList(this.getInitialCapacity());
    }

    private <E> List<E> createList(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    public List<String> getColumns() {
        return this.columns;
    }

    private void setColumns(List<String> columns) {
        this.columns = Objects.requireNonNull(columns);
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    private void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    private void setExceptions(List<Exception> exceptions) {
        this.exceptions = Objects.requireNonNull(exceptions);
    }

    public Map<String, List<?>> getValues() {
        return this.values;
    }

    private static <E> E get(List<E> values, int index) {
        if (index < values.size()) {
            return values.get(index);
        }
        return null;
    }

    private static <E> E set(List<E> values, int index, E value) {
        if (index < values.size()) {
            return values.set(index, value);
        }
        Table.ensureSize(values, index);
        values.add(value);
        return null;
    }

    private static <E> List<E> ensureSize(List<E> values, int size) {
        while (values.size() < size) {
            values.add(null);
        }
        return values;
    }

    private static <E> void clear(List<E> values) {
        ListIterator<E> it = values.listIterator();
        while (it.hasNext()) {
            E value = it.next();
            if (value == null) continue;
            it.set(null);
        }
    }

    @IgnoreJRERequirement
    private static <E> void transform(List<E> values, Function<E, E> function) {
        ListIterator<E> it = values.listIterator();
        while (it.hasNext()) {
            E value = it.next();
            value = function.apply(value);
            it.set(value);
        }
    }

    private static UnivariateStatistic getStatistic(String function) {
        switch (function) {
            case "avg": {
                return new Mean();
            }
            case "median": {
                return new Median();
            }
            case "product": {
                return new Product();
            }
            case "sum": {
                return new Sum();
            }
            case "stddev": {
                return new StandardDeviation();
            }
        }
        throw new IllegalArgumentException(function);
    }

    public class Row
    extends AbstractMap<String, Object>
    implements LaggableMap<String, Object>,
    AggregableMap<String, Object> {
        private int origin;
        private int fence;

        public Row(int origin, int fence) {
            this.setOrigin(origin);
            this.setFence(fence);
        }

        public int estimateAdvances() {
            int origin = this.getOrigin();
            int fence = this.getFence();
            if (fence < 0) {
                throw new IllegalStateException();
            }
            return fence - origin;
        }

        public boolean canAdvance() {
            int origin = this.getOrigin();
            int fence = this.getFence();
            if (fence < 0) {
                return true;
            }
            return origin < fence;
        }

        public void advance() {
            int origin = this.getOrigin();
            this.setOrigin(origin + 1);
        }

        public Exception getException() {
            int origin = this.getOrigin();
            return Table.this.getException(origin);
        }

        public void setException(Exception exception) {
            int origin = this.getOrigin();
            Table.this.setException(origin, exception);
        }

        @Override
        public Object get(Object key) {
            int origin = this.getOrigin();
            List<?> values = Table.this.getValues((String)key);
            if (values != null) {
                int index = origin;
                return Table.get(values, index);
            }
            return null;
        }

        @Override
        public Object getLagged(String key, int n, List<String> blockIndicatorKeys) {
            int origin = this.getOrigin();
            List<?> values = Table.this.getValues(key);
            if (values != null) {
                if (blockIndicatorKeys.isEmpty()) {
                    int index = origin - n;
                    if (index < 0) {
                        return null;
                    }
                    return Table.get(values, index);
                }
                Map<String, Object> blockIndicatorMap = this.createBlockIndicator(origin, blockIndicatorKeys);
                int matches = 0;
                for (int index = origin - 1; index > -1; --index) {
                    if (!this.matchesBlockIndicator(index, blockIndicatorMap) || ++matches != n) continue;
                    return Table.get(values, index);
                }
                return null;
            }
            return null;
        }

        @Override
        @IgnoreJRERequirement
        public Object getAggregated(String key, String function, int n, List<String> blockIndicatorKeys) {
            int origin = this.getOrigin();
            List<?> values = Table.this.getValues(key);
            if (values != null) {
                List<Object> windowValues;
                if (blockIndicatorKeys.isEmpty()) {
                    int fromIndex = Math.max(origin - n, 0);
                    int toIndex = origin;
                    windowValues = values.subList(fromIndex, toIndex).stream().filter(value -> value != null).map(value -> TypeUtil.cast(Number.class, value)).collect(Collectors.toList());
                } else {
                    Map<String, Object> blockIndicatorMap = this.createBlockIndicator(origin, blockIndicatorKeys);
                    windowValues = new ArrayList();
                    int matches = 0;
                    for (int index = origin - 1; index > -1; --index) {
                        if (!this.matchesBlockIndicator(index, blockIndicatorMap)) continue;
                        ++matches;
                        Object value2 = Table.get(values, index);
                        if (value2 != null) {
                            value2 = TypeUtil.cast(Number.class, value2);
                            windowValues.add((Number)value2);
                        }
                        if (matches == n) break;
                    }
                }
                if (windowValues.isEmpty()) {
                    return null;
                }
                switch (function) {
                    case "max": {
                        return Collections.max(windowValues);
                    }
                    case "min": {
                        return Collections.min(windowValues);
                    }
                }
                UnivariateStatistic statistic = Table.getStatistic(function);
                double[] doubleWindowValues = windowValues.stream().mapToDouble(value -> value.doubleValue()).toArray();
                return statistic.evaluate(doubleWindowValues);
            }
            return null;
        }

        @Override
        public Object put(String key, Object value) {
            int origin = this.getOrigin();
            List<?> values = Table.this.ensureValues(key);
            return Table.set(values, origin, value);
        }

        @Override
        public Object remove(Object key) {
            int origin = this.getOrigin();
            List<?> values = Table.this.getValues((String)key);
            if (values != null) {
                return Table.set(values, origin, null);
            }
            return null;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            final int origin = this.getOrigin();
            AbstractSet<Map.Entry<String, Object>> result = new AbstractSet<Map.Entry<String, Object>>(){

                @Override
                public int size() {
                    List<String> columns = Table.this.getColumns();
                    return columns.size();
                }

                @Override
                public Iterator<Map.Entry<String, Object>> iterator() {
                    final List<String> columns = Table.this.getColumns();
                    Iterator<Map.Entry<String, Object>> result = new Iterator<Map.Entry<String, Object>>(){
                        private Iterator<String> it;
                        {
                            this.it = columns.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.it.hasNext();
                        }

                        @Override
                        public Map.Entry<String, Object> next() {
                            String column = this.it.next();
                            List<?> values = Table.this.getValues(column);
                            if (values != null) {
                                Object value = Table.get(values, origin);
                                return new AbstractMap.SimpleEntry<String, Object>(column, value);
                            }
                            return new AbstractMap.SimpleEntry<String, Object>(column, null);
                        }
                    };
                    return result;
                }
            };
            return result;
        }

        private Map<String, Object> createBlockIndicator(int index, List<String> keys) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (int i = 0; i < keys.size(); ++i) {
                String key = keys.get(i);
                List<?> values = Table.this.getValues(key);
                if (values == null) {
                    throw new IllegalArgumentException(key);
                }
                Object value = Table.get(values, index);
                result.put(key, value);
            }
            return result;
        }

        private boolean matchesBlockIndicator(int index, Map<String, ?> map) {
            if (map.isEmpty()) {
                return true;
            }
            Set<Map.Entry<String, ?>> entries = map.entrySet();
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                Object expectedValue = entry.getValue();
                List<?> values = Table.this.getValues(key);
                if (values != null) {
                    Object actualValue = Table.get(values, index);
                    if (Objects.equals(expectedValue, actualValue)) continue;
                    return false;
                }
                throw new IllegalArgumentException(key);
            }
            return true;
        }

        public Table getTable() {
            return Table.this;
        }

        int getOrigin() {
            return this.origin;
        }

        void setOrigin(int origin) {
            this.origin = origin;
        }

        int getFence() {
            return this.fence;
        }

        void setFence(int fence) {
            this.fence = fence;
        }
    }
}

