/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.AbstractFunction;

public class MeanFunction
extends AbstractFunction {
    public MeanFunction() {
        this(MeanFunction.class.getName());
    }

    public MeanFunction(String name) {
        super(name);
    }

    public FieldValue evaluate(List<FieldValue> arguments) {
        this.checkArguments(arguments, 1);
        Object values = FieldValueUtil.getValue((FieldValue)arguments.get(0));
        if (!(values instanceof Collection)) {
            throw new TypeCheckException(Collection.class, values);
        }
        Double result = MeanFunction.evaluate((Collection)values);
        return FieldValueUtil.create((Object)result);
    }

    private static Double evaluate(Collection<?> values) {
        Mean mean = new Mean();
        for (Object value : values) {
            Double doubleValue = (Double)TypeUtil.parseOrCast((DataType)DataType.DOUBLE, value);
            mean.increment(doubleValue.doubleValue());
        }
        return mean.getResult();
    }
}

