/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.AbstractFunction;

public class StandardDeviationFunction
extends AbstractFunction {
    public StandardDeviationFunction() {
        this(StandardDeviationFunction.class.getName());
    }

    public StandardDeviationFunction(String name) {
        super(name);
    }

    public FieldValue evaluate(List<FieldValue> arguments) {
        if (arguments.size() < 1 || arguments.size() > 2) {
            throw new FunctionException(this.getName(), "Expected 1 or 2 arguments, but got " + arguments.size() + " arguments");
        }
        if (arguments.contains(null)) {
            throw new FunctionException(this.getName(), "Missing arguments");
        }
        Object values = FieldValueUtil.getValue((FieldValue)arguments.get(0));
        if (!(values instanceof Collection)) {
            throw new TypeCheckException(Collection.class, values);
        }
        Boolean biasCorrected = Boolean.FALSE;
        if (arguments.size() > 1) {
            biasCorrected = arguments.get(1).asBoolean();
        }
        Double result = StandardDeviationFunction.evaluate((Collection)values, biasCorrected);
        return FieldValueUtil.create((Object)result);
    }

    private static Double evaluate(Collection<?> values, boolean biasCorrected) {
        StandardDeviation statistic = new StandardDeviation();
        statistic.setBiasCorrected(biasCorrected);
        for (Object value : values) {
            Double doubleValue = (Double)TypeUtil.parseOrCast((DataType)DataType.DOUBLE, value);
            statistic.increment(doubleValue.doubleValue());
        }
        return statistic.getResult();
    }
}

