/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.AbstractFunction;

public class PercentileFunction
extends AbstractFunction {
    public PercentileFunction() {
        this(PercentileFunction.class.getName());
    }

    public PercentileFunction(String name) {
        super(name);
    }

    public FieldValue evaluate(List<FieldValue> arguments) {
        this.checkArguments(arguments, 2);
        Collection values = (Collection)FieldValueUtil.getValue(Collection.class, (FieldValue)arguments.get(0));
        int percentile = arguments.get(1).asInteger();
        if (percentile < 1 || percentile > 100) {
            throw new FunctionException((Function)this, "Invalid percentile value " + percentile + ". Must be greater than 0 and equal or less than 100");
        }
        Double result = PercentileFunction.evaluate(values, percentile);
        return FieldValueUtil.create((Object)result);
    }

    private static Double evaluate(Collection<?> values, int quantile) {
        ArrayList<Double> doubleValues = new ArrayList<Double>();
        for (Object value : values) {
            Double doubleValue = (Double)TypeUtil.parseOrCast((DataType)DataType.DOUBLE, value);
            doubleValues.add(doubleValue);
        }
        double[] data = Doubles.toArray(doubleValues);
        Arrays.sort(data);
        Percentile percentile = new Percentile();
        percentile.setData(data);
        return percentile.evaluate((double)quantile);
    }
}

