/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import com.google.common.base.Preconditions;
import java.util.List;
import org.dmg.pmml.CategoricalPredictor;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.NumericPredictor;
import org.dmg.pmml.PMML;
import org.dmg.pmml.RegressionModel;
import org.dmg.pmml.RegressionTable;
import org.jpmml.manager.ModelManager;

public class RegressionModelManager
extends ModelManager<RegressionModel> {
    private RegressionModel regressionModel = null;

    public RegressionModelManager() {
    }

    public RegressionModelManager(PMML pmml) {
        this(pmml, RegressionModelManager.find(pmml.getContent(), RegressionModel.class));
    }

    public RegressionModelManager(PMML pmml, RegressionModel regressionModel) {
        super(pmml);
        this.regressionModel = regressionModel;
    }

    @Override
    public String getSummary() {
        return "Regression";
    }

    @Override
    public RegressionModel getModel() {
        Preconditions.checkState((this.regressionModel != null ? 1 : 0) != 0);
        return this.regressionModel;
    }

    public RegressionModel createModel(MiningFunctionType miningFunction) {
        Preconditions.checkState((this.regressionModel == null ? 1 : 0) != 0);
        this.regressionModel = new RegressionModel(new MiningSchema(), miningFunction);
        this.getModels().add((Model)this.regressionModel);
        return this.regressionModel;
    }

    public FieldName getTarget() {
        RegressionModel regressionModel = this.getModel();
        return regressionModel.getTargetFieldName();
    }

    public RegressionModel setTarget(FieldName name) {
        RegressionModel regressionModel = this.getModel();
        regressionModel.setTargetFieldName(name);
        return regressionModel;
    }

    public List<RegressionTable> getRegressionTables() {
        RegressionModel model = this.getModel();
        return model.getRegressionTables();
    }

    public static NumericPredictor getNumericPredictor(RegressionTable regressionTable, FieldName name) {
        return (NumericPredictor)RegressionModelManager.find(regressionTable.getNumericPredictors(), name);
    }

    public static NumericPredictor addNumericPredictor(RegressionTable regressionTable, FieldName name, Double coefficient) {
        NumericPredictor numericPredictor = new NumericPredictor(name, coefficient.doubleValue());
        regressionTable.getNumericPredictors().add(numericPredictor);
        return numericPredictor;
    }

    public static CategoricalPredictor getCategoricalPredictor(RegressionTable regressionTable, FieldName name) {
        return (CategoricalPredictor)RegressionModelManager.find(regressionTable.getCategoricalPredictors(), name);
    }

    public static CategoricalPredictor addCategoricalPredictor(RegressionTable regressionTable, FieldName name, String value, Double coefficient) {
        CategoricalPredictor categoricalPredictor = new CategoricalPredictor(name, value, coefficient.doubleValue());
        regressionTable.getCategoricalPredictors().add(categoricalPredictor);
        return categoricalPredictor;
    }
}

