/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import org.dmg.pmml.AssociationModel;
import org.dmg.pmml.ClusteringModel;
import org.dmg.pmml.GeneralRegressionModel;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.Model;
import org.dmg.pmml.NeuralNetwork;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.RegressionModel;
import org.dmg.pmml.RuleSetModel;
import org.dmg.pmml.Scorecard;
import org.dmg.pmml.TreeModel;
import org.jpmml.manager.AssociationModelManager;
import org.jpmml.manager.ClusteringModelManager;
import org.jpmml.manager.GeneralRegressionModelManager;
import org.jpmml.manager.MiningModelManager;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.NeuralNetworkManager;
import org.jpmml.manager.RegressionModelManager;
import org.jpmml.manager.RuleSetModelManager;
import org.jpmml.manager.ScorecardManager;
import org.jpmml.manager.TreeModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

public class ModelManagerFactory {
    protected ModelManagerFactory() {
    }

    public ModelManager<? extends Model> getModelManager(PMML pmml, Model model) {
        if (model instanceof AssociationModel) {
            return new AssociationModelManager(pmml, (AssociationModel)model);
        }
        if (model instanceof ClusteringModel) {
            return new ClusteringModelManager(pmml, (ClusteringModel)model);
        }
        if (model instanceof GeneralRegressionModel) {
            return new GeneralRegressionModelManager(pmml, (GeneralRegressionModel)model);
        }
        if (model instanceof MiningModel) {
            return new MiningModelManager(pmml, (MiningModel)model);
        }
        if (model instanceof NeuralNetwork) {
            return new NeuralNetworkManager(pmml, (NeuralNetwork)model);
        }
        if (model instanceof RegressionModel) {
            return new RegressionModelManager(pmml, (RegressionModel)model);
        }
        if (model instanceof RuleSetModel) {
            return new RuleSetModelManager(pmml, (RuleSetModel)model);
        }
        if (model instanceof Scorecard) {
            return new ScorecardManager(pmml, (Scorecard)model);
        }
        if (model instanceof TreeModel) {
            return new TreeModelManager(pmml, (TreeModel)model);
        }
        throw new UnsupportedFeatureException((PMMLObject)model);
    }

    public static ModelManagerFactory getInstance() {
        return new ModelManagerFactory();
    }
}

