/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import org.dmg.pmml.Cluster;
import org.dmg.pmml.ClusteringField;
import org.dmg.pmml.ClusteringModel;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Target;
import org.jpmml.manager.EntityUtil;
import org.jpmml.manager.HasEntityRegistry;
import org.jpmml.manager.ModelManager;

public class ClusteringModelManager
extends ModelManager<ClusteringModel>
implements HasEntityRegistry<Cluster> {
    private ClusteringModel clusteringModel = null;

    public ClusteringModelManager() {
    }

    public ClusteringModelManager(PMML pmml) {
        this(pmml, ClusteringModelManager.find(pmml.getContent(), ClusteringModel.class));
    }

    public ClusteringModelManager(PMML pmml, ClusteringModel clusteringModel) {
        super(pmml);
        this.clusteringModel = clusteringModel;
    }

    @Override
    public String getSummary() {
        return "Clustering model";
    }

    @Override
    public Target getTarget(FieldName name) {
        return null;
    }

    @Override
    public ClusteringModel getModel() {
        Preconditions.checkState((this.clusteringModel != null ? 1 : 0) != 0);
        return this.clusteringModel;
    }

    public ClusteringModel createModel(ComparisonMeasure comparisonMeasure, ClusteringModel.ModelClass modelClass) {
        Preconditions.checkState((this.clusteringModel == null ? 1 : 0) != 0);
        this.clusteringModel = new ClusteringModel(new MiningSchema(), comparisonMeasure, MiningFunctionType.CLUSTERING, modelClass, Integer.valueOf(0));
        this.getModels().add((Model)this.clusteringModel);
        return this.clusteringModel;
    }

    @Override
    public BiMap<String, Cluster> getEntityRegistry() {
        HashBiMap result = HashBiMap.create();
        List<Cluster> clusters = this.getClusters();
        EntityUtil.putAll(clusters, result);
        return result;
    }

    public List<ClusteringField> getClusteringFields() {
        ClusteringModel clusteringModel = this.getModel();
        return clusteringModel.getClusteringFields();
    }

    public List<Cluster> getClusters() {
        ClusteringModel clusteringModel = this.getModel();
        return clusteringModel.getClusters();
    }
}

