/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.BayesInput;
import org.dmg.pmml.BayesInputs;
import org.dmg.pmml.BayesOutput;
import org.dmg.pmml.Extension;
import org.dmg.pmml.NaiveBayesModel;
import org.dmg.pmml.PMML;
import org.jpmml.manager.ExtensionUtil;
import org.jpmml.manager.ModelManager;

public class NaiveBayesModelManager
extends ModelManager<NaiveBayesModel> {
    private NaiveBayesModel naiveBayesModel = null;

    public NaiveBayesModelManager() {
    }

    public NaiveBayesModelManager(PMML pmml) {
        this(pmml, NaiveBayesModelManager.find(pmml.getModels(), NaiveBayesModel.class));
    }

    public NaiveBayesModelManager(PMML pmml, NaiveBayesModel naiveBayesModel) {
        super(pmml);
        this.naiveBayesModel = naiveBayesModel;
    }

    @Override
    public String getSummary() {
        return "Naive Bayes model";
    }

    @Override
    public NaiveBayesModel getModel() {
        Preconditions.checkState((this.naiveBayesModel != null ? 1 : 0) != 0);
        return this.naiveBayesModel;
    }

    public List<BayesInput> getBayesInputs() {
        NaiveBayesModel naiveBayesModel = this.getModel();
        ArrayList result = Lists.newArrayList();
        BayesInputs bayesInputs = naiveBayesModel.getBayesInputs();
        List extensions = bayesInputs.getExtensions();
        for (Extension extension : extensions) {
            BayesInput bayesInput = ExtensionUtil.getExtension(extension, BayesInput.class);
            if (bayesInput == null) continue;
            result.add(bayesInput);
        }
        result.addAll(bayesInputs.getBayesInputs());
        return result;
    }

    public BayesOutput getBayesOutput() {
        NaiveBayesModel naiveBayesModel = this.getModel();
        return naiveBayesModel.getBayesOutput();
    }
}

