/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import java.util.List;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Node;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.TreeModel;
import org.dmg.pmml.True;
import org.jpmml.manager.ModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeModelManager
extends ModelManager<TreeModel> {
    private TreeModel treeModel = null;
    private Node root = null;

    public TreeModelManager() {
    }

    public TreeModelManager(PMML pmml) {
        this(pmml, TreeModelManager.find(pmml.getContent(), TreeModel.class));
    }

    public TreeModelManager(PMML pmml, TreeModel treeModel) {
        super(pmml);
        this.treeModel = treeModel;
    }

    @Override
    public String getSummary() {
        return "Tree";
    }

    @Override
    public TreeModel getModel() {
        TreeModelManager.ensureNotNull(this.treeModel);
        return this.treeModel;
    }

    public TreeModel createClassificationModel() {
        return this.createModel(MiningFunctionType.CLASSIFICATION);
    }

    public TreeModel createModel(MiningFunctionType miningFunction) {
        TreeModelManager.ensureNull(this.treeModel);
        this.treeModel = new TreeModel(new MiningSchema(), new Node(), miningFunction);
        this.getModels().add((Model)this.treeModel);
        return this.treeModel;
    }

    public Node getOrCreateRoot() {
        if (this.root == null) {
            Predicate predicate;
            TreeModel treeModel = this.getModel();
            this.root = treeModel.getNode();
            if (this.root == null) {
                this.root = new Node();
                treeModel.setNode(this.root);
            }
            if ((predicate = this.root.getPredicate()) == null) {
                this.root.setPredicate((Predicate)new True());
            }
        }
        return this.root;
    }

    public Node addNode(Predicate predicate) {
        return this.addNode(this.getOrCreateRoot(), predicate);
    }

    public Node addNode(Node parentNode, Predicate predicate) {
        Node node = new Node();
        node.setPredicate(predicate);
        parentNode.getNodes().add(node);
        return node;
    }

    public ScoreDistribution getOrAddScoreDistribution(Node node, String value) {
        List scoreDistributions = node.getScoreDistributions();
        for (ScoreDistribution scoreDistribution : scoreDistributions) {
            if (!scoreDistribution.getValue().equals(value)) continue;
            return scoreDistribution;
        }
        ScoreDistribution scoreDistribution = new ScoreDistribution(value, 0.0);
        scoreDistributions.add(scoreDistribution);
        return scoreDistribution;
    }
}

