/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import java.util.List;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.MultipleModelMethodType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Segment;
import org.dmg.pmml.Segmentation;
import org.dmg.pmml.TreeModel;
import org.dmg.pmml.True;
import org.jpmml.manager.ModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiningModelManager
extends ModelManager<MiningModel> {
    private MiningModel miningModel = null;

    public MiningModelManager() {
    }

    public MiningModelManager(PMML pmml) {
        this(pmml, MiningModelManager.find(pmml.getContent(), MiningModel.class));
    }

    public MiningModelManager(PMML pmml, MiningModel miningModel) {
        super(pmml);
        this.miningModel = miningModel;
    }

    @Override
    public String getSummary() {
        MiningModel miningModel = this.getModel();
        if (MiningModelManager.isRandomForest(miningModel)) {
            return "Random forest";
        }
        return "Segmentation model";
    }

    @Override
    public MiningModel getModel() {
        MiningModelManager.ensureNotNull(this.miningModel);
        return this.miningModel;
    }

    public MiningModel createModel(MiningFunctionType miningFunction) {
        MiningModelManager.ensureNull(this.miningModel);
        this.miningModel = new MiningModel(new MiningSchema(), miningFunction);
        this.getModels().add((Model)this.miningModel);
        return this.miningModel;
    }

    public Segmentation getSegmentation() {
        MiningModel miningModel = this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        MiningModelManager.ensureNotNull(segmentation);
        return segmentation;
    }

    public Segmentation createSegmentation(MultipleModelMethodType multipleModelMethod) {
        MiningModel miningModel = this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        MiningModelManager.ensureNull(segmentation);
        segmentation = new Segmentation(multipleModelMethod);
        miningModel.setSegmentation(segmentation);
        return segmentation;
    }

    public Segment addSegment(Model model) {
        return this.addSegment((Predicate)new True(), model);
    }

    public Segment addSegment(Predicate predicate, Model model) {
        Segment segment = new Segment();
        segment.setPredicate(predicate);
        segment.setModel(model);
        this.getSegments().add(segment);
        return segment;
    }

    public List<Segment> getSegments() {
        return this.getSegmentation().getSegments();
    }

    private static boolean isRandomForest(MiningModel miningModel) {
        Segmentation segmentation = miningModel.getSegmentation();
        if (segmentation == null) {
            return false;
        }
        List segments = segmentation.getSegments();
        boolean result = segments.size() > 3;
        for (Segment segment : segments) {
            Model model = segment.getModel();
            result &= model instanceof TreeModel;
        }
        return result;
    }
}

