/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldUsageType;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.manager.Consumer;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.PMMLManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelManager<M extends Model>
extends PMMLManager
implements Consumer {
    private LocalTransformations localTransformations = null;
    private Output output = null;

    public ModelManager() {
    }

    public ModelManager(PMML pmml) {
        super(pmml);
    }

    public abstract M getModel();

    public void addField(FieldName name, String displayName, OpType opType, DataType dataType, FieldUsageType fieldUsageType) {
        this.addDataField(name, displayName, opType, dataType);
        this.addMiningField(name, fieldUsageType);
    }

    @Override
    public List<FieldName> getActiveFields() {
        return this.getMiningFields(FieldUsageType.ACTIVE);
    }

    public FieldName getTarget() {
        List<FieldName> fields = this.getPredictedFields();
        if (fields.size() < 1) {
            throw new InvalidFeatureException("No predicted fields", (PMMLObject)this.getMiningSchema());
        }
        if (fields.size() > 1) {
            throw new InvalidFeatureException("Too many predicted fields", (PMMLObject)this.getMiningSchema());
        }
        return fields.get(0);
    }

    @Override
    public List<FieldName> getPredictedFields() {
        return this.getMiningFields(FieldUsageType.PREDICTED);
    }

    public List<FieldName> getMiningFields(FieldUsageType fieldUsageType) {
        ArrayList<FieldName> result = new ArrayList<FieldName>();
        List miningFields = this.getMiningSchema().getMiningFields();
        for (MiningField miningField : miningFields) {
            if (!miningField.getUsageType().equals((Object)fieldUsageType)) continue;
            result.add(miningField.getName());
        }
        return result;
    }

    @Override
    public MiningField getMiningField(FieldName name) {
        List miningFields = this.getMiningSchema().getMiningFields();
        return (MiningField)ModelManager.find(miningFields, name);
    }

    public MiningField addMiningField(FieldName name, FieldUsageType usageType) {
        MiningField miningField = new MiningField(name);
        miningField.setUsageType(usageType);
        List miningFields = this.getMiningSchema().getMiningFields();
        miningFields.add(miningField);
        return miningField;
    }

    @Override
    public List<FieldName> getOutputFields() {
        ArrayList<FieldName> result = new ArrayList<FieldName>();
        Output output = this.getOrCreateOutput();
        List outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            result.add(outputField.getName());
        }
        return result;
    }

    @Override
    public OutputField getOutputField(FieldName name) {
        Output output = this.getOrCreateOutput();
        List outputFields = output.getOutputFields();
        return (OutputField)ModelManager.find(outputFields, name);
    }

    @Override
    public DerivedField resolve(FieldName name) {
        LocalTransformations localTransformations = this.getOrCreateLocalTransformations();
        List derivedFields = localTransformations.getDerivedFields();
        DerivedField derivedField = (DerivedField)ModelManager.find(derivedFields, name);
        if (derivedField == null) {
            derivedField = super.resolve(name);
        }
        return derivedField;
    }

    public MiningSchema getMiningSchema() {
        return this.getModel().getMiningSchema();
    }

    public LocalTransformations getOrCreateLocalTransformations() {
        if (this.localTransformations == null) {
            M model = this.getModel();
            LocalTransformations localTransformations = model.getLocalTransformations();
            if (localTransformations == null) {
                localTransformations = new LocalTransformations();
                model.setLocalTransformations(localTransformations);
            }
            this.localTransformations = localTransformations;
        }
        return this.localTransformations;
    }

    public Output getOrCreateOutput() {
        if (this.output == null) {
            M model = this.getModel();
            Output output = model.getOutput();
            if (output == null) {
                output = new Output();
                model.setOutput(output);
            }
            this.output = output;
        }
        return this.output;
    }

    protected static void ensureNull(Object object) {
        if (object != null) {
            throw new IllegalStateException();
        }
    }

    protected static void ensureNotNull(Object object) {
        if (object == null) {
            throw new IllegalStateException();
        }
    }
}

