/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasName;
import org.dmg.pmml.Header;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.ModelManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMMLManager
implements Serializable {
    private PMML pmml = null;
    private TransformationDictionary transformationDictionary = null;

    public PMMLManager() {
        this(new PMML(new Header(), new DataDictionary(), "4.1"));
    }

    public PMMLManager(PMML pmml) {
        this.setPmml(pmml);
    }

    public DataField getDataField(FieldName name) {
        List dataFields = this.getDataDictionary().getDataFields();
        return (DataField)PMMLManager.find(dataFields, name);
    }

    public DataField addDataField(FieldName name, String displayName, OpType opType, DataType dataType) {
        DataField dataField = new DataField(name, opType, dataType);
        dataField.setDisplayName(displayName);
        List dataFields = this.getDataDictionary().getDataFields();
        dataFields.add(dataField);
        return dataField;
    }

    public DerivedField resolve(FieldName name) {
        TransformationDictionary transformationDictionary = this.getOrCreateTransformationDictionary();
        List derivedFields = transformationDictionary.getDerivedFields();
        return (DerivedField)PMMLManager.find(derivedFields, name);
    }

    public PMML getPmml() {
        return this.pmml;
    }

    private void setPmml(PMML pmml) {
        this.pmml = pmml;
    }

    public Header getHeader() {
        return this.getPmml().getHeader();
    }

    public DataDictionary getDataDictionary() {
        return this.getPmml().getDataDictionary();
    }

    public TransformationDictionary getOrCreateTransformationDictionary() {
        if (this.transformationDictionary == null) {
            PMML pmml = this.getPmml();
            TransformationDictionary transformationDictionary = pmml.getTransformationDictionary();
            if (transformationDictionary == null) {
                transformationDictionary = new TransformationDictionary();
                pmml.setTransformationDictionary(transformationDictionary);
            }
            this.transformationDictionary = transformationDictionary;
        }
        return this.transformationDictionary;
    }

    public List<Model> getModels() {
        return this.getPmml().getContent();
    }

    public Model getModel(String modelName) {
        List<Model> models = this.getModels();
        if (modelName != null) {
            for (Model model : models) {
                if (!modelName.equals(model.getModelName())) continue;
                return model;
            }
            return null;
        }
        if (models.size() > 0) {
            return models.get(0);
        }
        return null;
    }

    public ModelManager<? extends Model> getModelManager(String modelName) {
        return this.getModelManager(modelName, ModelManagerFactory.getInstance());
    }

    public ModelManager<? extends Model> getModelManager(String modelName, ModelManagerFactory modelManagerFactory) {
        Model model = this.getModel(modelName);
        return modelManagerFactory.getModelManager(this.getPmml(), model);
    }

    public static <E extends PMMLObject> E find(List<? extends PMMLObject> objects, Class<? extends E> clazz) {
        for (PMMLObject pMMLObject : objects) {
            if (!pMMLObject.getClass().equals(clazz)) continue;
            return (E)pMMLObject;
        }
        return null;
    }

    public static <E extends PMMLObject> List<E> findAll(List<? extends PMMLObject> objects, Class<? extends E> clazz) {
        ArrayList<PMMLObject> result = new ArrayList<PMMLObject>();
        for (PMMLObject pMMLObject : objects) {
            if (!pMMLObject.getClass().equals(clazz)) continue;
            result.add(pMMLObject);
        }
        return result;
    }

    public static <E extends PMMLObject> E find(Collection<E> objects, FieldName name) {
        for (PMMLObject object : objects) {
            if (!((HasName)object).getName().equals((Object)name)) continue;
            return (E)object;
        }
        return null;
    }
}

