/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldUsageType;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.jpmml.manager.Consumer;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.PMMLManager;

public class ModelManager<M extends Model>
extends PMMLManager
implements Consumer {
    private M model = null;

    public ModelManager(PMML pmml, M model) {
        super(pmml);
        this.setModel(model);
    }

    public M getModel() {
        return this.model;
    }

    private void setModel(M model) {
        Preconditions.checkNotNull(model);
        this.model = model;
    }

    @Override
    public String getSummary() {
        return null;
    }

    @Override
    public List<FieldName> getActiveFields() {
        return this.getMiningFields(EnumSet.of(FieldUsageType.ACTIVE));
    }

    @Override
    public List<FieldName> getGroupFields() {
        return this.getMiningFields(EnumSet.of(FieldUsageType.GROUP));
    }

    @Override
    public List<FieldName> getTargetFields() {
        return this.getMiningFields(EnumSet.of(FieldUsageType.PREDICTED, FieldUsageType.TARGET));
    }

    @Override
    public FieldName getTargetField() {
        List<FieldName> targetFields = this.getTargetFields();
        if (targetFields.size() < 1) {
            return null;
        }
        if (targetFields.size() > 1) {
            throw new InvalidFeatureException("Too many target fields", (PMMLObject)this.getMiningSchema());
        }
        return targetFields.get(0);
    }

    @Override
    public MiningField getMiningField(FieldName name) {
        MiningSchema miningSchema = this.getMiningSchema();
        List miningFields = miningSchema.getMiningFields();
        return (MiningField)ModelManager.find(miningFields, name);
    }

    private List<FieldName> getMiningFields(EnumSet<FieldUsageType> fieldUsageTypes) {
        ArrayList result = Lists.newArrayList();
        MiningSchema miningSchema = this.getMiningSchema();
        List miningFields = miningSchema.getMiningFields();
        for (MiningField miningField : miningFields) {
            FieldUsageType fieldUsageType = miningField.getUsageType();
            if (!fieldUsageTypes.contains(fieldUsageType)) continue;
            result.add(miningField.getName());
        }
        return result;
    }

    public DerivedField getLocalDerivedField(FieldName name) {
        LocalTransformations localTransformations = this.getOrCreateLocalTransformations();
        List derivedFields = localTransformations.getDerivedFields();
        return (DerivedField)ModelManager.find(derivedFields, name);
    }

    public DerivedField resolveDerivedField(FieldName name) {
        DerivedField derivedField = this.getLocalDerivedField(name);
        if (derivedField == null) {
            return this.getDerivedField(name);
        }
        return derivedField;
    }

    @Override
    public OutputField getOutputField(FieldName name) {
        Output output = this.getOrCreateOutput();
        List outputFields = output.getOutputFields();
        return (OutputField)ModelManager.find(outputFields, name);
    }

    @Override
    public List<FieldName> getOutputFields() {
        ArrayList result = Lists.newArrayList();
        Output output = this.getOrCreateOutput();
        List outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            result.add(outputField.getName());
        }
        return result;
    }

    public Target getTarget(FieldName name) {
        Targets targets = this.getOrCreateTargets();
        for (Target target : targets) {
            if (!target.getField().equals((Object)name)) continue;
            return target;
        }
        return null;
    }

    public MiningSchema getMiningSchema() {
        M model = this.getModel();
        return model.getMiningSchema();
    }

    public LocalTransformations getOrCreateLocalTransformations() {
        M model = this.getModel();
        LocalTransformations localTransformations = model.getLocalTransformations();
        if (localTransformations == null) {
            localTransformations = new LocalTransformations();
            model.setLocalTransformations(localTransformations);
        }
        return localTransformations;
    }

    public Output getOrCreateOutput() {
        M model = this.getModel();
        Output output = model.getOutput();
        if (output == null) {
            output = new Output();
            model.setOutput(output);
        }
        return output;
    }

    public Targets getOrCreateTargets() {
        M model = this.getModel();
        Targets targets = model.getTargets();
        if (targets == null) {
            targets = new Targets();
            model.setTargets(targets);
        }
        return targets;
    }
}

