/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldUsageType;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.jpmml.manager.Consumer;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.PMMLManager;

public class ModelManager<M extends Model>
extends PMMLManager
implements Consumer {
    private M model = null;
    private static final EnumSet<FieldUsageType> ACTIVE_SET = EnumSet.of(FieldUsageType.ACTIVE);
    private static final EnumSet<FieldUsageType> GROUP_SET = EnumSet.of(FieldUsageType.GROUP);
    private static final EnumSet<FieldUsageType> ORDER_SET = EnumSet.of(FieldUsageType.ORDER);
    private static final EnumSet<FieldUsageType> TARGET_SET = EnumSet.of(FieldUsageType.PREDICTED, FieldUsageType.TARGET);

    public ModelManager(PMML pmml, M model) {
        super(pmml);
        this.setModel(model);
    }

    public M getModel() {
        return this.model;
    }

    private void setModel(M model) {
        this.model = (Model)Preconditions.checkNotNull(model);
    }

    @Override
    public String getSummary() {
        return null;
    }

    @Override
    public List<FieldName> getActiveFields() {
        return this.getMiningFields(ACTIVE_SET);
    }

    @Override
    public List<FieldName> getGroupFields() {
        return this.getMiningFields(GROUP_SET);
    }

    @Override
    public List<FieldName> getOrderFields() {
        return this.getMiningFields(ORDER_SET);
    }

    @Override
    public List<FieldName> getTargetFields() {
        return this.getMiningFields(TARGET_SET);
    }

    @Override
    public FieldName getTargetField() {
        List<FieldName> targetFields = this.getTargetFields();
        if (targetFields.size() < 1) {
            return null;
        }
        if (targetFields.size() > 1) {
            throw new InvalidFeatureException("Too many target fields", (PMMLObject)this.getMiningSchema());
        }
        return targetFields.get(0);
    }

    @Override
    public MiningField getMiningField(FieldName name) {
        MiningSchema miningSchema = this.getMiningSchema();
        List miningFields = miningSchema.getMiningFields();
        return (MiningField)ModelManager.find(miningFields, name);
    }

    protected List<FieldName> getMiningFields(EnumSet<FieldUsageType> fieldUsageTypes) {
        ArrayList result = Lists.newArrayList();
        MiningSchema miningSchema = this.getMiningSchema();
        List miningFields = miningSchema.getMiningFields();
        for (MiningField miningField : miningFields) {
            FieldUsageType fieldUsageType = miningField.getUsageType();
            if (!fieldUsageTypes.contains(fieldUsageType)) continue;
            result.add(miningField.getName());
        }
        return result;
    }

    public DerivedField getLocalDerivedField(FieldName name) {
        LocalTransformations localTransformations = this.getLocalTransformations();
        if (localTransformations == null) {
            return null;
        }
        List derivedFields = localTransformations.getDerivedFields();
        return (DerivedField)ModelManager.find(derivedFields, name);
    }

    public DerivedField resolveDerivedField(FieldName name) {
        DerivedField derivedField = this.getLocalDerivedField(name);
        if (derivedField == null) {
            return this.getDerivedField(name);
        }
        return derivedField;
    }

    @Override
    public OutputField getOutputField(FieldName name) {
        Output output = this.getOutput();
        if (output == null) {
            return null;
        }
        List outputFields = output.getOutputFields();
        return (OutputField)ModelManager.find(outputFields, name);
    }

    @Override
    public List<FieldName> getOutputFields() {
        Output output = this.getOutput();
        if (output == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        List outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            result.add(outputField.getName());
        }
        return result;
    }

    public Target getTarget(FieldName name) {
        Targets targets = this.getTargets();
        if (targets == null) {
            return null;
        }
        for (Target target : targets) {
            if (!target.getField().equals((Object)name)) continue;
            return target;
        }
        return null;
    }

    public MiningSchema getMiningSchema() {
        M model = this.getModel();
        return (MiningSchema)Preconditions.checkNotNull((Object)model.getMiningSchema());
    }

    public LocalTransformations getLocalTransformations() {
        M model = this.getModel();
        return model.getLocalTransformations();
    }

    public Output getOutput() {
        M model = this.getModel();
        return model.getOutput();
    }

    public Targets getTargets() {
        M model = this.getModel();
        return model.getTargets();
    }
}

