/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import java.lang.reflect.Field;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import org.dmg.pmml.PMMLObject;

public class PMMLObjectUtil {
    private PMMLObjectUtil() {
    }

    public static String getRootElementName(PMMLObject element) {
        Class<?> clazz = element.getClass();
        XmlRootElement xmlRootElement = clazz.getAnnotation(XmlRootElement.class);
        if (xmlRootElement == null) {
            throw new RuntimeException();
        }
        return xmlRootElement.name();
    }

    public static String getAttributeName(PMMLObject element, String name) {
        Field field;
        Class<?> clazz = element.getClass();
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe);
        }
        XmlAttribute xmlAttribute = field.getAnnotation(XmlAttribute.class);
        if (xmlAttribute == null) {
            throw new RuntimeException();
        }
        return xmlAttribute.name();
    }

    public static <E> E getAttributeValue(PMMLObject element, String name) {
        Field field;
        Class<?> clazz = element.getClass();
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe);
        }
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return (E)field.get(element);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public static String getValue(Enum<?> value) {
        Field field;
        Class<?> clazz = value.getClass();
        try {
            field = clazz.getField(value.name());
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe);
        }
        XmlEnumValue xmlEnumValue = field.getAnnotation(XmlEnumValue.class);
        if (xmlEnumValue == null) {
            throw new RuntimeException();
        }
        return xmlEnumValue.value();
    }
}

