/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.dmg.pmml.PMMLObject;

public class XPathUtil {
    private XPathUtil() {
    }

    public static String formatXPath(PMMLObject object) {
        Class<?> clazz = object.getClass();
        return XPathUtil.getElementName(clazz);
    }

    public static String formatXPath(PMMLObject object, Field field) {
        XmlElement element = field.getAnnotation(XmlElement.class);
        if (element != null) {
            Class elementClazz = field.getType();
            if (List.class.isAssignableFrom(elementClazz)) {
                ParameterizedType listType = (ParameterizedType)field.getGenericType();
                Type[] typeArguments = listType.getActualTypeArguments();
                if (typeArguments.length != 1) {
                    throw new RuntimeException();
                }
                elementClazz = (Class)typeArguments[0];
            }
            return XPathUtil.formatXPath(object) + "/" + XPathUtil.getElementName(elementClazz);
        }
        XmlAttribute attribute = field.getAnnotation(XmlAttribute.class);
        if (attribute != null) {
            return XPathUtil.formatXPath(object) + "@" + attribute.name();
        }
        throw new RuntimeException();
    }

    public static String formatXPath(PMMLObject object, Field field, Object value) {
        XmlAttribute attribute = field.getAnnotation(XmlAttribute.class);
        if (attribute != null) {
            return XPathUtil.formatXPath(object, field) + (value != null ? "=" + String.valueOf(value) : "");
        }
        throw new RuntimeException();
    }

    private static String getElementName(Class<?> clazz) {
        while (clazz != null) {
            XmlRootElement rootElement = clazz.getAnnotation(XmlRootElement.class);
            if (rootElement != null) {
                return rootElement.name();
            }
            clazz = clazz.getSuperclass();
        }
        throw new RuntimeException();
    }
}

