/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasName;
import org.dmg.pmml.Header;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.ModelManagerFactory;

public class PMMLManager
implements Serializable {
    private PMML pmml = null;

    public PMMLManager(PMML pmml) {
        this.setPMML(pmml);
    }

    public DataField getDataField(FieldName name) {
        DataDictionary dataDictionary = this.getDataDictionary();
        List dataFields = dataDictionary.getDataFields();
        return (DataField)PMMLManager.find(dataFields, name);
    }

    public DerivedField getDerivedField(FieldName name) {
        TransformationDictionary transformationDictionary = this.getTransformationDictionary();
        if (transformationDictionary == null) {
            return null;
        }
        List derivedFields = transformationDictionary.getDerivedFields();
        return (DerivedField)PMMLManager.find(derivedFields, name);
    }

    public DefineFunction getFunction(String name) {
        TransformationDictionary transformationDictionary = this.getTransformationDictionary();
        if (transformationDictionary == null) {
            return null;
        }
        List defineFunctions = transformationDictionary.getDefineFunctions();
        for (DefineFunction defineFunction : defineFunctions) {
            if (!defineFunction.getName().equals(name)) continue;
            return defineFunction;
        }
        return null;
    }

    public PMML getPMML() {
        return this.pmml;
    }

    private void setPMML(PMML pmml) {
        this.pmml = (PMML)Preconditions.checkNotNull((Object)pmml);
    }

    public Header getHeader() {
        PMML pmml = this.getPMML();
        return (Header)Preconditions.checkNotNull((Object)pmml.getHeader());
    }

    public DataDictionary getDataDictionary() {
        PMML pmml = this.getPMML();
        return (DataDictionary)Preconditions.checkNotNull((Object)pmml.getDataDictionary());
    }

    public TransformationDictionary getTransformationDictionary() {
        PMML pmml = this.getPMML();
        return pmml.getTransformationDictionary();
    }

    public List<Model> getModels() {
        PMML pmml = this.getPMML();
        return pmml.getModels();
    }

    public Model getModel(String modelName) {
        List<Model> models = this.getModels();
        for (Model model : models) {
            if (modelName != null && !modelName.equals(model.getModelName())) continue;
            return model;
        }
        return null;
    }

    public ModelManager<? extends Model> getModelManager(String modelName, ModelManagerFactory modelManagerFactory) {
        Model model = this.getModel(modelName);
        return modelManagerFactory.getModelManager(this.getPMML(), model);
    }

    public static <E extends PMMLObject> E find(List<?> objects, Class<? extends E> clazz) {
        for (Object object : objects) {
            if (!object.getClass().equals(clazz)) continue;
            return (E)((PMMLObject)object);
        }
        return null;
    }

    public static <E extends PMMLObject> List<E> findAll(List<?> objects, Class<? extends E> clazz) {
        ArrayList result = Lists.newArrayList();
        for (Object object : objects) {
            if (!object.getClass().equals(clazz)) continue;
            result.add((PMMLObject)object);
        }
        return result;
    }

    public static <E extends PMMLObject> E find(Collection<E> objects, FieldName name) {
        for (PMMLObject object : objects) {
            if (!((HasName)object).getName().equals((Object)name)) continue;
            return (E)object;
        }
        return null;
    }
}

