/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.io.filemappers.FileExtensionMapper;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.util.DirectoryScanner;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.jpmml.model.ImportFilter;
import org.jpmml.model.JAXBUtil;
import org.jpmml.model.SerializationUtil;
import org.jpmml.model.plugin.ModelSet;
import org.jpmml.model.visitors.LocatorNullifier;
import org.jpmml.model.visitors.LocatorTransformer;
import org.xml.sax.InputSource;

@Mojo(name="ser")
public class SerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter
    private FileMapper fileMapper = null;
    @Parameter(required=true)
    private List<ModelSet> modelSets = null;
    @Parameter
    private boolean keepLocator = false;
    @Parameter
    private List<String> visitorClasses = null;

    public SerMojo() {
        FileExtensionMapper fileMapper = new FileExtensionMapper();
        fileMapper.setTargetExtension("ser");
        this.fileMapper = fileMapper;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<ModelSet> modelSets;
        ArrayList<Class<? extends Visitor>> visitorClazzes = new ArrayList<Class<? extends Visitor>>();
        boolean keepLocator = this.getKeepLocator();
        visitorClazzes.add(keepLocator ? LocatorTransformer.class : LocatorNullifier.class);
        List<String> visitorClasses = this.getVisitorClasses();
        if (visitorClasses != null) {
            try {
                for (String visitorClass : visitorClasses) {
                    Class<?> clazz = Class.forName(visitorClass);
                    visitorClazzes.add(clazz.asSubclass(Visitor.class));
                }
            }
            catch (ClassCastException | ClassNotFoundException e) {
                throw new MojoFailureException("Invalid visitorClasses parameter", (Throwable)e);
            }
        }
        if ((modelSets = this.getModelSets()) == null || modelSets.isEmpty()) {
            throw new MojoFailureException("Missing modelSets parameter");
        }
        for (ModelSet modelSet : modelSets) {
            this.transform(modelSet, visitorClazzes);
        }
    }

    private void transform(ModelSet modelSet, List<Class<? extends Visitor>> visitorClazzes) throws MojoExecutionException {
        String[] names;
        Log log = this.getLog();
        log.info((CharSequence)("Processing model set from " + modelSet.getDir() + " to " + modelSet.getOutputDir()));
        FileMapper fileMapper = modelSet.getFileMapper();
        if (fileMapper == null) {
            fileMapper = this.getFileMapper();
        }
        File dir = this.resolveFile(modelSet.getDir());
        File outputDir = this.resolveFile(modelSet.getOutputDir());
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(dir);
        scanner.setIncludes(modelSet.getIncludes());
        scanner.setExcludes(modelSet.getExcludes());
        scanner.scan();
        for (String name : names = scanner.getIncludedFiles()) {
            log.info((CharSequence)("Processing model " + name));
            try {
                File pmmlFile = new File(dir, name);
                File serFile = new File(outputDir, fileMapper.getMappedFileName(name));
                File serDir = serFile.getParentFile();
                if (serDir != null && !serDir.exists()) {
                    serDir.mkdirs();
                }
                this.transform(pmmlFile, serFile, visitorClazzes);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to process model " + name, e);
            }
        }
    }

    private void transform(File pmmlFile, File serFile, List<Class<? extends Visitor>> visitorClazzes) throws Exception {
        PMML pmml;
        try (FileInputStream is = new FileInputStream(pmmlFile);){
            SAXSource source = ImportFilter.apply((InputSource)new InputSource(is));
            pmml = JAXBUtil.unmarshalPMML((Source)source);
        }
        for (Class<? extends Visitor> visitorClazz : visitorClazzes) {
            Visitor visitor = visitorClazz.newInstance();
            visitor.applyTo((Visitable)pmml);
        }
        var6_5 = null;
        try (FileOutputStream os = new FileOutputStream(serFile);){
            SerializationUtil.serializePMML((PMML)pmml, (OutputStream)os);
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
    }

    private File resolveFile(File file) {
        MavenProject project = this.getProject();
        if (!file.isAbsolute()) {
            file = new File(project.getBasedir(), file.getPath());
        }
        return file;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public FileMapper getFileMapper() {
        return this.fileMapper;
    }

    public void setFileMapper(FileMapper fileMapper) {
        this.fileMapper = fileMapper;
    }

    public List<ModelSet> getModelSets() {
        return this.modelSets;
    }

    public void setModelSets(List<ModelSet> modelSets) {
        this.modelSets = modelSets;
    }

    public boolean getKeepLocator() {
        return this.keepLocator;
    }

    public void setKeepLocator(boolean keepLocator) {
        this.keepLocator = keepLocator;
    }

    public List<String> getVisitorClasses() {
        return this.visitorClasses;
    }

    public void setVisitorClasses(List<String> visitorClasses) {
        this.visitorClasses = visitorClasses;
    }
}

