/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.io.filemappers.FileExtensionMapper;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.util.DirectoryScanner;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.jpmml.model.PMMLUtil;
import org.jpmml.model.VisitorBattery;
import org.jpmml.model.plugin.Format;
import org.jpmml.model.plugin.ModelSet;
import org.jpmml.model.visitors.LocatorNullifier;
import org.jpmml.model.visitors.LocatorTransformer;

@Mojo(name="ser")
public class SerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(defaultValue="SER")
    private Format format = null;
    @Parameter
    private FileMapper fileMapper = null;
    @Parameter(required=true)
    private List<ModelSet> modelSets = null;
    @Parameter
    private boolean keepLocator = false;
    @Parameter
    private List<String> visitorClasses = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<ModelSet> modelSets;
        FileMapper fileMapper;
        Format format = this.getFormat();
        if (format == null) {
            format = Format.SER;
            this.setFormat(format);
        }
        if ((fileMapper = this.getFileMapper()) == null) {
            String extension = format.name().toLowerCase();
            FileExtensionMapper fileExtensionMapper = new FileExtensionMapper();
            fileExtensionMapper.setTargetExtension(extension);
            fileMapper = fileExtensionMapper;
            this.setFileMapper(fileMapper);
        }
        VisitorBattery visitorBattery = new VisitorBattery();
        boolean keepLocator = this.getKeepLocator();
        visitorBattery.add(keepLocator ? LocatorTransformer.class : LocatorNullifier.class);
        List<String> visitorClasses = this.getVisitorClasses();
        if (visitorClasses != null) {
            try {
                for (String visitorClass : visitorClasses) {
                    Class<?> clazz = Class.forName(visitorClass);
                    visitorBattery.add(clazz.asSubclass(Visitor.class));
                }
            }
            catch (ClassCastException | ClassNotFoundException e) {
                throw new MojoFailureException("Invalid visitorClasses parameter", (Throwable)e);
            }
        }
        if ((modelSets = this.getModelSets()) == null || modelSets.isEmpty()) {
            throw new MojoFailureException("Missing modelSets parameter");
        }
        for (ModelSet modelSet : modelSets) {
            this.transform(modelSet, visitorBattery);
        }
    }

    private void transform(ModelSet modelSet, VisitorBattery visitorBattery) throws MojoExecutionException {
        String[] names;
        Log log = this.getLog();
        log.info((CharSequence)("Processing model set from " + modelSet.getDir() + " to " + modelSet.getOutputDir()));
        Format format = this.getFormat();
        FileMapper fileMapper = modelSet.getFileMapper();
        if (fileMapper == null) {
            fileMapper = this.getFileMapper();
        }
        File dir = this.resolveFile(modelSet.getDir());
        File outputDir = this.resolveFile(modelSet.getOutputDir());
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(dir);
        scanner.setIncludes(modelSet.getIncludes());
        scanner.setExcludes(modelSet.getExcludes());
        scanner.scan();
        for (String name : names = scanner.getIncludedFiles()) {
            log.info((CharSequence)("Processing model " + name));
            try {
                File pmmlFile = new File(dir, name);
                File outputFile = new File(outputDir, fileMapper.getMappedFileName(name));
                File outputParentDir = outputFile.getParentFile();
                if (outputParentDir != null && !outputParentDir.exists()) {
                    outputParentDir.mkdirs();
                }
                SerMojo.transform(format, pmmlFile, outputFile, visitorBattery);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to process model " + name, e);
            }
        }
    }

    private File resolveFile(File file) {
        MavenProject project = this.getProject();
        if (!file.isAbsolute()) {
            file = new File(project.getBasedir(), file.getPath());
        }
        return file;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public FileMapper getFileMapper() {
        return this.fileMapper;
    }

    public void setFileMapper(FileMapper fileMapper) {
        this.fileMapper = fileMapper;
    }

    public List<ModelSet> getModelSets() {
        return this.modelSets;
    }

    public void setModelSets(List<ModelSet> modelSets) {
        this.modelSets = modelSets;
    }

    public boolean getKeepLocator() {
        return this.keepLocator;
    }

    public void setKeepLocator(boolean keepLocator) {
        this.keepLocator = keepLocator;
    }

    public List<String> getVisitorClasses() {
        return this.visitorClasses;
    }

    public void setVisitorClasses(List<String> visitorClasses) {
        this.visitorClasses = visitorClasses;
    }

    private static void transform(Format format, File pmmlFile, File serFile, VisitorBattery visitorBattery) throws Exception {
        PMML pmml;
        try (FileInputStream is = new FileInputStream(pmmlFile);){
            pmml = PMMLUtil.unmarshal((InputStream)is);
        }
        visitorBattery.applyTo((Visitable)pmml);
        var6_5 = null;
        try (FileOutputStream os = new FileOutputStream(serFile);){
            format.write(pmml, os);
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
    }
}

