
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.jpmml.schema.Added;
import org.jpmml.schema.Deprecated;
import org.jpmml.schema.Version;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;choice maxOccurs="unbounded" minOccurs="0">
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}Regression"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}DecisionTree"/>
 *         &lt;/choice>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Segmentation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_2}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "embeddedModels",
    "segmentation",
    "modelVerification"
})
@XmlRootElement(name = "MiningModel", namespace = "http://www.dmg.org/PMML-4_2")
public class MiningModel
    extends Model
    implements Locatable, HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    protected MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_2")
    protected Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_2")
    protected ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_4_0)
    protected ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_2")
    protected Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_2")
    protected LocalTransformations localTransformations;
    @XmlElements({
        @XmlElement(name = "Regression", namespace = "http://www.dmg.org/PMML-4_2", type = Regression.class),
        @XmlElement(name = "DecisionTree", namespace = "http://www.dmg.org/PMML-4_2", type = DecisionTree.class)
    })
    @Deprecated(Version.PMML_4_1)
    protected List<EmbeddedModel> embeddedModels;
    @XmlElement(name = "Segmentation", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_4_0)
    protected Segmentation segmentation;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_2")
    protected ModelVerification modelVerification;
    @XmlAttribute(name = "modelName")
    protected String modelName;
    @XmlAttribute(name = "functionName", required = true)
    protected MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    protected String algorithmName;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    protected Boolean scorable;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public MiningModel() {
        super();
    }

    public MiningModel(final MiningSchema miningSchema, final MiningFunctionType functionName) {
        super();
        this.miningSchema = miningSchema;
        this.functionName = functionName;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public void setMiningSchema(MiningSchema value) {
        this.miningSchema = value;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public void setOutput(Output value) {
        this.output = value;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public void setModelStats(ModelStats value) {
        this.modelStats = value;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public void setModelExplanation(ModelExplanation value) {
        this.modelExplanation = value;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param value
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public void setTargets(Targets value) {
        this.targets = value;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public void setLocalTransformations(LocalTransformations value) {
        this.localTransformations = value;
    }

    /**
     * Gets the value of the embeddedModels property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the embeddedModels property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEmbeddedModels().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Regression }
     * {@link DecisionTree }
     * 
     * 
     */
    public List<EmbeddedModel> getEmbeddedModels() {
        if (embeddedModels == null) {
            embeddedModels = new ArrayList<EmbeddedModel>();
        }
        return this.embeddedModels;
    }

    /**
     * Gets the value of the segmentation property.
     * 
     * @return
     *     possible object is
     *     {@link Segmentation }
     *     
     */
    public Segmentation getSegmentation() {
        return segmentation;
    }

    /**
     * Sets the value of the segmentation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Segmentation }
     *     
     */
    public void setSegmentation(Segmentation value) {
        this.segmentation = value;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public void setModelVerification(ModelVerification value) {
        this.modelVerification = value;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setModelName(String value) {
        this.modelName = value;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public void setFunctionName(MiningFunctionType value) {
        this.functionName = value;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAlgorithmName(String value) {
        this.algorithmName = value;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setScorable(Boolean value) {
        this.scorable = value;
    }

    public MiningModel withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public MiningModel withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public MiningModel withMiningSchema(MiningSchema value) {
        setMiningSchema(value);
        return this;
    }

    public MiningModel withOutput(Output value) {
        setOutput(value);
        return this;
    }

    public MiningModel withModelStats(ModelStats value) {
        setModelStats(value);
        return this;
    }

    public MiningModel withModelExplanation(ModelExplanation value) {
        setModelExplanation(value);
        return this;
    }

    public MiningModel withTargets(Targets value) {
        setTargets(value);
        return this;
    }

    public MiningModel withLocalTransformations(LocalTransformations value) {
        setLocalTransformations(value);
        return this;
    }

    public MiningModel withEmbeddedModels(EmbeddedModel... values) {
        if (values!= null) {
            for (EmbeddedModel value: values) {
                getEmbeddedModels().add(value);
            }
        }
        return this;
    }

    public MiningModel withEmbeddedModels(Collection<EmbeddedModel> values) {
        if (values!= null) {
            getEmbeddedModels().addAll(values);
        }
        return this;
    }

    public MiningModel withSegmentation(Segmentation value) {
        setSegmentation(value);
        return this;
    }

    public MiningModel withModelVerification(ModelVerification value) {
        setModelVerification(value);
        return this;
    }

    public MiningModel withModelName(String value) {
        setModelName(value);
        return this;
    }

    public MiningModel withFunctionName(MiningFunctionType value) {
        setFunctionName(value);
        return this;
    }

    public MiningModel withAlgorithmName(String value) {
        setAlgorithmName(value);
        return this;
    }

    public MiningModel withScorable(Boolean value) {
        setScorable(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.miningSchema!= null)) {
            status = this.miningSchema.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.output!= null)) {
            status = this.output.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelStats!= null)) {
            status = this.modelStats.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelExplanation!= null)) {
            status = this.modelExplanation.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.targets!= null)) {
            status = this.targets.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.localTransformations!= null)) {
            status = this.localTransformations.accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.embeddedModels!= null))&&(i<this.embeddedModels.size())); i ++) {
            status = this.embeddedModels.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.segmentation!= null)) {
            status = this.segmentation.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.modelVerification!= null)) {
            status = this.modelVerification.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
