
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}SetReference"/>
 *         &lt;sequence maxOccurs="unbounded" minOccurs="0">
 *           &lt;group ref="{http://www.dmg.org/PMML-4_2}FOLLOW-SET"/>
 *         &lt;/sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Time" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="id" use="required" type="{http://www.dmg.org/PMML-4_2}ELEMENT-ID" />
 *       &lt;attribute name="numberOfSets" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="occurrence" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="support" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "setReference",
    "content",
    "time"
})
@XmlRootElement(name = "Sequence", namespace = "http://www.dmg.org/PMML-4_2")
public class Sequence
    extends PMMLObject
    implements Locatable, HasExtensions, HasId
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "SetReference", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    protected SetReference setReference;
    @XmlElements({
        @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2", type = Extension.class),
        @XmlElement(name = "Delimiter", namespace = "http://www.dmg.org/PMML-4_2", type = Delimiter.class),
        @XmlElement(name = "Time", namespace = "http://www.dmg.org/PMML-4_2", type = Time.class),
        @XmlElement(name = "SetReference", namespace = "http://www.dmg.org/PMML-4_2", type = SetReference.class)
    })
    protected List<PMMLObject> content;
    @XmlElement(name = "Time", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_3_1)
    protected Time time;
    @XmlAttribute(name = "id", required = true)
    protected String id;
    @XmlAttribute(name = "numberOfSets")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer numberOfSets;
    @XmlAttribute(name = "occurrence")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer occurrence;
    @XmlAttribute(name = "support")
    protected Double support;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    public Sequence() {
        super();
    }

    public Sequence(final SetReference setReference, final String id) {
        super();
        this.setReference = setReference;
        this.id = id;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the setReference property.
     * 
     * @return
     *     possible object is
     *     {@link SetReference }
     *     
     */
    public SetReference getSetReference() {
        return setReference;
    }

    /**
     * Sets the value of the setReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link SetReference }
     *     
     */
    public void setSetReference(SetReference value) {
        this.setReference = value;
    }

    /**
     * Gets the value of the content property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the content property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * {@link Delimiter }
     * {@link Time }
     * {@link SetReference }
     * 
     * 
     */
    public List<PMMLObject> getContent() {
        if (content == null) {
            content = new ArrayList<PMMLObject>();
        }
        return this.content;
    }

    /**
     * Gets the value of the time property.
     * 
     * @return
     *     possible object is
     *     {@link Time }
     *     
     */
    public Time getTime() {
        return time;
    }

    /**
     * Sets the value of the time property.
     * 
     * @param value
     *     allowed object is
     *     {@link Time }
     *     
     */
    public void setTime(Time value) {
        this.time = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the numberOfSets property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfSets() {
        return numberOfSets;
    }

    /**
     * Sets the value of the numberOfSets property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNumberOfSets(Integer value) {
        this.numberOfSets = value;
    }

    /**
     * Gets the value of the occurrence property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getOccurrence() {
        return occurrence;
    }

    /**
     * Sets the value of the occurrence property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOccurrence(Integer value) {
        this.occurrence = value;
    }

    /**
     * Gets the value of the support property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getSupport() {
        return support;
    }

    /**
     * Sets the value of the support property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setSupport(Double value) {
        this.support = value;
    }

    public Sequence withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public Sequence withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public Sequence withSetReference(SetReference value) {
        setSetReference(value);
        return this;
    }

    public Sequence withContent(PMMLObject... values) {
        if (values!= null) {
            for (PMMLObject value: values) {
                getContent().add(value);
            }
        }
        return this;
    }

    public Sequence withContent(Collection<PMMLObject> values) {
        if (values!= null) {
            getContent().addAll(values);
        }
        return this;
    }

    public Sequence withTime(Time value) {
        setTime(value);
        return this;
    }

    public Sequence withId(String value) {
        setId(value);
        return this;
    }

    public Sequence withNumberOfSets(Integer value) {
        setNumberOfSets(value);
        return this;
    }

    public Sequence withOccurrence(Integer value) {
        setOccurrence(value);
        return this;
    }

    public Sequence withSupport(Double value) {
        setSupport(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.setReference!= null)) {
            status = this.setReference.accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.content!= null))&&(i<this.content.size())); i ++) {
            status = this.content.get(i).accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&(this.time!= null)) {
            status = this.time.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
