
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.sun.xml.bind.Locatable;
import com.sun.xml.bind.annotation.XmlLocation;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.xml.sax.Locator;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}SupportVector" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="numberOfSupportVectors" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="numberOfAttributes" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "supportVectors"
})
@XmlRootElement(name = "SupportVectors", namespace = "http://www.dmg.org/PMML-4_2")
public class SupportVectors
    extends PMMLObject
    implements Iterable<SupportVector> , Locatable, HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "SupportVector", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    protected List<SupportVector> supportVectors;
    @XmlAttribute(name = "numberOfSupportVectors")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer numberOfSupportVectors;
    @XmlAttribute(name = "numberOfAttributes")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    protected Integer numberOfAttributes;
    @XmlLocation
    @XmlTransient
    protected Locator locator;

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the supportVectors property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supportVectors property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupportVectors().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupportVector }
     * 
     * 
     */
    public List<SupportVector> getSupportVectors() {
        if (supportVectors == null) {
            supportVectors = new ArrayList<SupportVector>();
        }
        return this.supportVectors;
    }

    /**
     * Gets the value of the numberOfSupportVectors property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfSupportVectors() {
        return numberOfSupportVectors;
    }

    /**
     * Sets the value of the numberOfSupportVectors property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNumberOfSupportVectors(Integer value) {
        this.numberOfSupportVectors = value;
    }

    /**
     * Gets the value of the numberOfAttributes property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfAttributes() {
        return numberOfAttributes;
    }

    /**
     * Sets the value of the numberOfAttributes property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNumberOfAttributes(Integer value) {
        this.numberOfAttributes = value;
    }

    public SupportVectors withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public SupportVectors withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public SupportVectors withSupportVectors(SupportVector... values) {
        if (values!= null) {
            for (SupportVector value: values) {
                getSupportVectors().add(value);
            }
        }
        return this;
    }

    public SupportVectors withSupportVectors(Collection<SupportVector> values) {
        if (values!= null) {
            getSupportVectors().addAll(values);
        }
        return this;
    }

    public SupportVectors withNumberOfSupportVectors(Integer value) {
        setNumberOfSupportVectors(value);
        return this;
    }

    public SupportVectors withNumberOfAttributes(Integer value) {
        setNumberOfAttributes(value);
        return this;
    }

    public Locator sourceLocation() {
        return locator;
    }

    public void setSourceLocation(Locator newLocator) {
        locator = newLocator;
    }

    public Iterator<SupportVector> iterator() {
        return getSupportVectors().iterator();
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.supportVectors!= null))&&(i<this.supportVectors.size())); i ++) {
            status = this.supportVectors.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
