
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;


/**
 * <p>Java class for LINK-FUNCTION.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="LINK-FUNCTION">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="cloglog"/>
 *     &lt;enumeration value="identity"/>
 *     &lt;enumeration value="log"/>
 *     &lt;enumeration value="logc"/>
 *     &lt;enumeration value="logit"/>
 *     &lt;enumeration value="loglog"/>
 *     &lt;enumeration value="cauchit"/>
 *     &lt;enumeration value="negbin"/>
 *     &lt;enumeration value="oddspower"/>
 *     &lt;enumeration value="power"/>
 *     &lt;enumeration value="probit"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "LINK-FUNCTION", namespace = "http://www.dmg.org/PMML-4_2")
@XmlEnum
@Added(Version.PMML_3_1)
public enum LinkFunctionType {

    @XmlEnumValue("cloglog")
    CLOGLOG("cloglog"),
    @XmlEnumValue("identity")
    @Added(Version.PMML_3_2)
    IDENTITY("identity"),
    @XmlEnumValue("log")
    @Added(Version.PMML_3_2)
    LOG("log"),
    @XmlEnumValue("logc")
    @Added(Version.PMML_3_2)
    LOGC("logc"),
    @XmlEnumValue("logit")
    LOGIT("logit"),
    @XmlEnumValue("loglog")
    LOGLOG("loglog"),
    @XmlEnumValue("cauchit")
    @Removed(Version.PMML_3_2)
    CAUCHIT("cauchit"),
    @XmlEnumValue("negbin")
    @Added(Version.PMML_3_2)
    NEGBIN("negbin"),
    @XmlEnumValue("oddspower")
    @Added(Version.PMML_3_2)
    ODDSPOWER("oddspower"),
    @XmlEnumValue("power")
    @Added(Version.PMML_3_2)
    POWER("power"),
    @XmlEnumValue("probit")
    PROBIT("probit");
    private final String value;

    LinkFunctionType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static LinkFunctionType fromValue(String v) {
        for (LinkFunctionType c: LinkFunctionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
