
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.DecimalAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="value" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="recordCount" use="required" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="confidence" type="{http://www.dmg.org/PMML-4_2}PROB-NUMBER" />
 *       &lt;attribute name="probability" type="{http://www.dmg.org/PMML-4_2}PROB-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "ScoreDistribution", namespace = "http://www.dmg.org/PMML-4_2")
public class ScoreDistribution
    extends PMMLObject
    implements HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlAttribute(name = "value", required = true)
    protected String value;
    @XmlAttribute(name = "recordCount", required = true)
    protected double recordCount;
    @XmlAttribute(name = "confidence")
    @XmlJavaTypeAdapter(DecimalAdapter.class)
    @Added(Version.PMML_3_1)
    protected Double confidence;
    @XmlAttribute(name = "probability")
    @XmlJavaTypeAdapter(DecimalAdapter.class)
    @Added(Version.PMML_4_1)
    protected Double probability;

    public ScoreDistribution() {
        super();
    }

    public ScoreDistribution(final String value, final double recordCount) {
        super();
        this.value = value;
        this.recordCount = recordCount;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Gets the value of the recordCount property.
     * 
     */
    public double getRecordCount() {
        return recordCount;
    }

    /**
     * Sets the value of the recordCount property.
     * 
     */
    public void setRecordCount(double value) {
        this.recordCount = value;
    }

    /**
     * Gets the value of the confidence property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Double getConfidence() {
        return confidence;
    }

    /**
     * Sets the value of the confidence property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setConfidence(Double value) {
        this.confidence = value;
    }

    /**
     * Gets the value of the probability property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Double getProbability() {
        return probability;
    }

    /**
     * Sets the value of the probability property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProbability(Double value) {
        this.probability = value;
    }

    public ScoreDistribution withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public ScoreDistribution withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public ScoreDistribution withValue(String value) {
        setValue(value);
        return this;
    }

    public ScoreDistribution withRecordCount(double value) {
        setRecordCount(value);
        return this;
    }

    public ScoreDistribution withConfidence(Double value) {
        setConfidence(value);
        return this;
    }

    public ScoreDistribution withProbability(Double value) {
        setProbability(value);
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
