
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_2}REAL-ARRAY" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="trend" default="additive">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}NMTOKEN">
 *             &lt;enumeration value="additive"/>
 *             &lt;enumeration value="damped_additive"/>
 *             &lt;enumeration value="multiplicative"/>
 *             &lt;enumeration value="damped_multiplicative"/>
 *             &lt;enumeration value="double_exponential"/>
 *             &lt;enumeration value="polynomial_exponential"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="gamma" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="phi" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="1" />
 *       &lt;attribute name="smoothedValue" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "array"
})
@Added(Version.PMML_4_0)
public class TrendExpoSmooth
    extends PMMLObject
{

    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_2")
    protected Array array;
    @XmlAttribute(name = "trend")
    protected TrendExpoSmooth.Trend trend;
    @XmlAttribute(name = "gamma")
    protected Double gamma;
    @XmlAttribute(name = "phi")
    protected Double phi;
    @XmlAttribute(name = "smoothedValue")
    protected Double smoothedValue;

    /**
     * Gets the value of the array property.
     * 
     * @return
     *     possible object is
     *     {@link Array }
     *     
     */
    public Array getArray() {
        return array;
    }

    /**
     * Sets the value of the array property.
     * 
     * @param value
     *     allowed object is
     *     {@link Array }
     *     
     */
    public void setArray(Array value) {
        this.array = value;
    }

    /**
     * Gets the value of the trend property.
     * 
     * @return
     *     possible object is
     *     {@link TrendExpoSmooth.Trend }
     *     
     */
    public TrendExpoSmooth.Trend getTrend() {
        if (trend == null) {
            return TrendExpoSmooth.Trend.ADDITIVE;
        } else {
            return trend;
        }
    }

    /**
     * Sets the value of the trend property.
     * 
     * @param value
     *     allowed object is
     *     {@link TrendExpoSmooth.Trend }
     *     
     */
    public void setTrend(TrendExpoSmooth.Trend value) {
        this.trend = value;
    }

    /**
     * Gets the value of the gamma property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getGamma() {
        return gamma;
    }

    /**
     * Sets the value of the gamma property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setGamma(Double value) {
        this.gamma = value;
    }

    /**
     * Gets the value of the phi property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getPhi() {
        if (phi == null) {
            return  1.0D;
        } else {
            return phi;
        }
    }

    /**
     * Sets the value of the phi property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setPhi(Double value) {
        this.phi = value;
    }

    /**
     * Gets the value of the smoothedValue property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getSmoothedValue() {
        return smoothedValue;
    }

    /**
     * Sets the value of the smoothedValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setSmoothedValue(Double value) {
        this.smoothedValue = value;
    }

    public TrendExpoSmooth withArray(Array value) {
        setArray(value);
        return this;
    }

    public TrendExpoSmooth withTrend(TrendExpoSmooth.Trend value) {
        setTrend(value);
        return this;
    }

    public TrendExpoSmooth withGamma(Double value) {
        setGamma(value);
        return this;
    }

    public TrendExpoSmooth withPhi(Double value) {
        setPhi(value);
        return this;
    }

    public TrendExpoSmooth withSmoothedValue(Double value) {
        setSmoothedValue(value);
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&(this.array!= null)) {
            status = this.array.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}NMTOKEN">
     *     &lt;enumeration value="additive"/>
     *     &lt;enumeration value="damped_additive"/>
     *     &lt;enumeration value="multiplicative"/>
     *     &lt;enumeration value="damped_multiplicative"/>
     *     &lt;enumeration value="double_exponential"/>
     *     &lt;enumeration value="polynomial_exponential"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum Trend {

        @XmlEnumValue("additive")
        ADDITIVE("additive"),
        @XmlEnumValue("damped_additive")
        DAMPED_ADDITIVE("damped_additive"),
        @XmlEnumValue("multiplicative")
        MULTIPLICATIVE("multiplicative"),
        @XmlEnumValue("damped_multiplicative")
        DAMPED_MULTIPLICATIVE("damped_multiplicative"),
        @XmlEnumValue("double_exponential")
        @Removed(Version.PMML_4_1)
        DOUBLE_EXPONENTIAL("double_exponential"),
        @XmlEnumValue("polynomial_exponential")
        @Added(Version.PMML_4_1)
        POLYNOMIAL_EXPONENTIAL("polynomial_exponential");
        private final String value;

        Trend(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TrendExpoSmooth.Trend fromValue(String v) {
            for (TrendExpoSmooth.Trend c: TrendExpoSmooth.Trend.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
