
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.DecimalAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="type" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="Model"/>
 *             &lt;enumeration value="Error"/>
 *             &lt;enumeration value="Total"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="sumOfSquares" use="required" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="degreesOfFreedom" use="required" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="meanOfSquares" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="fValue" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="pValue" type="{http://www.dmg.org/PMML-4_2}PROB-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "AnovaRow", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_0)
public class AnovaRow
    extends PMMLObject
    implements HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlAttribute(name = "type", required = true)
    protected String type;
    @XmlAttribute(name = "sumOfSquares", required = true)
    protected double sumOfSquares;
    @XmlAttribute(name = "degreesOfFreedom", required = true)
    protected double degreesOfFreedom;
    @XmlAttribute(name = "meanOfSquares")
    protected Double meanOfSquares;
    @XmlAttribute(name = "fValue")
    protected Double fValue;
    @XmlAttribute(name = "pValue")
    @XmlJavaTypeAdapter(DecimalAdapter.class)
    protected Double pValue;

    public AnovaRow() {
        super();
    }

    public AnovaRow(final String type, final double sumOfSquares, final double degreesOfFreedom) {
        super();
        this.type = type;
        this.sumOfSquares = sumOfSquares;
        this.degreesOfFreedom = degreesOfFreedom;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setType(String value) {
        this.type = value;
    }

    /**
     * Gets the value of the sumOfSquares property.
     * 
     */
    public double getSumOfSquares() {
        return sumOfSquares;
    }

    /**
     * Sets the value of the sumOfSquares property.
     * 
     */
    public void setSumOfSquares(double value) {
        this.sumOfSquares = value;
    }

    /**
     * Gets the value of the degreesOfFreedom property.
     * 
     */
    public double getDegreesOfFreedom() {
        return degreesOfFreedom;
    }

    /**
     * Sets the value of the degreesOfFreedom property.
     * 
     */
    public void setDegreesOfFreedom(double value) {
        this.degreesOfFreedom = value;
    }

    /**
     * Gets the value of the meanOfSquares property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMeanOfSquares() {
        return meanOfSquares;
    }

    /**
     * Sets the value of the meanOfSquares property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setMeanOfSquares(Double value) {
        this.meanOfSquares = value;
    }

    /**
     * Gets the value of the fValue property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getFValue() {
        return fValue;
    }

    /**
     * Sets the value of the fValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setFValue(Double value) {
        this.fValue = value;
    }

    /**
     * Gets the value of the pValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Double getPValue() {
        return pValue;
    }

    /**
     * Sets the value of the pValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPValue(Double value) {
        this.pValue = value;
    }

    public AnovaRow withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public AnovaRow withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public AnovaRow withType(String value) {
        setType(value);
        return this;
    }

    public AnovaRow withSumOfSquares(double value) {
        setSumOfSquares(value);
        return this;
    }

    public AnovaRow withDegreesOfFreedom(double value) {
        setDegreesOfFreedom(value);
        return this;
    }

    public AnovaRow withMeanOfSquares(Double value) {
        setMeanOfSquares(value);
        return this;
    }

    public AnovaRow withFValue(Double value) {
        setFValue(value);
        return this;
    }

    public AnovaRow withPValue(Double value) {
        setPValue(value);
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
