
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}NeuralOutput" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="numberOfOutputs" type="{http://www.w3.org/2001/XMLSchema}nonNegativeInteger" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "neuralOutputs"
})
@XmlRootElement(name = "NeuralOutputs", namespace = "http://www.dmg.org/PMML-4_2")
public class NeuralOutputs
    extends PMMLObject
    implements Iterable<NeuralOutput> , HasExtensions
{

    @XmlAttribute(name = "numberOfOutputs")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    protected Integer numberOfOutputs;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;
    @XmlElement(name = "NeuralOutput", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    protected List<NeuralOutput> neuralOutputs;

    public NeuralOutputs() {
        super();
    }

    public NeuralOutputs(final List<NeuralOutput> neuralOutputs) {
        super();
        this.neuralOutputs = neuralOutputs;
    }

    /**
     * Gets the value of the numberOfOutputs property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfOutputs() {
        return numberOfOutputs;
    }

    /**
     * Sets the value of the numberOfOutputs property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNumberOfOutputs(Integer value) {
        this.numberOfOutputs = value;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the neuralOutputs property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the neuralOutputs property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNeuralOutputs().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NeuralOutput }
     * 
     * 
     */
    public List<NeuralOutput> getNeuralOutputs() {
        if (neuralOutputs == null) {
            neuralOutputs = new ArrayList<NeuralOutput>();
        }
        return this.neuralOutputs;
    }

    public NeuralOutputs withNumberOfOutputs(Integer value) {
        setNumberOfOutputs(value);
        return this;
    }

    public NeuralOutputs withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public NeuralOutputs withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public NeuralOutputs withNeuralOutputs(NeuralOutput... values) {
        if (values!= null) {
            for (NeuralOutput value: values) {
                getNeuralOutputs().add(value);
            }
        }
        return this;
    }

    public NeuralOutputs withNeuralOutputs(Collection<NeuralOutput> values) {
        if (values!= null) {
            getNeuralOutputs().addAll(values);
        }
        return this;
    }

    public Iterator<NeuralOutput> iterator() {
        return getNeuralOutputs().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public boolean hasNeuralOutputs() {
        return ((this.neuralOutputs!= null)&&(this.neuralOutputs.size()> 0));
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.neuralOutputs!= null))&&(i<this.neuralOutputs.size())); i ++) {
            status = this.neuralOutputs.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
