
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TimeAnchor" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TimeException" maxOccurs="2" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TimeValue" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="usage" type="{http://www.dmg.org/PMML-4_2}TIMESERIES-USAGE" default="original" />
 *       &lt;attribute name="startTime" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="endTime" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="interpolationMethod" type="{http://www.dmg.org/PMML-4_2}INTERPOLATION-METHOD" default="none" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "timeAnchor",
    "timeExceptions",
    "timeValues"
})
@XmlRootElement(name = "TimeSeries", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_0)
public class TimeSeries
    extends PMMLObject
{

    @XmlAttribute(name = "usage")
    protected TimeSeriesUsageType usage;
    @XmlAttribute(name = "startTime")
    protected Double startTime;
    @XmlAttribute(name = "endTime")
    protected Double endTime;
    @XmlAttribute(name = "interpolationMethod")
    protected InterpolationMethodType interpolationMethod;
    @XmlElement(name = "TimeAnchor", namespace = "http://www.dmg.org/PMML-4_2")
    protected TimeAnchor timeAnchor;
    @XmlElement(name = "TimeException", namespace = "http://www.dmg.org/PMML-4_2")
    @Removed(Version.PMML_4_1)
    protected List<TimeException> timeExceptions;
    @XmlElement(name = "TimeValue", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<TimeValue> timeValues;

    /**
     * Gets the value of the usage property.
     * 
     * @return
     *     possible object is
     *     {@link TimeSeriesUsageType }
     *     
     */
    public TimeSeriesUsageType getUsage() {
        if (usage == null) {
            return TimeSeriesUsageType.ORIGINAL;
        } else {
            return usage;
        }
    }

    /**
     * Sets the value of the usage property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeSeriesUsageType }
     *     
     */
    public void setUsage(TimeSeriesUsageType value) {
        this.usage = value;
    }

    /**
     * Gets the value of the startTime property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getStartTime() {
        return startTime;
    }

    /**
     * Sets the value of the startTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setStartTime(Double value) {
        this.startTime = value;
    }

    /**
     * Gets the value of the endTime property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getEndTime() {
        return endTime;
    }

    /**
     * Sets the value of the endTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public void setEndTime(Double value) {
        this.endTime = value;
    }

    /**
     * Gets the value of the interpolationMethod property.
     * 
     * @return
     *     possible object is
     *     {@link InterpolationMethodType }
     *     
     */
    public InterpolationMethodType getInterpolationMethod() {
        if (interpolationMethod == null) {
            return InterpolationMethodType.NONE;
        } else {
            return interpolationMethod;
        }
    }

    /**
     * Sets the value of the interpolationMethod property.
     * 
     * @param value
     *     allowed object is
     *     {@link InterpolationMethodType }
     *     
     */
    public void setInterpolationMethod(InterpolationMethodType value) {
        this.interpolationMethod = value;
    }

    /**
     * Gets the value of the timeAnchor property.
     * 
     * @return
     *     possible object is
     *     {@link TimeAnchor }
     *     
     */
    public TimeAnchor getTimeAnchor() {
        return timeAnchor;
    }

    /**
     * Sets the value of the timeAnchor property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeAnchor }
     *     
     */
    public void setTimeAnchor(TimeAnchor value) {
        this.timeAnchor = value;
    }

    /**
     * Gets the value of the timeExceptions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the timeExceptions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTimeExceptions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TimeException }
     * 
     * 
     */
    public List<TimeException> getTimeExceptions() {
        if (timeExceptions == null) {
            timeExceptions = new ArrayList<TimeException>();
        }
        return this.timeExceptions;
    }

    /**
     * Gets the value of the timeValues property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the timeValues property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTimeValues().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TimeValue }
     * 
     * 
     */
    public List<TimeValue> getTimeValues() {
        if (timeValues == null) {
            timeValues = new ArrayList<TimeValue>();
        }
        return this.timeValues;
    }

    public TimeSeries withUsage(TimeSeriesUsageType value) {
        setUsage(value);
        return this;
    }

    public TimeSeries withStartTime(Double value) {
        setStartTime(value);
        return this;
    }

    public TimeSeries withEndTime(Double value) {
        setEndTime(value);
        return this;
    }

    public TimeSeries withInterpolationMethod(InterpolationMethodType value) {
        setInterpolationMethod(value);
        return this;
    }

    public TimeSeries withTimeAnchor(TimeAnchor value) {
        setTimeAnchor(value);
        return this;
    }

    public TimeSeries withTimeExceptions(TimeException... values) {
        if (values!= null) {
            for (TimeException value: values) {
                getTimeExceptions().add(value);
            }
        }
        return this;
    }

    public TimeSeries withTimeExceptions(Collection<TimeException> values) {
        if (values!= null) {
            getTimeExceptions().addAll(values);
        }
        return this;
    }

    public TimeSeries withTimeValues(TimeValue... values) {
        if (values!= null) {
            for (TimeValue value: values) {
                getTimeValues().add(value);
            }
        }
        return this;
    }

    public TimeSeries withTimeValues(Collection<TimeValue> values) {
        if (values!= null) {
            getTimeValues().addAll(values);
        }
        return this;
    }

    public boolean hasTimeExceptions() {
        return ((this.timeExceptions!= null)&&(this.timeExceptions.size()> 0));
    }

    public boolean hasTimeValues() {
        return ((this.timeValues!= null)&&(this.timeValues.size()> 0));
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&(this.timeAnchor!= null)) {
            status = this.timeAnchor.accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.timeExceptions!= null))&&(i<this.timeExceptions.size())); i ++) {
            status = this.timeExceptions.get(i).accept(visitor);
        }
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.timeValues!= null))&&(i<this.timeValues.size())); i ++) {
            status = this.timeValues.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
