
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="localTermWeights" default="termFrequency">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="termFrequency"/>
 *             &lt;enumeration value="binary"/>
 *             &lt;enumeration value="logarithmic"/>
 *             &lt;enumeration value="augmentedNormalizedTermFrequency"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="globalTermWeights" default="inverseDocumentFrequency">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="inverseDocumentFrequency"/>
 *             &lt;enumeration value="none"/>
 *             &lt;enumeration value="GFIDF"/>
 *             &lt;enumeration value="normal"/>
 *             &lt;enumeration value="probabilisticInverse"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="documentNormalization" default="none">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="none"/>
 *             &lt;enumeration value="cosine"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "TextModelNormalization", namespace = "http://www.dmg.org/PMML-4_2")
public class TextModelNormalization
    extends PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "localTermWeights")
    protected TextModelNormalization.LocalTermWeights localTermWeights;
    @XmlAttribute(name = "globalTermWeights")
    protected TextModelNormalization.GlobalTermWeights globalTermWeights;
    @XmlAttribute(name = "documentNormalization")
    protected TextModelNormalization.DocumentNormalization documentNormalization;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;

    /**
     * Gets the value of the localTermWeights property.
     * 
     * @return
     *     possible object is
     *     {@link TextModelNormalization.LocalTermWeights }
     *     
     */
    public TextModelNormalization.LocalTermWeights getLocalTermWeights() {
        if (localTermWeights == null) {
            return TextModelNormalization.LocalTermWeights.TERM_FREQUENCY;
        } else {
            return localTermWeights;
        }
    }

    /**
     * Sets the value of the localTermWeights property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextModelNormalization.LocalTermWeights }
     *     
     */
    public void setLocalTermWeights(TextModelNormalization.LocalTermWeights value) {
        this.localTermWeights = value;
    }

    /**
     * Gets the value of the globalTermWeights property.
     * 
     * @return
     *     possible object is
     *     {@link TextModelNormalization.GlobalTermWeights }
     *     
     */
    public TextModelNormalization.GlobalTermWeights getGlobalTermWeights() {
        if (globalTermWeights == null) {
            return TextModelNormalization.GlobalTermWeights.INVERSE_DOCUMENT_FREQUENCY;
        } else {
            return globalTermWeights;
        }
    }

    /**
     * Sets the value of the globalTermWeights property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextModelNormalization.GlobalTermWeights }
     *     
     */
    public void setGlobalTermWeights(TextModelNormalization.GlobalTermWeights value) {
        this.globalTermWeights = value;
    }

    /**
     * Gets the value of the documentNormalization property.
     * 
     * @return
     *     possible object is
     *     {@link TextModelNormalization.DocumentNormalization }
     *     
     */
    public TextModelNormalization.DocumentNormalization getDocumentNormalization() {
        if (documentNormalization == null) {
            return TextModelNormalization.DocumentNormalization.NONE;
        } else {
            return documentNormalization;
        }
    }

    /**
     * Sets the value of the documentNormalization property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextModelNormalization.DocumentNormalization }
     *     
     */
    public void setDocumentNormalization(TextModelNormalization.DocumentNormalization value) {
        this.documentNormalization = value;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public TextModelNormalization withLocalTermWeights(TextModelNormalization.LocalTermWeights value) {
        setLocalTermWeights(value);
        return this;
    }

    public TextModelNormalization withGlobalTermWeights(TextModelNormalization.GlobalTermWeights value) {
        setGlobalTermWeights(value);
        return this;
    }

    public TextModelNormalization withDocumentNormalization(TextModelNormalization.DocumentNormalization value) {
        setDocumentNormalization(value);
        return this;
    }

    public TextModelNormalization withExtensions(Extension... values) {
        if (values!= null) {
            for (Extension value: values) {
                getExtensions().add(value);
            }
        }
        return this;
    }

    public TextModelNormalization withExtensions(Collection<Extension> values) {
        if (values!= null) {
            getExtensions().addAll(values);
        }
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; (((status == VisitorAction.CONTINUE)&&(this.extensions!= null))&&(i<this.extensions.size())); i ++) {
            status = this.extensions.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="none"/>
     *     &lt;enumeration value="cosine"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum DocumentNormalization {

        @XmlEnumValue("none")
        NONE("none"),
        @XmlEnumValue("cosine")
        COSINE("cosine");
        private final String value;

        DocumentNormalization(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TextModelNormalization.DocumentNormalization fromValue(String v) {
            for (TextModelNormalization.DocumentNormalization c: TextModelNormalization.DocumentNormalization.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="inverseDocumentFrequency"/>
     *     &lt;enumeration value="none"/>
     *     &lt;enumeration value="GFIDF"/>
     *     &lt;enumeration value="normal"/>
     *     &lt;enumeration value="probabilisticInverse"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum GlobalTermWeights {

        @XmlEnumValue("inverseDocumentFrequency")
        INVERSE_DOCUMENT_FREQUENCY("inverseDocumentFrequency"),
        @XmlEnumValue("none")
        NONE("none"),
        GFIDF("GFIDF"),
        @XmlEnumValue("normal")
        NORMAL("normal"),
        @XmlEnumValue("probabilisticInverse")
        PROBABILISTIC_INVERSE("probabilisticInverse");
        private final String value;

        GlobalTermWeights(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TextModelNormalization.GlobalTermWeights fromValue(String v) {
            for (TextModelNormalization.GlobalTermWeights c: TextModelNormalization.GlobalTermWeights.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="termFrequency"/>
     *     &lt;enumeration value="binary"/>
     *     &lt;enumeration value="logarithmic"/>
     *     &lt;enumeration value="augmentedNormalizedTermFrequency"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum LocalTermWeights {

        @XmlEnumValue("termFrequency")
        TERM_FREQUENCY("termFrequency"),
        @XmlEnumValue("binary")
        BINARY("binary"),
        @XmlEnumValue("logarithmic")
        LOGARITHMIC("logarithmic"),
        @XmlEnumValue("augmentedNormalizedTermFrequency")
        AUGMENTED_NORMALIZED_TERM_FREQUENCY("augmentedNormalizedTermFrequency");
        private final String value;

        LocalTermWeights(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TextModelNormalization.LocalTermWeights fromValue(String v) {
            for (TextModelNormalization.LocalTermWeights c: TextModelNormalization.LocalTermWeights.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
