
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ComparisonMeasure"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ClusteringField" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}CenterFields" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MissingValueWeights" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Cluster" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_2}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="modelClass" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="centerBased"/>
 *             &lt;enumeration value="distributionBased"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="numberOfClusters" use="required" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "localTransformations",
    "comparisonMeasure",
    "clusteringFields",
    "centerFields",
    "missingValueWeights",
    "clusters",
    "modelVerification"
})
@XmlRootElement(name = "ClusteringModel", namespace = "http://www.dmg.org/PMML-4_2")
public class ClusteringModel
    extends Model
    implements HasExtensions
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "modelClass", required = true)
    private ClusteringModel.ModelClass modelClass;
    @XmlAttribute(name = "numberOfClusters", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer numberOfClusters;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_2")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_4_0)
    private ModelExplanation modelExplanation;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name = "ComparisonMeasure", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private ComparisonMeasure comparisonMeasure;
    @XmlElement(name = "ClusteringField", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private List<ClusteringField> clusteringFields;
    @XmlElement(name = "CenterFields", namespace = "http://www.dmg.org/PMML-4_2")
    @Removed(Version.PMML_3_2)
    private CenterFields centerFields;
    @XmlElement(name = "MissingValueWeights", namespace = "http://www.dmg.org/PMML-4_2")
    private MissingValueWeights missingValueWeights;
    @XmlElement(name = "Cluster", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private List<Cluster> clusters;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelVerification modelVerification;

    public ClusteringModel() {
        super();
    }

    public ClusteringModel(final MiningFunctionType functionName, final ClusteringModel.ModelClass modelClass, final Integer numberOfClusters, final MiningSchema miningSchema, final ComparisonMeasure comparisonMeasure, final List<ClusteringField> clusteringFields, final List<Cluster> clusters) {
        super();
        this.functionName = functionName;
        this.modelClass = modelClass;
        this.numberOfClusters = numberOfClusters;
        this.miningSchema = miningSchema;
        this.comparisonMeasure = comparisonMeasure;
        this.clusteringFields = clusteringFields;
        this.clusters = clusters;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public ClusteringModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public ClusteringModel setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public ClusteringModel setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the modelClass property.
     * 
     * @return
     *     possible object is
     *     {@link ClusteringModel.ModelClass }
     *     
     */
    public ClusteringModel.ModelClass getModelClass() {
        return modelClass;
    }

    /**
     * Sets the value of the modelClass property.
     * 
     * @param value
     *     allowed object is
     *     {@link ClusteringModel.ModelClass }
     *     
     */
    public ClusteringModel setModelClass(ClusteringModel.ModelClass modelClass) {
        this.modelClass = modelClass;
        return this;
    }

    /**
     * Gets the value of the numberOfClusters property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfClusters() {
        return numberOfClusters;
    }

    /**
     * Sets the value of the numberOfClusters property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public ClusteringModel setNumberOfClusters(Integer numberOfClusters) {
        this.numberOfClusters = numberOfClusters;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public ClusteringModel setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public ClusteringModel setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param value
     *     allowed object is
     *     {@link Output }
     *     
     */
    public ClusteringModel setOutput(Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public ClusteringModel setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public ClusteringModel setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public ClusteringModel setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the comparisonMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link ComparisonMeasure }
     *     
     */
    public ComparisonMeasure getComparisonMeasure() {
        return comparisonMeasure;
    }

    /**
     * Sets the value of the comparisonMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link ComparisonMeasure }
     *     
     */
    public ClusteringModel setComparisonMeasure(ComparisonMeasure comparisonMeasure) {
        this.comparisonMeasure = comparisonMeasure;
        return this;
    }

    /**
     * Gets the value of the clusteringFields property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the clusteringFields property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getClusteringFields().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ClusteringField }
     * 
     * 
     */
    public List<ClusteringField> getClusteringFields() {
        if (clusteringFields == null) {
            clusteringFields = new ArrayList<ClusteringField>();
        }
        return this.clusteringFields;
    }

    /**
     * Gets the value of the centerFields property.
     * 
     * @return
     *     possible object is
     *     {@link CenterFields }
     *     
     */
    public CenterFields getCenterFields() {
        return centerFields;
    }

    /**
     * Sets the value of the centerFields property.
     * 
     * @param value
     *     allowed object is
     *     {@link CenterFields }
     *     
     */
    public ClusteringModel setCenterFields(CenterFields centerFields) {
        this.centerFields = centerFields;
        return this;
    }

    /**
     * Gets the value of the missingValueWeights property.
     * 
     * @return
     *     possible object is
     *     {@link MissingValueWeights }
     *     
     */
    public MissingValueWeights getMissingValueWeights() {
        return missingValueWeights;
    }

    /**
     * Sets the value of the missingValueWeights property.
     * 
     * @param value
     *     allowed object is
     *     {@link MissingValueWeights }
     *     
     */
    public ClusteringModel setMissingValueWeights(MissingValueWeights missingValueWeights) {
        this.missingValueWeights = missingValueWeights;
        return this;
    }

    /**
     * Gets the value of the clusters property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the clusters property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getClusters().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Cluster }
     * 
     * 
     */
    public List<Cluster> getClusters() {
        if (clusters == null) {
            clusters = new ArrayList<Cluster>();
        }
        return this.clusters;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public ClusteringModel setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ClusteringModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasClusteringFields() {
        return ((this.clusteringFields!= null)&&(this.clusteringFields.size()> 0));
    }

    public ClusteringModel addClusteringFields(ClusteringField... clusteringFields) {
        getClusteringFields().addAll(Arrays.asList(clusteringFields));
        return this;
    }

    public boolean hasClusters() {
        return ((this.clusters!= null)&&(this.clusters.size()> 0));
    }

    public ClusteringModel addClusters(Cluster... clusters) {
        getClusters().addAll(Arrays.asList(clusters));
        return this;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @throws UnsupportedOperationException
     *     Always.
     */
    @Override
    public Targets getTargets() {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets the value of the targets property.
     * 
     * @throws UnsupportedOperationException
     *     Always.
     */
    @Override
    public ClusteringModel setTargets(Targets targets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = PMMLObject.traverse(visitor, getExtensions());
        }
        MiningSchema miningSchema = getMiningSchema();
        if ((status == VisitorAction.CONTINUE)&&(miningSchema!= null)) {
            status = miningSchema.accept(visitor);
        }
        Output output = getOutput();
        if ((status == VisitorAction.CONTINUE)&&(output!= null)) {
            status = output.accept(visitor);
        }
        ModelStats modelStats = getModelStats();
        if ((status == VisitorAction.CONTINUE)&&(modelStats!= null)) {
            status = modelStats.accept(visitor);
        }
        ModelExplanation modelExplanation = getModelExplanation();
        if ((status == VisitorAction.CONTINUE)&&(modelExplanation!= null)) {
            status = modelExplanation.accept(visitor);
        }
        LocalTransformations localTransformations = getLocalTransformations();
        if ((status == VisitorAction.CONTINUE)&&(localTransformations!= null)) {
            status = localTransformations.accept(visitor);
        }
        ComparisonMeasure comparisonMeasure = getComparisonMeasure();
        if ((status == VisitorAction.CONTINUE)&&(comparisonMeasure!= null)) {
            status = comparisonMeasure.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&hasClusteringFields()) {
            status = PMMLObject.traverse(visitor, getClusteringFields());
        }
        CenterFields centerFields = getCenterFields();
        if ((status == VisitorAction.CONTINUE)&&(centerFields!= null)) {
            status = centerFields.accept(visitor);
        }
        MissingValueWeights missingValueWeights = getMissingValueWeights();
        if ((status == VisitorAction.CONTINUE)&&(missingValueWeights!= null)) {
            status = missingValueWeights.accept(visitor);
        }
        if ((status == VisitorAction.CONTINUE)&&hasClusters()) {
            status = PMMLObject.traverse(visitor, getClusters());
        }
        ModelVerification modelVerification = getModelVerification();
        if ((status == VisitorAction.CONTINUE)&&(modelVerification!= null)) {
            status = modelVerification.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="centerBased"/>
     *     &lt;enumeration value="distributionBased"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum ModelClass {

        @XmlEnumValue("centerBased")
        CENTER_BASED("centerBased"),
        @XmlEnumValue("distributionBased")
        DISTRIBUTION_BASED("distributionBased");
        private final String value;

        ModelClass(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static ClusteringModel.ModelClass fromValue(String v) {
            for (ClusteringModel.ModelClass c: ClusteringModel.ModelClass.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
