
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ConfusionMatrix" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LiftData" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ROC" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="targetField" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="dataName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="dataUsage" default="training">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="training"/>
 *             &lt;enumeration value="test"/>
 *             &lt;enumeration value="validation"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="meanError" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="meanAbsoluteError" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="meanSquaredError" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="rootMeanSquaredError" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="r-squared" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="adj-r-squared" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="sumSquaredError" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="sumSquaredRegression" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="numOfRecords" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="numOfRecordsWeighted" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="numOfPredictors" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="degreesOfFreedom" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="fStatistic" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="AIC" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="BIC" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="AICc" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "confusionMatrix",
    "liftData",
    "roc"
})
@XmlRootElement(name = "PredictiveModelQuality", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_0)
public class PredictiveModelQuality
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "targetField", required = true)
    private String targetField;
    @XmlAttribute(name = "dataName")
    private String dataName;
    @XmlAttribute(name = "dataUsage")
    private String dataUsage;
    @XmlAttribute(name = "meanError")
    private Double meanError;
    @XmlAttribute(name = "meanAbsoluteError")
    private Double meanAbsoluteError;
    @XmlAttribute(name = "meanSquaredError")
    private Double meanSquaredError;
    @XmlAttribute(name = "rootMeanSquaredError")
    @Added(Version.PMML_4_1)
    private Double rootMeanSquaredError;
    @XmlAttribute(name = "r-squared")
    private Double rSquared;
    @XmlAttribute(name = "adj-r-squared")
    @Added(Version.PMML_4_1)
    private Double adjRSquared;
    @XmlAttribute(name = "sumSquaredError")
    @Added(Version.PMML_4_1)
    private Double sumSquaredError;
    @XmlAttribute(name = "sumSquaredRegression")
    @Added(Version.PMML_4_1)
    private Double sumSquaredRegression;
    @XmlAttribute(name = "numOfRecords")
    @Added(Version.PMML_4_1)
    private Double numOfRecords;
    @XmlAttribute(name = "numOfRecordsWeighted")
    @Added(Version.PMML_4_1)
    private Double numOfRecordsWeighted;
    @XmlAttribute(name = "numOfPredictors")
    @Added(Version.PMML_4_1)
    private Double numOfPredictors;
    @XmlAttribute(name = "degreesOfFreedom")
    @Added(Version.PMML_4_1)
    private Double degreesOfFreedom;
    @XmlAttribute(name = "fStatistic")
    @Added(Version.PMML_4_1)
    private Double fStatistic;
    @XmlAttribute(name = "AIC")
    @Added(Version.PMML_4_1)
    private Double aic;
    @XmlAttribute(name = "BIC")
    @Added(Version.PMML_4_1)
    private Double bic;
    @XmlAttribute(name = "AICc")
    @Added(Version.PMML_4_1)
    private Double aiCc;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "ConfusionMatrix", namespace = "http://www.dmg.org/PMML-4_2")
    private ConfusionMatrix confusionMatrix;
    @XmlElement(name = "LiftData", namespace = "http://www.dmg.org/PMML-4_2")
    private LiftData liftData;
    @XmlElement(name = "ROC", namespace = "http://www.dmg.org/PMML-4_2")
    private ROC roc;

    public PredictiveModelQuality() {
        super();
    }

    public PredictiveModelQuality(final String targetField) {
        super();
        this.targetField = targetField;
    }

    /**
     * Gets the value of the targetField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetField() {
        return targetField;
    }

    /**
     * Sets the value of the targetField property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public PredictiveModelQuality setTargetField(String targetField) {
        this.targetField = targetField;
        return this;
    }

    /**
     * Gets the value of the dataName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDataName() {
        return dataName;
    }

    /**
     * Sets the value of the dataName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public PredictiveModelQuality setDataName(String dataName) {
        this.dataName = dataName;
        return this;
    }

    /**
     * Gets the value of the dataUsage property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDataUsage() {
        if (dataUsage == null) {
            return "training";
        } else {
            return dataUsage;
        }
    }

    /**
     * Sets the value of the dataUsage property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public PredictiveModelQuality setDataUsage(String dataUsage) {
        this.dataUsage = dataUsage;
        return this;
    }

    /**
     * Gets the value of the meanError property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMeanError() {
        return meanError;
    }

    /**
     * Sets the value of the meanError property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setMeanError(Double meanError) {
        this.meanError = meanError;
        return this;
    }

    /**
     * Gets the value of the meanAbsoluteError property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMeanAbsoluteError() {
        return meanAbsoluteError;
    }

    /**
     * Sets the value of the meanAbsoluteError property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setMeanAbsoluteError(Double meanAbsoluteError) {
        this.meanAbsoluteError = meanAbsoluteError;
        return this;
    }

    /**
     * Gets the value of the meanSquaredError property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMeanSquaredError() {
        return meanSquaredError;
    }

    /**
     * Sets the value of the meanSquaredError property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setMeanSquaredError(Double meanSquaredError) {
        this.meanSquaredError = meanSquaredError;
        return this;
    }

    /**
     * Gets the value of the rootMeanSquaredError property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getRootMeanSquaredError() {
        return rootMeanSquaredError;
    }

    /**
     * Sets the value of the rootMeanSquaredError property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setRootMeanSquaredError(Double rootMeanSquaredError) {
        this.rootMeanSquaredError = rootMeanSquaredError;
        return this;
    }

    /**
     * Gets the value of the rSquared property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getRSquared() {
        return rSquared;
    }

    /**
     * Sets the value of the rSquared property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setRSquared(Double rSquared) {
        this.rSquared = rSquared;
        return this;
    }

    /**
     * Gets the value of the adjRSquared property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getAdjRSquared() {
        return adjRSquared;
    }

    /**
     * Sets the value of the adjRSquared property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setAdjRSquared(Double adjRSquared) {
        this.adjRSquared = adjRSquared;
        return this;
    }

    /**
     * Gets the value of the sumSquaredError property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getSumSquaredError() {
        return sumSquaredError;
    }

    /**
     * Sets the value of the sumSquaredError property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setSumSquaredError(Double sumSquaredError) {
        this.sumSquaredError = sumSquaredError;
        return this;
    }

    /**
     * Gets the value of the sumSquaredRegression property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getSumSquaredRegression() {
        return sumSquaredRegression;
    }

    /**
     * Sets the value of the sumSquaredRegression property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setSumSquaredRegression(Double sumSquaredRegression) {
        this.sumSquaredRegression = sumSquaredRegression;
        return this;
    }

    /**
     * Gets the value of the numOfRecords property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getNumOfRecords() {
        return numOfRecords;
    }

    /**
     * Sets the value of the numOfRecords property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setNumOfRecords(Double numOfRecords) {
        this.numOfRecords = numOfRecords;
        return this;
    }

    /**
     * Gets the value of the numOfRecordsWeighted property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getNumOfRecordsWeighted() {
        return numOfRecordsWeighted;
    }

    /**
     * Sets the value of the numOfRecordsWeighted property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setNumOfRecordsWeighted(Double numOfRecordsWeighted) {
        this.numOfRecordsWeighted = numOfRecordsWeighted;
        return this;
    }

    /**
     * Gets the value of the numOfPredictors property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getNumOfPredictors() {
        return numOfPredictors;
    }

    /**
     * Sets the value of the numOfPredictors property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setNumOfPredictors(Double numOfPredictors) {
        this.numOfPredictors = numOfPredictors;
        return this;
    }

    /**
     * Gets the value of the degreesOfFreedom property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getDegreesOfFreedom() {
        return degreesOfFreedom;
    }

    /**
     * Sets the value of the degreesOfFreedom property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setDegreesOfFreedom(Double degreesOfFreedom) {
        this.degreesOfFreedom = degreesOfFreedom;
        return this;
    }

    /**
     * Gets the value of the fStatistic property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getFStatistic() {
        return fStatistic;
    }

    /**
     * Sets the value of the fStatistic property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setFStatistic(Double fStatistic) {
        this.fStatistic = fStatistic;
        return this;
    }

    /**
     * Gets the value of the aic property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getAIC() {
        return aic;
    }

    /**
     * Sets the value of the aic property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setAIC(Double aic) {
        this.aic = aic;
        return this;
    }

    /**
     * Gets the value of the bic property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getBIC() {
        return bic;
    }

    /**
     * Sets the value of the bic property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setBIC(Double bic) {
        this.bic = bic;
        return this;
    }

    /**
     * Gets the value of the aiCc property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getAICc() {
        return aiCc;
    }

    /**
     * Sets the value of the aiCc property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public PredictiveModelQuality setAICc(Double aiCc) {
        this.aiCc = aiCc;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the confusionMatrix property.
     * 
     * @return
     *     possible object is
     *     {@link ConfusionMatrix }
     *     
     */
    public ConfusionMatrix getConfusionMatrix() {
        return confusionMatrix;
    }

    /**
     * Sets the value of the confusionMatrix property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConfusionMatrix }
     *     
     */
    public PredictiveModelQuality setConfusionMatrix(ConfusionMatrix confusionMatrix) {
        this.confusionMatrix = confusionMatrix;
        return this;
    }

    /**
     * Gets the value of the liftData property.
     * 
     * @return
     *     possible object is
     *     {@link LiftData }
     *     
     */
    public LiftData getLiftData() {
        return liftData;
    }

    /**
     * Sets the value of the liftData property.
     * 
     * @param value
     *     allowed object is
     *     {@link LiftData }
     *     
     */
    public PredictiveModelQuality setLiftData(LiftData liftData) {
        this.liftData = liftData;
        return this;
    }

    /**
     * Gets the value of the roc property.
     * 
     * @return
     *     possible object is
     *     {@link ROC }
     *     
     */
    public ROC getROC() {
        return roc;
    }

    /**
     * Sets the value of the roc property.
     * 
     * @param value
     *     allowed object is
     *     {@link ROC }
     *     
     */
    public PredictiveModelQuality setROC(ROC roc) {
        this.roc = roc;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public PredictiveModelQuality addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
        }
        ConfusionMatrix confusionMatrix = getConfusionMatrix();
        if ((status == VisitorAction.CONTINUE)&&(confusionMatrix!= null)) {
            status = confusionMatrix.accept(visitor);
        }
        LiftData liftData = getLiftData();
        if ((status == VisitorAction.CONTINUE)&&(liftData!= null)) {
            status = liftData.accept(visitor);
        }
        ROC roc = getROC();
        if ((status == VisitorAction.CONTINUE)&&(roc!= null)) {
            status = roc.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
