
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelLiftGraph"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}OptimumLiftGraph" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}RandomLiftGraph" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="targetFieldValue" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="targetFieldDisplayValue" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="rankingQuality" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "modelLiftGraph",
    "optimumLiftGraph",
    "randomLiftGraph"
})
@XmlRootElement(name = "LiftData", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_0)
public class LiftData
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "targetFieldValue")
    private String targetFieldValue;
    @XmlAttribute(name = "targetFieldDisplayValue")
    private String targetFieldDisplayValue;
    @XmlAttribute(name = "rankingQuality")
    private Double rankingQuality;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "ModelLiftGraph", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private ModelLiftGraph modelLiftGraph;
    @XmlElement(name = "OptimumLiftGraph", namespace = "http://www.dmg.org/PMML-4_2")
    private OptimumLiftGraph optimumLiftGraph;
    @XmlElement(name = "RandomLiftGraph", namespace = "http://www.dmg.org/PMML-4_2")
    private RandomLiftGraph randomLiftGraph;

    public LiftData() {
        super();
    }

    public LiftData(final ModelLiftGraph modelLiftGraph) {
        super();
        this.modelLiftGraph = modelLiftGraph;
    }

    /**
     * Gets the value of the targetFieldValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetFieldValue() {
        return targetFieldValue;
    }

    /**
     * Sets the value of the targetFieldValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public LiftData setTargetFieldValue(String targetFieldValue) {
        this.targetFieldValue = targetFieldValue;
        return this;
    }

    /**
     * Gets the value of the targetFieldDisplayValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetFieldDisplayValue() {
        return targetFieldDisplayValue;
    }

    /**
     * Sets the value of the targetFieldDisplayValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public LiftData setTargetFieldDisplayValue(String targetFieldDisplayValue) {
        this.targetFieldDisplayValue = targetFieldDisplayValue;
        return this;
    }

    /**
     * Gets the value of the rankingQuality property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getRankingQuality() {
        return rankingQuality;
    }

    /**
     * Sets the value of the rankingQuality property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public LiftData setRankingQuality(Double rankingQuality) {
        this.rankingQuality = rankingQuality;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the modelLiftGraph property.
     * 
     * @return
     *     possible object is
     *     {@link ModelLiftGraph }
     *     
     */
    public ModelLiftGraph getModelLiftGraph() {
        return modelLiftGraph;
    }

    /**
     * Sets the value of the modelLiftGraph property.
     * 
     * @param value
     *     allowed object is
     *     {@link ModelLiftGraph }
     *     
     */
    public LiftData setModelLiftGraph(ModelLiftGraph modelLiftGraph) {
        this.modelLiftGraph = modelLiftGraph;
        return this;
    }

    /**
     * Gets the value of the optimumLiftGraph property.
     * 
     * @return
     *     possible object is
     *     {@link OptimumLiftGraph }
     *     
     */
    public OptimumLiftGraph getOptimumLiftGraph() {
        return optimumLiftGraph;
    }

    /**
     * Sets the value of the optimumLiftGraph property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptimumLiftGraph }
     *     
     */
    public LiftData setOptimumLiftGraph(OptimumLiftGraph optimumLiftGraph) {
        this.optimumLiftGraph = optimumLiftGraph;
        return this;
    }

    /**
     * Gets the value of the randomLiftGraph property.
     * 
     * @return
     *     possible object is
     *     {@link RandomLiftGraph }
     *     
     */
    public RandomLiftGraph getRandomLiftGraph() {
        return randomLiftGraph;
    }

    /**
     * Sets the value of the randomLiftGraph property.
     * 
     * @param value
     *     allowed object is
     *     {@link RandomLiftGraph }
     *     
     */
    public LiftData setRandomLiftGraph(RandomLiftGraph randomLiftGraph) {
        this.randomLiftGraph = randomLiftGraph;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public LiftData addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
        }
        ModelLiftGraph modelLiftGraph = getModelLiftGraph();
        if ((status == VisitorAction.CONTINUE)&&(modelLiftGraph!= null)) {
            status = modelLiftGraph.accept(visitor);
        }
        OptimumLiftGraph optimumLiftGraph = getOptimumLiftGraph();
        if ((status == VisitorAction.CONTINUE)&&(optimumLiftGraph!= null)) {
            status = optimumLiftGraph.accept(visitor);
        }
        RandomLiftGraph randomLiftGraph = getRandomLiftGraph();
        if ((status == VisitorAction.CONTINUE)&&(randomLiftGraph!= null)) {
            status = randomLiftGraph.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
