
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.DecimalAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="name" use="required" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="usageType" type="{http://www.dmg.org/PMML-4_2}FIELD-USAGE-TYPE" default="active" />
 *       &lt;attribute name="optype" type="{http://www.dmg.org/PMML-4_2}OPTYPE" />
 *       &lt;attribute name="importance" type="{http://www.dmg.org/PMML-4_2}PROB-NUMBER" />
 *       &lt;attribute name="outliers" type="{http://www.dmg.org/PMML-4_2}OUTLIER-TREATMENT-METHOD" default="asIs" />
 *       &lt;attribute name="lowValue" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="highValue" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="missingValueReplacement" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="missingValueTreatment" type="{http://www.dmg.org/PMML-4_2}MISSING-VALUE-TREATMENT-METHOD" />
 *       &lt;attribute name="invalidValueTreatment" type="{http://www.dmg.org/PMML-4_2}INVALID-VALUE-TREATMENT-METHOD" default="returnInvalid" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "MiningField", namespace = "http://www.dmg.org/PMML-4_2")
public class MiningField
    extends Field
    implements HasExtensions
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName name;
    @XmlAttribute(name = "usageType")
    private FieldUsageType usageType;
    @XmlAttribute(name = "optype")
    private OpType opType;
    @XmlAttribute(name = "importance")
    @XmlJavaTypeAdapter(DecimalAdapter.class)
    private Double importance;
    @XmlAttribute(name = "outliers")
    private OutlierTreatmentMethodType outlierTreatment;
    @XmlAttribute(name = "lowValue")
    private Double lowValue;
    @XmlAttribute(name = "highValue")
    private Double highValue;
    @XmlAttribute(name = "missingValueReplacement")
    private String missingValueReplacement;
    @XmlAttribute(name = "missingValueTreatment")
    private MissingValueTreatmentMethodType missingValueTreatment;
    @XmlAttribute(name = "invalidValueTreatment")
    @Added(Version.PMML_3_1)
    private InvalidValueTreatmentMethodType invalidValueTreatment;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;

    public MiningField() {
        super();
    }

    public MiningField(final FieldName name) {
        super();
        this.name = name;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public MiningField setName(FieldName name) {
        this.name = name;
        return this;
    }

    /**
     * Gets the value of the usageType property.
     * 
     * @return
     *     possible object is
     *     {@link FieldUsageType }
     *     
     */
    public FieldUsageType getUsageType() {
        if (usageType == null) {
            return FieldUsageType.ACTIVE;
        } else {
            return usageType;
        }
    }

    /**
     * Sets the value of the usageType property.
     * 
     * @param value
     *     allowed object is
     *     {@link FieldUsageType }
     *     
     */
    public MiningField setUsageType(FieldUsageType usageType) {
        this.usageType = usageType;
        return this;
    }

    /**
     * Gets the value of the opType property.
     * 
     * @return
     *     possible object is
     *     {@link OpType }
     *     
     */
    public OpType getOpType() {
        return opType;
    }

    /**
     * Sets the value of the opType property.
     * 
     * @param value
     *     allowed object is
     *     {@link OpType }
     *     
     */
    public MiningField setOpType(OpType opType) {
        this.opType = opType;
        return this;
    }

    /**
     * Gets the value of the importance property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Double getImportance() {
        return importance;
    }

    /**
     * Sets the value of the importance property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public MiningField setImportance(Double importance) {
        this.importance = importance;
        return this;
    }

    /**
     * Gets the value of the outlierTreatment property.
     * 
     * @return
     *     possible object is
     *     {@link OutlierTreatmentMethodType }
     *     
     */
    public OutlierTreatmentMethodType getOutlierTreatment() {
        if (outlierTreatment == null) {
            return OutlierTreatmentMethodType.AS_IS;
        } else {
            return outlierTreatment;
        }
    }

    /**
     * Sets the value of the outlierTreatment property.
     * 
     * @param value
     *     allowed object is
     *     {@link OutlierTreatmentMethodType }
     *     
     */
    public MiningField setOutlierTreatment(OutlierTreatmentMethodType outlierTreatment) {
        this.outlierTreatment = outlierTreatment;
        return this;
    }

    /**
     * Gets the value of the lowValue property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getLowValue() {
        return lowValue;
    }

    /**
     * Sets the value of the lowValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public MiningField setLowValue(Double lowValue) {
        this.lowValue = lowValue;
        return this;
    }

    /**
     * Gets the value of the highValue property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getHighValue() {
        return highValue;
    }

    /**
     * Sets the value of the highValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    public MiningField setHighValue(Double highValue) {
        this.highValue = highValue;
        return this;
    }

    /**
     * Gets the value of the missingValueReplacement property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMissingValueReplacement() {
        return missingValueReplacement;
    }

    /**
     * Sets the value of the missingValueReplacement property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public MiningField setMissingValueReplacement(String missingValueReplacement) {
        this.missingValueReplacement = missingValueReplacement;
        return this;
    }

    /**
     * Gets the value of the missingValueTreatment property.
     * 
     * @return
     *     possible object is
     *     {@link MissingValueTreatmentMethodType }
     *     
     */
    public MissingValueTreatmentMethodType getMissingValueTreatment() {
        return missingValueTreatment;
    }

    /**
     * Sets the value of the missingValueTreatment property.
     * 
     * @param value
     *     allowed object is
     *     {@link MissingValueTreatmentMethodType }
     *     
     */
    public MiningField setMissingValueTreatment(MissingValueTreatmentMethodType missingValueTreatment) {
        this.missingValueTreatment = missingValueTreatment;
        return this;
    }

    /**
     * Gets the value of the invalidValueTreatment property.
     * 
     * @return
     *     possible object is
     *     {@link InvalidValueTreatmentMethodType }
     *     
     */
    public InvalidValueTreatmentMethodType getInvalidValueTreatment() {
        if (invalidValueTreatment == null) {
            return InvalidValueTreatmentMethodType.RETURN_INVALID;
        } else {
            return invalidValueTreatment;
        }
    }

    /**
     * Sets the value of the invalidValueTreatment property.
     * 
     * @param value
     *     allowed object is
     *     {@link InvalidValueTreatmentMethodType }
     *     
     */
    public MiningField setInvalidValueTreatment(InvalidValueTreatmentMethodType invalidValueTreatment) {
        this.invalidValueTreatment = invalidValueTreatment;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public MiningField addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    /**
     * Gets the value of the displayName property.
     * 
     * @throws UnsupportedOperationException
     *     Always.
     */
    @Override
    public String getDisplayName() {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets the value of the displayName property.
     * 
     * @throws UnsupportedOperationException
     *     Always.
     */
    @Override
    public MiningField setDisplayName(String displayName) {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets the value of the dataType property.
     * 
     * @throws UnsupportedOperationException
     *     Always.
     */
    @Override
    public DataType getDataType() {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets the value of the dataType property.
     * 
     * @throws UnsupportedOperationException
     *     Always.
     */
    @Override
    public MiningField setDataType(DataType dataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = PMMLObject.traverse(visitor, getExtensions());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
