
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TrainingInstances"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ComparisonMeasure"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}KNNInputs"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_2}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="numberOfNeighbors" use="required" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="continuousScoringMethod" type="{http://www.dmg.org/PMML-4_2}CONT-SCORING-METHOD" default="average" />
 *       &lt;attribute name="categoricalScoringMethod" type="{http://www.dmg.org/PMML-4_2}CAT-SCORING-METHOD" default="majorityVote" />
 *       &lt;attribute name="instanceIdVariable" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="threshold" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="0.001" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "trainingInstances",
    "comparisonMeasure",
    "knnInputs",
    "modelVerification"
})
@XmlRootElement(name = "NearestNeighborModel", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_1)
public class NearestNeighborModel
    extends Model
    implements HasExtensions
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "numberOfNeighbors", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer numberOfNeighbors;
    @XmlAttribute(name = "continuousScoringMethod")
    private ContinuousScoringMethodType continuousScoringMethod;
    @XmlAttribute(name = "categoricalScoringMethod")
    private CategoricalScoringMethodType categoricalScoringMethod;
    @XmlAttribute(name = "instanceIdVariable")
    private String instanceIdVariable;
    @XmlAttribute(name = "threshold")
    private Double threshold;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_2")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_2")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name = "TrainingInstances", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private TrainingInstances trainingInstances;
    @XmlElement(name = "ComparisonMeasure", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private ComparisonMeasure comparisonMeasure;
    @XmlElement(name = "KNNInputs", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private KNNInputs knnInputs;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelVerification modelVerification;

    public NearestNeighborModel() {
        super();
    }

    public NearestNeighborModel(final MiningFunctionType functionName, final Integer numberOfNeighbors, final MiningSchema miningSchema, final TrainingInstances trainingInstances, final ComparisonMeasure comparisonMeasure, final KNNInputs knnInputs) {
        super();
        this.functionName = functionName;
        this.numberOfNeighbors = numberOfNeighbors;
        this.miningSchema = miningSchema;
        this.trainingInstances = trainingInstances;
        this.comparisonMeasure = comparisonMeasure;
        this.knnInputs = knnInputs;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public NearestNeighborModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param functionName
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public NearestNeighborModel setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public NearestNeighborModel setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the numberOfNeighbors property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfNeighbors() {
        return numberOfNeighbors;
    }

    /**
     * Sets the value of the numberOfNeighbors property.
     * 
     * @param numberOfNeighbors
     *     allowed object is
     *     {@link String }
     *     
     */
    public NearestNeighborModel setNumberOfNeighbors(Integer numberOfNeighbors) {
        this.numberOfNeighbors = numberOfNeighbors;
        return this;
    }

    /**
     * Gets the value of the continuousScoringMethod property.
     * 
     * @return
     *     possible object is
     *     {@link ContinuousScoringMethodType }
     *     
     */
    public ContinuousScoringMethodType getContinuousScoringMethod() {
        if (continuousScoringMethod == null) {
            return ContinuousScoringMethodType.AVERAGE;
        } else {
            return continuousScoringMethod;
        }
    }

    /**
     * Sets the value of the continuousScoringMethod property.
     * 
     * @param continuousScoringMethod
     *     allowed object is
     *     {@link ContinuousScoringMethodType }
     *     
     */
    public NearestNeighborModel setContinuousScoringMethod(ContinuousScoringMethodType continuousScoringMethod) {
        this.continuousScoringMethod = continuousScoringMethod;
        return this;
    }

    /**
     * Gets the value of the categoricalScoringMethod property.
     * 
     * @return
     *     possible object is
     *     {@link CategoricalScoringMethodType }
     *     
     */
    public CategoricalScoringMethodType getCategoricalScoringMethod() {
        if (categoricalScoringMethod == null) {
            return CategoricalScoringMethodType.MAJORITY_VOTE;
        } else {
            return categoricalScoringMethod;
        }
    }

    /**
     * Sets the value of the categoricalScoringMethod property.
     * 
     * @param categoricalScoringMethod
     *     allowed object is
     *     {@link CategoricalScoringMethodType }
     *     
     */
    public NearestNeighborModel setCategoricalScoringMethod(CategoricalScoringMethodType categoricalScoringMethod) {
        this.categoricalScoringMethod = categoricalScoringMethod;
        return this;
    }

    /**
     * Gets the value of the instanceIdVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInstanceIdVariable() {
        return instanceIdVariable;
    }

    /**
     * Sets the value of the instanceIdVariable property.
     * 
     * @param instanceIdVariable
     *     allowed object is
     *     {@link String }
     *     
     */
    public NearestNeighborModel setInstanceIdVariable(String instanceIdVariable) {
        this.instanceIdVariable = instanceIdVariable;
        return this;
    }

    /**
     * Gets the value of the threshold property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getThreshold() {
        if (threshold == null) {
            return  0.001D;
        } else {
            return threshold;
        }
    }

    /**
     * Sets the value of the threshold property.
     * 
     * @param threshold
     *     allowed object is
     *     {@link Double }
     *     
     */
    public NearestNeighborModel setThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param scorable
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public NearestNeighborModel setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param miningSchema
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public NearestNeighborModel setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param output
     *     allowed object is
     *     {@link Output }
     *     
     */
    public NearestNeighborModel setOutput(Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public NearestNeighborModel setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param modelExplanation
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public NearestNeighborModel setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param targets
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public NearestNeighborModel setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public NearestNeighborModel setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the trainingInstances property.
     * 
     * @return
     *     possible object is
     *     {@link TrainingInstances }
     *     
     */
    public TrainingInstances getTrainingInstances() {
        return trainingInstances;
    }

    /**
     * Sets the value of the trainingInstances property.
     * 
     * @param trainingInstances
     *     allowed object is
     *     {@link TrainingInstances }
     *     
     */
    public NearestNeighborModel setTrainingInstances(TrainingInstances trainingInstances) {
        this.trainingInstances = trainingInstances;
        return this;
    }

    /**
     * Gets the value of the comparisonMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link ComparisonMeasure }
     *     
     */
    public ComparisonMeasure getComparisonMeasure() {
        return comparisonMeasure;
    }

    /**
     * Sets the value of the comparisonMeasure property.
     * 
     * @param comparisonMeasure
     *     allowed object is
     *     {@link ComparisonMeasure }
     *     
     */
    public NearestNeighborModel setComparisonMeasure(ComparisonMeasure comparisonMeasure) {
        this.comparisonMeasure = comparisonMeasure;
        return this;
    }

    /**
     * Gets the value of the knnInputs property.
     * 
     * @return
     *     possible object is
     *     {@link KNNInputs }
     *     
     */
    public KNNInputs getKNNInputs() {
        return knnInputs;
    }

    /**
     * Sets the value of the knnInputs property.
     * 
     * @param knnInputs
     *     allowed object is
     *     {@link KNNInputs }
     *     
     */
    public NearestNeighborModel setKNNInputs(KNNInputs knnInputs) {
        this.knnInputs = knnInputs;
        return this;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param modelVerification
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public NearestNeighborModel setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NearestNeighborModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = PMMLObject.traverse(visitor, getExtensions());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getTrainingInstances(), getComparisonMeasure(), getKNNInputs(), getModelVerification());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
