
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}SupportVector" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="numberOfSupportVectors" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="numberOfAttributes" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "supportVectors"
})
@XmlRootElement(name = "SupportVectors", namespace = "http://www.dmg.org/PMML-4_2")
public class SupportVectors
    extends org.dmg.pmml.PMMLObject
    implements Iterable<SupportVector> , HasExtensions
{

    @XmlAttribute(name = "numberOfSupportVectors")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer numberOfSupportVectors;
    @XmlAttribute(name = "numberOfAttributes")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer numberOfAttributes;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "SupportVector", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private List<SupportVector> supportVectors;

    public SupportVectors() {
        super();
    }

    public SupportVectors(final List<SupportVector> supportVectors) {
        super();
        this.supportVectors = supportVectors;
    }

    /**
     * Gets the value of the numberOfSupportVectors property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfSupportVectors() {
        return numberOfSupportVectors;
    }

    /**
     * Sets the value of the numberOfSupportVectors property.
     * 
     * @param numberOfSupportVectors
     *     allowed object is
     *     {@link String }
     *     
     */
    public SupportVectors setNumberOfSupportVectors(Integer numberOfSupportVectors) {
        this.numberOfSupportVectors = numberOfSupportVectors;
        return this;
    }

    /**
     * Gets the value of the numberOfAttributes property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfAttributes() {
        return numberOfAttributes;
    }

    /**
     * Sets the value of the numberOfAttributes property.
     * 
     * @param numberOfAttributes
     *     allowed object is
     *     {@link String }
     *     
     */
    public SupportVectors setNumberOfAttributes(Integer numberOfAttributes) {
        this.numberOfAttributes = numberOfAttributes;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the supportVectors property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supportVectors property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupportVectors().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupportVector }
     * 
     * 
     */
    public List<SupportVector> getSupportVectors() {
        if (supportVectors == null) {
            supportVectors = new ArrayList<SupportVector>();
        }
        return this.supportVectors;
    }

    public Iterator<SupportVector> iterator() {
        return getSupportVectors().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public SupportVectors addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasSupportVectors() {
        return ((this.supportVectors!= null)&&(this.supportVectors.size()> 0));
    }

    public SupportVectors addSupportVectors(SupportVector... supportVectors) {
        getSupportVectors().addAll(Arrays.asList(supportVectors));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
        }
        if ((status == VisitorAction.CONTINUE)&&hasSupportVectors()) {
            status = org.dmg.pmml.PMMLObject.traverse(visitor, getSupportVectors());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
