
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_2}PREDICATE"/>
 *         &lt;choice>
 *           &lt;sequence>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_2}Partition" minOccurs="0"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_2}ScoreDistribution" maxOccurs="unbounded" minOccurs="0"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_2}Node" maxOccurs="unbounded" minOccurs="0"/>
 *           &lt;/sequence>
 *           &lt;group ref="{http://www.dmg.org/PMML-4_2}EmbeddedModel"/>
 *         &lt;/choice>
 *       &lt;/sequence>
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="score" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="recordCount" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="defaultChild" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "predicate",
    "partition",
    "scoreDistributions",
    "nodes",
    "embeddedModel"
})
@XmlRootElement(name = "Node", namespace = "http://www.dmg.org/PMML-4_2")
public class Node
    extends Entity
    implements HasExtensions, HasId
{

    @XmlAttribute(name = "id")
    private String id;
    @XmlAttribute(name = "score")
    private String score;
    @XmlAttribute(name = "recordCount")
    private Double recordCount;
    @XmlAttribute(name = "defaultChild")
    @Added(Version.PMML_3_1)
    private String defaultChild;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_2", type = SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_2", type = CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_2", type = SimpleSetPredicate.class),
        @XmlElement(name = "True", namespace = "http://www.dmg.org/PMML-4_2", type = True.class),
        @XmlElement(name = "False", namespace = "http://www.dmg.org/PMML-4_2", type = False.class)
    })
    private Predicate predicate;
    @XmlElement(name = "Partition", namespace = "http://www.dmg.org/PMML-4_2")
    private Partition partition;
    @XmlElement(name = "ScoreDistribution", namespace = "http://www.dmg.org/PMML-4_2")
    private List<ScoreDistribution> scoreDistributions;
    @XmlElement(name = "Node", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Node> nodes;
    @XmlElements({
        @XmlElement(name = "Regression", namespace = "http://www.dmg.org/PMML-4_2", type = Regression.class),
        @XmlElement(name = "DecisionTree", namespace = "http://www.dmg.org/PMML-4_2", type = DecisionTree.class)
    })
    private EmbeddedModel embeddedModel;

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param id
     *     allowed object is
     *     {@link String }
     *     
     */
    public Node setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Gets the value of the score property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getScore() {
        return score;
    }

    /**
     * Sets the value of the score property.
     * 
     * @param score
     *     allowed object is
     *     {@link String }
     *     
     */
    public Node setScore(String score) {
        this.score = score;
        return this;
    }

    /**
     * Gets the value of the recordCount property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getRecordCount() {
        return recordCount;
    }

    /**
     * Sets the value of the recordCount property.
     * 
     * @param recordCount
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Node setRecordCount(Double recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    /**
     * Gets the value of the defaultChild property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDefaultChild() {
        return defaultChild;
    }

    /**
     * Sets the value of the defaultChild property.
     * 
     * @param defaultChild
     *     allowed object is
     *     {@link String }
     *     
     */
    public Node setDefaultChild(String defaultChild) {
        this.defaultChild = defaultChild;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the predicate property.
     * 
     * @return
     *     possible object is
     *     {@link SimplePredicate }
     *     {@link CompoundPredicate }
     *     {@link SimpleSetPredicate }
     *     {@link True }
     *     {@link False }
     *     
     */
    public Predicate getPredicate() {
        return predicate;
    }

    /**
     * Sets the value of the predicate property.
     * 
     * @param predicate
     *     allowed object is
     *     {@link SimplePredicate }
     *     {@link CompoundPredicate }
     *     {@link SimpleSetPredicate }
     *     {@link True }
     *     {@link False }
     *     
     */
    public Node setPredicate(Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    /**
     * Gets the value of the partition property.
     * 
     * @return
     *     possible object is
     *     {@link Partition }
     *     
     */
    public Partition getPartition() {
        return partition;
    }

    /**
     * Sets the value of the partition property.
     * 
     * @param partition
     *     allowed object is
     *     {@link Partition }
     *     
     */
    public Node setPartition(Partition partition) {
        this.partition = partition;
        return this;
    }

    /**
     * Gets the value of the scoreDistributions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the scoreDistributions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getScoreDistributions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ScoreDistribution }
     * 
     * 
     */
    public List<ScoreDistribution> getScoreDistributions() {
        if (scoreDistributions == null) {
            scoreDistributions = new ArrayList<ScoreDistribution>();
        }
        return this.scoreDistributions;
    }

    /**
     * Gets the value of the nodes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the nodes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNodes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Node }
     * 
     * 
     */
    public List<Node> getNodes() {
        if (nodes == null) {
            nodes = new ArrayList<Node>();
        }
        return this.nodes;
    }

    /**
     * Gets the value of the embeddedModel property.
     * 
     * @return
     *     possible object is
     *     {@link Regression }
     *     {@link DecisionTree }
     *     
     */
    public EmbeddedModel getEmbeddedModel() {
        return embeddedModel;
    }

    /**
     * Sets the value of the embeddedModel property.
     * 
     * @param embeddedModel
     *     allowed object is
     *     {@link Regression }
     *     {@link DecisionTree }
     *     
     */
    public Node setEmbeddedModel(EmbeddedModel embeddedModel) {
        this.embeddedModel = embeddedModel;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Node addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasScoreDistributions() {
        return ((this.scoreDistributions!= null)&&(this.scoreDistributions.size()> 0));
    }

    public Node addScoreDistributions(ScoreDistribution... scoreDistributions) {
        getScoreDistributions().addAll(Arrays.asList(scoreDistributions));
        return this;
    }

    public boolean hasNodes() {
        return ((this.nodes!= null)&&(this.nodes.size()> 0));
    }

    public Node addNodes(Node... nodes) {
        getNodes().addAll(Arrays.asList(nodes));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = PMMLObject.traverse(visitor, getExtensions());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, getPredicate(), getPartition());
        }
        if ((status == VisitorAction.CONTINUE)&&hasScoreDistributions()) {
            status = PMMLObject.traverse(visitor, getScoreDistributions());
        }
        if ((status == VisitorAction.CONTINUE)&&hasNodes()) {
            status = PMMLObject.traverse(visitor, getNodes());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, getEmbeddedModel());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
