
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Deprecated;
import org.jpmml.schema.Optional;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;sequence minOccurs="0">
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}Decisions" minOccurs="0"/>
 *           &lt;group ref="{http://www.dmg.org/PMML-4_2}EXPRESSION"/>
 *         &lt;/sequence>
 *       &lt;/sequence>
 *       &lt;attribute name="name" use="required" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="displayName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="optype" type="{http://www.dmg.org/PMML-4_2}OPTYPE" />
 *       &lt;attribute name="dataType" type="{http://www.dmg.org/PMML-4_2}DATATYPE" />
 *       &lt;attribute name="targetField" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="feature" type="{http://www.dmg.org/PMML-4_2}RESULT-FEATURE" default="predictedValue" />
 *       &lt;attribute name="value" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="ruleFeature" type="{http://www.dmg.org/PMML-4_2}RULE-FEATURE" default="consequent" />
 *       &lt;attribute name="algorithm" default="exclusiveRecommendation">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="recommendation"/>
 *             &lt;enumeration value="exclusiveRecommendation"/>
 *             &lt;enumeration value="ruleAssociation"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="rank" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" default="1" />
 *       &lt;attribute name="rankBasis" default="confidence">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="confidence"/>
 *             &lt;enumeration value="support"/>
 *             &lt;enumeration value="lift"/>
 *             &lt;enumeration value="leverage"/>
 *             &lt;enumeration value="affinity"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="rankOrder" default="descending">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="descending"/>
 *             &lt;enumeration value="ascending"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="isMultiValued" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" default="0" />
 *       &lt;attribute name="segmentId" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "decisions",
    "expression"
})
@XmlRootElement(name = "OutputField", namespace = "http://www.dmg.org/PMML-4_2")
public class OutputField
    extends Field
    implements HasExpression, HasExtensions
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName name;
    @XmlAttribute(name = "displayName")
    private String displayName;
    @XmlAttribute(name = "optype")
    private OpType opType;
    @XmlAttribute(name = "dataType")
    private DataType dataType;
    @XmlAttribute(name = "targetField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Optional(Version.PMML_3_1)
    private FieldName targetField;
    @XmlAttribute(name = "feature")
    private FeatureType feature;
    @XmlAttribute(name = "value")
    private String value;
    @XmlAttribute(name = "ruleFeature")
    @Added(Version.PMML_4_0)
    @Deprecated(Version.PMML_4_2)
    private RuleFeatureType ruleFeature;
    @XmlAttribute(name = "algorithm")
    @Added(Version.PMML_4_0)
    private OutputField.Algorithm algorithm;
    @XmlAttribute(name = "rank")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer rank;
    @XmlAttribute(name = "rankBasis")
    @Added(Version.PMML_4_0)
    private OutputField.RankBasis rankBasis;
    @XmlAttribute(name = "rankOrder")
    @Added(Version.PMML_4_0)
    private OutputField.RankOrder rankOrder;
    @XmlAttribute(name = "isMultiValued")
    @XmlSchemaType(name = "anySimpleType")
    @Added(Version.PMML_4_0)
    @Deprecated(Version.PMML_4_2)
    private String isMultiValued;
    @XmlAttribute(name = "segmentId")
    @Added(Version.PMML_4_1)
    private String segmentId;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "Decisions", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_4_1)
    private Decisions decisions;
    @XmlElements({
        @XmlElement(name = "Constant", namespace = "http://www.dmg.org/PMML-4_2", type = Constant.class),
        @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_2", type = FieldRef.class),
        @XmlElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_2", type = NormContinuous.class),
        @XmlElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_2", type = NormDiscrete.class),
        @XmlElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_2", type = Discretize.class),
        @XmlElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_2", type = MapValues.class),
        @XmlElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_2", type = TextIndex.class),
        @XmlElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_2", type = Apply.class),
        @XmlElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_2", type = Aggregate.class)
    })
    @Added(Version.PMML_4_1)
    private Expression expression;

    public OutputField() {
        super();
    }

    public OutputField(final FieldName name) {
        super();
        this.name = name;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param name
     *     allowed object is
     *     {@link String }
     *     
     */
    public OutputField setName(FieldName name) {
        this.name = name;
        return this;
    }

    /**
     * Gets the value of the displayName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * Sets the value of the displayName property.
     * 
     * @param displayName
     *     allowed object is
     *     {@link String }
     *     
     */
    public OutputField setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Gets the value of the opType property.
     * 
     * @return
     *     possible object is
     *     {@link OpType }
     *     
     */
    public OpType getOpType() {
        return opType;
    }

    /**
     * Sets the value of the opType property.
     * 
     * @param opType
     *     allowed object is
     *     {@link OpType }
     *     
     */
    public OutputField setOpType(OpType opType) {
        this.opType = opType;
        return this;
    }

    /**
     * Gets the value of the dataType property.
     * 
     * @return
     *     possible object is
     *     {@link DataType }
     *     
     */
    public DataType getDataType() {
        return dataType;
    }

    /**
     * Sets the value of the dataType property.
     * 
     * @param dataType
     *     allowed object is
     *     {@link DataType }
     *     
     */
    public OutputField setDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    /**
     * Gets the value of the targetField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getTargetField() {
        return targetField;
    }

    /**
     * Sets the value of the targetField property.
     * 
     * @param targetField
     *     allowed object is
     *     {@link String }
     *     
     */
    public OutputField setTargetField(FieldName targetField) {
        this.targetField = targetField;
        return this;
    }

    /**
     * Gets the value of the feature property.
     * 
     * @return
     *     possible object is
     *     {@link FeatureType }
     *     
     */
    public FeatureType getFeature() {
        if (feature == null) {
            return FeatureType.PREDICTED_VALUE;
        } else {
            return feature;
        }
    }

    /**
     * Sets the value of the feature property.
     * 
     * @param feature
     *     allowed object is
     *     {@link FeatureType }
     *     
     */
    public OutputField setFeature(FeatureType feature) {
        this.feature = feature;
        return this;
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public OutputField setValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Gets the value of the ruleFeature property.
     * 
     * @return
     *     possible object is
     *     {@link RuleFeatureType }
     *     
     */
    public RuleFeatureType getRuleFeature() {
        if (ruleFeature == null) {
            return RuleFeatureType.CONSEQUENT;
        } else {
            return ruleFeature;
        }
    }

    /**
     * Sets the value of the ruleFeature property.
     * 
     * @param ruleFeature
     *     allowed object is
     *     {@link RuleFeatureType }
     *     
     */
    public OutputField setRuleFeature(RuleFeatureType ruleFeature) {
        this.ruleFeature = ruleFeature;
        return this;
    }

    /**
     * Gets the value of the algorithm property.
     * 
     * @return
     *     possible object is
     *     {@link OutputField.Algorithm }
     *     
     */
    public OutputField.Algorithm getAlgorithm() {
        if (algorithm == null) {
            return OutputField.Algorithm.EXCLUSIVE_RECOMMENDATION;
        } else {
            return algorithm;
        }
    }

    /**
     * Sets the value of the algorithm property.
     * 
     * @param algorithm
     *     allowed object is
     *     {@link OutputField.Algorithm }
     *     
     */
    public OutputField setAlgorithm(OutputField.Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    /**
     * Gets the value of the rank property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getRank() {
        if (rank == null) {
            return new IntegerAdapter().unmarshal("1");
        } else {
            return rank;
        }
    }

    /**
     * Sets the value of the rank property.
     * 
     * @param rank
     *     allowed object is
     *     {@link String }
     *     
     */
    public OutputField setRank(Integer rank) {
        this.rank = rank;
        return this;
    }

    /**
     * Gets the value of the rankBasis property.
     * 
     * @return
     *     possible object is
     *     {@link OutputField.RankBasis }
     *     
     */
    public OutputField.RankBasis getRankBasis() {
        if (rankBasis == null) {
            return OutputField.RankBasis.CONFIDENCE;
        } else {
            return rankBasis;
        }
    }

    /**
     * Sets the value of the rankBasis property.
     * 
     * @param rankBasis
     *     allowed object is
     *     {@link OutputField.RankBasis }
     *     
     */
    public OutputField setRankBasis(OutputField.RankBasis rankBasis) {
        this.rankBasis = rankBasis;
        return this;
    }

    /**
     * Gets the value of the rankOrder property.
     * 
     * @return
     *     possible object is
     *     {@link OutputField.RankOrder }
     *     
     */
    public OutputField.RankOrder getRankOrder() {
        if (rankOrder == null) {
            return OutputField.RankOrder.DESCENDING;
        } else {
            return rankOrder;
        }
    }

    /**
     * Sets the value of the rankOrder property.
     * 
     * @param rankOrder
     *     allowed object is
     *     {@link OutputField.RankOrder }
     *     
     */
    public OutputField setRankOrder(OutputField.RankOrder rankOrder) {
        this.rankOrder = rankOrder;
        return this;
    }

    /**
     * Gets the value of the isMultiValued property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIsMultiValued() {
        if (isMultiValued == null) {
            return "0";
        } else {
            return isMultiValued;
        }
    }

    /**
     * Sets the value of the isMultiValued property.
     * 
     * @param isMultiValued
     *     allowed object is
     *     {@link String }
     *     
     */
    public OutputField setIsMultiValued(String isMultiValued) {
        this.isMultiValued = isMultiValued;
        return this;
    }

    /**
     * Gets the value of the segmentId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSegmentId() {
        return segmentId;
    }

    /**
     * Sets the value of the segmentId property.
     * 
     * @param segmentId
     *     allowed object is
     *     {@link String }
     *     
     */
    public OutputField setSegmentId(String segmentId) {
        this.segmentId = segmentId;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the decisions property.
     * 
     * @return
     *     possible object is
     *     {@link Decisions }
     *     
     */
    public Decisions getDecisions() {
        return decisions;
    }

    /**
     * Sets the value of the decisions property.
     * 
     * @param decisions
     *     allowed object is
     *     {@link Decisions }
     *     
     */
    public OutputField setDecisions(Decisions decisions) {
        this.decisions = decisions;
        return this;
    }

    /**
     * Gets the value of the expression property.
     * 
     * @return
     *     possible object is
     *     {@link Constant }
     *     {@link FieldRef }
     *     {@link NormContinuous }
     *     {@link NormDiscrete }
     *     {@link Discretize }
     *     {@link MapValues }
     *     {@link TextIndex }
     *     {@link Apply }
     *     {@link Aggregate }
     *     
     */
    public Expression getExpression() {
        return expression;
    }

    /**
     * Sets the value of the expression property.
     * 
     * @param expression
     *     allowed object is
     *     {@link Constant }
     *     {@link FieldRef }
     *     {@link NormContinuous }
     *     {@link NormDiscrete }
     *     {@link Discretize }
     *     {@link MapValues }
     *     {@link TextIndex }
     *     {@link Apply }
     *     {@link Aggregate }
     *     
     */
    public OutputField setExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public OutputField addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getDecisions(), getExpression());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="recommendation"/>
     *     &lt;enumeration value="exclusiveRecommendation"/>
     *     &lt;enumeration value="ruleAssociation"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_0)
    public enum Algorithm {

        @XmlEnumValue("recommendation")
        RECOMMENDATION("recommendation"),
        @XmlEnumValue("exclusiveRecommendation")
        EXCLUSIVE_RECOMMENDATION("exclusiveRecommendation"),
        @XmlEnumValue("ruleAssociation")
        RULE_ASSOCIATION("ruleAssociation");
        private final String value;

        Algorithm(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static OutputField.Algorithm fromValue(String v) {
            for (OutputField.Algorithm c: OutputField.Algorithm.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="confidence"/>
     *     &lt;enumeration value="support"/>
     *     &lt;enumeration value="lift"/>
     *     &lt;enumeration value="leverage"/>
     *     &lt;enumeration value="affinity"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_0)
    public enum RankBasis {

        @XmlEnumValue("confidence")
        CONFIDENCE("confidence"),
        @XmlEnumValue("support")
        SUPPORT("support"),
        @XmlEnumValue("lift")
        LIFT("lift"),
        @XmlEnumValue("leverage")
        @Added(Version.PMML_4_1)
        LEVERAGE("leverage"),
        @XmlEnumValue("affinity")
        @Added(Version.PMML_4_1)
        AFFINITY("affinity");
        private final String value;

        RankBasis(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static OutputField.RankBasis fromValue(String v) {
            for (OutputField.RankBasis c: OutputField.RankBasis.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="descending"/>
     *     &lt;enumeration value="ascending"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_0)
    public enum RankOrder {

        @XmlEnumValue("descending")
        DESCENDING("descending"),
        @XmlEnumValue("ascending")
        ASCENDING("ascending");
        private final String value;

        RankOrder(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static OutputField.RankOrder fromValue(String v) {
            for (OutputField.RankOrder c: OutputField.RankOrder.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
