
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Coefficient" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="numberOfCoefficients" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="absoluteValue" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="0" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "coefficients"
})
@XmlRootElement(name = "Coefficients", namespace = "http://www.dmg.org/PMML-4_2")
public class Coefficients
    extends org.dmg.pmml.PMMLObject
    implements Iterable<Coefficient> , HasExtensions
{

    @XmlAttribute(name = "numberOfCoefficients")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer numberOfCoefficients;
    @XmlAttribute(name = "absoluteValue")
    private Double absoluteValue;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "Coefficient", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private List<Coefficient> coefficients;
    private final static Double DEFAULT_ABSOLUTE_VALUE = 0.0D;

    public Coefficients() {
        super();
    }

    public Coefficients(final List<Coefficient> coefficients) {
        super();
        this.coefficients = coefficients;
    }

    /**
     * Gets the value of the numberOfCoefficients property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfCoefficients() {
        return numberOfCoefficients;
    }

    /**
     * Sets the value of the numberOfCoefficients property.
     * 
     * @param numberOfCoefficients
     *     allowed object is
     *     {@link String }
     *     
     */
    public Coefficients setNumberOfCoefficients(Integer numberOfCoefficients) {
        this.numberOfCoefficients = numberOfCoefficients;
        return this;
    }

    /**
     * Gets the value of the absoluteValue property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getAbsoluteValue() {
        if (absoluteValue == null) {
            return DEFAULT_ABSOLUTE_VALUE;
        } else {
            return absoluteValue;
        }
    }

    /**
     * Sets the value of the absoluteValue property.
     * 
     * @param absoluteValue
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Coefficients setAbsoluteValue(Double absoluteValue) {
        this.absoluteValue = absoluteValue;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the coefficients property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the coefficients property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCoefficients().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Coefficient }
     * 
     * 
     */
    public List<Coefficient> getCoefficients() {
        if (coefficients == null) {
            coefficients = new ArrayList<Coefficient>();
        }
        return this.coefficients;
    }

    public Iterator<Coefficient> iterator() {
        return getCoefficients().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Coefficients addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasCoefficients() {
        return ((this.coefficients!= null)&&(this.coefficients.size()> 0));
    }

    public Coefficients addCoefficients(Coefficient... coefficients) {
        getCoefficients().addAll(Arrays.asList(coefficients));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasCoefficients()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCoefficients());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
