
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="totalFreq" use="required" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="missingFreq" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="invalidFreq" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="cardinality" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Counts", namespace = "http://www.dmg.org/PMML-4_2")
public class Counts
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "totalFreq", required = true)
    private double totalFreq;
    @XmlAttribute(name = "missingFreq")
    private Double missingFreq;
    @XmlAttribute(name = "invalidFreq")
    private Double invalidFreq;
    @XmlAttribute(name = "cardinality")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @Added(Version.PMML_4_0)
    private Integer cardinality;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;

    public Counts() {
        super();
    }

    public Counts(final double totalFreq) {
        super();
        this.totalFreq = totalFreq;
    }

    /**
     * Gets the value of the totalFreq property.
     * 
     */
    public double getTotalFreq() {
        return totalFreq;
    }

    /**
     * Sets the value of the totalFreq property.
     * 
     */
    public Counts setTotalFreq(double totalFreq) {
        this.totalFreq = totalFreq;
        return this;
    }

    /**
     * Gets the value of the missingFreq property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMissingFreq() {
        return missingFreq;
    }

    /**
     * Sets the value of the missingFreq property.
     * 
     * @param missingFreq
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Counts setMissingFreq(Double missingFreq) {
        this.missingFreq = missingFreq;
        return this;
    }

    /**
     * Gets the value of the invalidFreq property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getInvalidFreq() {
        return invalidFreq;
    }

    /**
     * Sets the value of the invalidFreq property.
     * 
     * @param invalidFreq
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Counts setInvalidFreq(Double invalidFreq) {
        this.invalidFreq = invalidFreq;
        return this;
    }

    /**
     * Gets the value of the cardinality property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getCardinality() {
        return cardinality;
    }

    /**
     * Sets the value of the cardinality property.
     * 
     * @param cardinality
     *     allowed object is
     *     {@link String }
     *     
     */
    public Counts setCardinality(Integer cardinality) {
        this.cardinality = cardinality;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Counts addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
