
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Deprecated;
import org.jpmml.schema.Required;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ParameterList"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}FactorList" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}CovariateList" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}PPMatrix"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}PCovMatrix" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ParamMatrix"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}EventValues" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}BaseCumHazardTables" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="targetVariableName" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="modelType" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="regression"/>
 *             &lt;enumeration value="generalLinear"/>
 *             &lt;enumeration value="multinomialLogistic"/>
 *             &lt;enumeration value="ordinalMultinomial"/>
 *             &lt;enumeration value="generalizedLinear"/>
 *             &lt;enumeration value="CoxRegression"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_2}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="targetReferenceCategory" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="cumulativeLink" type="{http://www.dmg.org/PMML-4_2}CUMULATIVE-LINK-FUNCTION" />
 *       &lt;attribute name="linkFunction" type="{http://www.dmg.org/PMML-4_2}LINK-FUNCTION" />
 *       &lt;attribute name="linkParameter" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="trialsVariable" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="trialsValue" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="distribution">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="binomial"/>
 *             &lt;enumeration value="gamma"/>
 *             &lt;enumeration value="igauss"/>
 *             &lt;enumeration value="negbin"/>
 *             &lt;enumeration value="normal"/>
 *             &lt;enumeration value="poisson"/>
 *             &lt;enumeration value="tweedie"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="distParameter" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="offsetVariable" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="offsetValue" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="modelDF" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="endTimeVariable" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="startTimeVariable" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="subjectIDVariable" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="statusVariable" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="baselineStrataVariable" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "parameterList",
    "factorList",
    "covariateList",
    "ppMatrix",
    "pCovMatrix",
    "paramMatrix",
    "eventValues",
    "baseCumHazardTables",
    "modelVerification"
})
@XmlRootElement(name = "GeneralRegressionModel", namespace = "http://www.dmg.org/PMML-4_2")
public class GeneralRegressionModel
    extends Model
    implements HasExtensions
{

    @XmlAttribute(name = "targetVariableName")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Deprecated(Version.PMML_3_0)
    private FieldName targetVariableName;
    @XmlAttribute(name = "modelType", required = true)
    private GeneralRegressionModel.ModelType modelType;
    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "targetReferenceCategory")
    @Added(Version.PMML_4_0)
    private String targetReferenceCategory;
    @XmlAttribute(name = "cumulativeLink")
    @Added(Version.PMML_3_1)
    private CumulativeLinkFunctionType cumulativeLinkFunction;
    @XmlAttribute(name = "linkFunction")
    @Added(Version.PMML_3_2)
    private LinkFunctionType linkFunction;
    @XmlAttribute(name = "linkParameter")
    @Added(Version.PMML_3_2)
    private Double linkParameter;
    @XmlAttribute(name = "trialsVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Added(Version.PMML_3_2)
    private FieldName trialsVariable;
    @XmlAttribute(name = "trialsValue")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @Added(Version.PMML_3_2)
    private Integer trialsValue;
    @XmlAttribute(name = "distribution")
    @Added(Version.PMML_3_2)
    private GeneralRegressionModel.Distribution distribution;
    @XmlAttribute(name = "distParameter")
    @Added(Version.PMML_3_2)
    private Double distParameter;
    @XmlAttribute(name = "offsetVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Added(Version.PMML_3_2)
    private FieldName offsetVariable;
    @XmlAttribute(name = "offsetValue")
    @Added(Version.PMML_3_2)
    private Double offsetValue;
    @XmlAttribute(name = "modelDF")
    @Added(Version.PMML_4_0)
    private Double modelDF;
    @XmlAttribute(name = "endTimeVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Added(Version.PMML_4_0)
    private FieldName endTimeVariable;
    @XmlAttribute(name = "startTimeVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Added(Version.PMML_4_0)
    private FieldName startTimeVariable;
    @XmlAttribute(name = "subjectIDVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Added(Version.PMML_4_0)
    private FieldName subjectIDVariable;
    @XmlAttribute(name = "statusVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Added(Version.PMML_4_0)
    private FieldName statusVariable;
    @XmlAttribute(name = "baselineStrataVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Added(Version.PMML_4_0)
    private FieldName baselineStrataVariable;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_2")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_4_0)
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_2")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name = "ParameterList", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private ParameterList parameterList;
    @XmlElement(name = "FactorList", namespace = "http://www.dmg.org/PMML-4_2")
    private FactorList factorList;
    @XmlElement(name = "CovariateList", namespace = "http://www.dmg.org/PMML-4_2")
    private CovariateList covariateList;
    @XmlElement(name = "PPMatrix", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    @Required(Version.PMML_3_1)
    private PPMatrix ppMatrix;
    @XmlElement(name = "PCovMatrix", namespace = "http://www.dmg.org/PMML-4_2")
    private PCovMatrix pCovMatrix;
    @XmlElement(name = "ParamMatrix", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private ParamMatrix paramMatrix;
    @XmlElement(name = "EventValues", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_4_0)
    private EventValues eventValues;
    @XmlElement(name = "BaseCumHazardTables", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_4_0)
    private BaseCumHazardTables baseCumHazardTables;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;

    public GeneralRegressionModel() {
        super();
    }

    public GeneralRegressionModel(final GeneralRegressionModel.ModelType modelType, final MiningFunctionType functionName, final MiningSchema miningSchema, final ParameterList parameterList, final PPMatrix ppMatrix, final ParamMatrix paramMatrix) {
        super();
        this.modelType = modelType;
        this.functionName = functionName;
        this.miningSchema = miningSchema;
        this.parameterList = parameterList;
        this.ppMatrix = ppMatrix;
        this.paramMatrix = paramMatrix;
    }

    /**
     * Gets the value of the targetVariableName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getTargetVariableName() {
        return targetVariableName;
    }

    /**
     * Sets the value of the targetVariableName property.
     * 
     * @param targetVariableName
     *     allowed object is
     *     {@link String }
     *     
     */
    public GeneralRegressionModel setTargetVariableName(FieldName targetVariableName) {
        this.targetVariableName = targetVariableName;
        return this;
    }

    /**
     * Gets the value of the modelType property.
     * 
     * @return
     *     possible object is
     *     {@link GeneralRegressionModel.ModelType }
     *     
     */
    public GeneralRegressionModel.ModelType getModelType() {
        return modelType;
    }

    /**
     * Sets the value of the modelType property.
     * 
     * @param modelType
     *     allowed object is
     *     {@link GeneralRegressionModel.ModelType }
     *     
     */
    public GeneralRegressionModel setModelType(GeneralRegressionModel.ModelType modelType) {
        this.modelType = modelType;
        return this;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public GeneralRegressionModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param functionName
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public GeneralRegressionModel setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public GeneralRegressionModel setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the targetReferenceCategory property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetReferenceCategory() {
        return targetReferenceCategory;
    }

    /**
     * Sets the value of the targetReferenceCategory property.
     * 
     * @param targetReferenceCategory
     *     allowed object is
     *     {@link String }
     *     
     */
    public GeneralRegressionModel setTargetReferenceCategory(String targetReferenceCategory) {
        this.targetReferenceCategory = targetReferenceCategory;
        return this;
    }

    /**
     * Gets the value of the cumulativeLinkFunction property.
     * 
     * @return
     *     possible object is
     *     {@link CumulativeLinkFunctionType }
     *     
     */
    public CumulativeLinkFunctionType getCumulativeLinkFunction() {
        return cumulativeLinkFunction;
    }

    /**
     * Sets the value of the cumulativeLinkFunction property.
     * 
     * @param cumulativeLinkFunction
     *     allowed object is
     *     {@link CumulativeLinkFunctionType }
     *     
     */
    public GeneralRegressionModel setCumulativeLinkFunction(CumulativeLinkFunctionType cumulativeLinkFunction) {
        this.cumulativeLinkFunction = cumulativeLinkFunction;
        return this;
    }

    /**
     * Gets the value of the linkFunction property.
     * 
     * @return
     *     possible object is
     *     {@link LinkFunctionType }
     *     
     */
    public LinkFunctionType getLinkFunction() {
        return linkFunction;
    }

    /**
     * Sets the value of the linkFunction property.
     * 
     * @param linkFunction
     *     allowed object is
     *     {@link LinkFunctionType }
     *     
     */
    public GeneralRegressionModel setLinkFunction(LinkFunctionType linkFunction) {
        this.linkFunction = linkFunction;
        return this;
    }

    /**
     * Gets the value of the linkParameter property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getLinkParameter() {
        return linkParameter;
    }

    /**
     * Sets the value of the linkParameter property.
     * 
     * @param linkParameter
     *     allowed object is
     *     {@link Double }
     *     
     */
    public GeneralRegressionModel setLinkParameter(Double linkParameter) {
        this.linkParameter = linkParameter;
        return this;
    }

    /**
     * Gets the value of the trialsVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getTrialsVariable() {
        return trialsVariable;
    }

    /**
     * Sets the value of the trialsVariable property.
     * 
     * @param trialsVariable
     *     allowed object is
     *     {@link String }
     *     
     */
    public GeneralRegressionModel setTrialsVariable(FieldName trialsVariable) {
        this.trialsVariable = trialsVariable;
        return this;
    }

    /**
     * Gets the value of the trialsValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getTrialsValue() {
        return trialsValue;
    }

    /**
     * Sets the value of the trialsValue property.
     * 
     * @param trialsValue
     *     allowed object is
     *     {@link String }
     *     
     */
    public GeneralRegressionModel setTrialsValue(Integer trialsValue) {
        this.trialsValue = trialsValue;
        return this;
    }

    /**
     * Gets the value of the distribution property.
     * 
     * @return
     *     possible object is
     *     {@link GeneralRegressionModel.Distribution }
     *     
     */
    public GeneralRegressionModel.Distribution getDistribution() {
        return distribution;
    }

    /**
     * Sets the value of the distribution property.
     * 
     * @param distribution
     *     allowed object is
     *     {@link GeneralRegressionModel.Distribution }
     *     
     */
    public GeneralRegressionModel setDistribution(GeneralRegressionModel.Distribution distribution) {
        this.distribution = distribution;
        return this;
    }

    /**
     * Gets the value of the distParameter property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getDistParameter() {
        return distParameter;
    }

    /**
     * Sets the value of the distParameter property.
     * 
     * @param distParameter
     *     allowed object is
     *     {@link Double }
     *     
     */
    public GeneralRegressionModel setDistParameter(Double distParameter) {
        this.distParameter = distParameter;
        return this;
    }

    /**
     * Gets the value of the offsetVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getOffsetVariable() {
        return offsetVariable;
    }

    /**
     * Sets the value of the offsetVariable property.
     * 
     * @param offsetVariable
     *     allowed object is
     *     {@link String }
     *     
     */
    public GeneralRegressionModel setOffsetVariable(FieldName offsetVariable) {
        this.offsetVariable = offsetVariable;
        return this;
    }

    /**
     * Gets the value of the offsetValue property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getOffsetValue() {
        return offsetValue;
    }

    /**
     * Sets the value of the offsetValue property.
     * 
     * @param offsetValue
     *     allowed object is
     *     {@link Double }
     *     
     */
    public GeneralRegressionModel setOffsetValue(Double offsetValue) {
        this.offsetValue = offsetValue;
        return this;
    }

    /**
     * Gets the value of the modelDF property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getModelDF() {
        return modelDF;
    }

    /**
     * Sets the value of the modelDF property.
     * 
     * @param modelDF
     *     allowed object is
     *     {@link Double }
     *     
     */
    public GeneralRegressionModel setModelDF(Double modelDF) {
        this.modelDF = modelDF;
        return this;
    }

    /**
     * Gets the value of the endTimeVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getEndTimeVariable() {
        return endTimeVariable;
    }

    /**
     * Sets the value of the endTimeVariable property.
     * 
     * @param endTimeVariable
     *     allowed object is
     *     {@link String }
     *     
     */
    public GeneralRegressionModel setEndTimeVariable(FieldName endTimeVariable) {
        this.endTimeVariable = endTimeVariable;
        return this;
    }

    /**
     * Gets the value of the startTimeVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getStartTimeVariable() {
        return startTimeVariable;
    }

    /**
     * Sets the value of the startTimeVariable property.
     * 
     * @param startTimeVariable
     *     allowed object is
     *     {@link String }
     *     
     */
    public GeneralRegressionModel setStartTimeVariable(FieldName startTimeVariable) {
        this.startTimeVariable = startTimeVariable;
        return this;
    }

    /**
     * Gets the value of the subjectIDVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getSubjectIDVariable() {
        return subjectIDVariable;
    }

    /**
     * Sets the value of the subjectIDVariable property.
     * 
     * @param subjectIDVariable
     *     allowed object is
     *     {@link String }
     *     
     */
    public GeneralRegressionModel setSubjectIDVariable(FieldName subjectIDVariable) {
        this.subjectIDVariable = subjectIDVariable;
        return this;
    }

    /**
     * Gets the value of the statusVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getStatusVariable() {
        return statusVariable;
    }

    /**
     * Sets the value of the statusVariable property.
     * 
     * @param statusVariable
     *     allowed object is
     *     {@link String }
     *     
     */
    public GeneralRegressionModel setStatusVariable(FieldName statusVariable) {
        this.statusVariable = statusVariable;
        return this;
    }

    /**
     * Gets the value of the baselineStrataVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getBaselineStrataVariable() {
        return baselineStrataVariable;
    }

    /**
     * Sets the value of the baselineStrataVariable property.
     * 
     * @param baselineStrataVariable
     *     allowed object is
     *     {@link String }
     *     
     */
    public GeneralRegressionModel setBaselineStrataVariable(FieldName baselineStrataVariable) {
        this.baselineStrataVariable = baselineStrataVariable;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param scorable
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public GeneralRegressionModel setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param miningSchema
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public GeneralRegressionModel setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param output
     *     allowed object is
     *     {@link Output }
     *     
     */
    public GeneralRegressionModel setOutput(Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public GeneralRegressionModel setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param modelExplanation
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public GeneralRegressionModel setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param targets
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public GeneralRegressionModel setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public GeneralRegressionModel setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the parameterList property.
     * 
     * @return
     *     possible object is
     *     {@link ParameterList }
     *     
     */
    public ParameterList getParameterList() {
        return parameterList;
    }

    /**
     * Sets the value of the parameterList property.
     * 
     * @param parameterList
     *     allowed object is
     *     {@link ParameterList }
     *     
     */
    public GeneralRegressionModel setParameterList(ParameterList parameterList) {
        this.parameterList = parameterList;
        return this;
    }

    /**
     * Gets the value of the factorList property.
     * 
     * @return
     *     possible object is
     *     {@link FactorList }
     *     
     */
    public FactorList getFactorList() {
        return factorList;
    }

    /**
     * Sets the value of the factorList property.
     * 
     * @param factorList
     *     allowed object is
     *     {@link FactorList }
     *     
     */
    public GeneralRegressionModel setFactorList(FactorList factorList) {
        this.factorList = factorList;
        return this;
    }

    /**
     * Gets the value of the covariateList property.
     * 
     * @return
     *     possible object is
     *     {@link CovariateList }
     *     
     */
    public CovariateList getCovariateList() {
        return covariateList;
    }

    /**
     * Sets the value of the covariateList property.
     * 
     * @param covariateList
     *     allowed object is
     *     {@link CovariateList }
     *     
     */
    public GeneralRegressionModel setCovariateList(CovariateList covariateList) {
        this.covariateList = covariateList;
        return this;
    }

    /**
     * Gets the value of the ppMatrix property.
     * 
     * @return
     *     possible object is
     *     {@link PPMatrix }
     *     
     */
    public PPMatrix getPPMatrix() {
        return ppMatrix;
    }

    /**
     * Sets the value of the ppMatrix property.
     * 
     * @param ppMatrix
     *     allowed object is
     *     {@link PPMatrix }
     *     
     */
    public GeneralRegressionModel setPPMatrix(PPMatrix ppMatrix) {
        this.ppMatrix = ppMatrix;
        return this;
    }

    /**
     * Gets the value of the pCovMatrix property.
     * 
     * @return
     *     possible object is
     *     {@link PCovMatrix }
     *     
     */
    public PCovMatrix getPCovMatrix() {
        return pCovMatrix;
    }

    /**
     * Sets the value of the pCovMatrix property.
     * 
     * @param pCovMatrix
     *     allowed object is
     *     {@link PCovMatrix }
     *     
     */
    public GeneralRegressionModel setPCovMatrix(PCovMatrix pCovMatrix) {
        this.pCovMatrix = pCovMatrix;
        return this;
    }

    /**
     * Gets the value of the paramMatrix property.
     * 
     * @return
     *     possible object is
     *     {@link ParamMatrix }
     *     
     */
    public ParamMatrix getParamMatrix() {
        return paramMatrix;
    }

    /**
     * Sets the value of the paramMatrix property.
     * 
     * @param paramMatrix
     *     allowed object is
     *     {@link ParamMatrix }
     *     
     */
    public GeneralRegressionModel setParamMatrix(ParamMatrix paramMatrix) {
        this.paramMatrix = paramMatrix;
        return this;
    }

    /**
     * Gets the value of the eventValues property.
     * 
     * @return
     *     possible object is
     *     {@link EventValues }
     *     
     */
    public EventValues getEventValues() {
        return eventValues;
    }

    /**
     * Sets the value of the eventValues property.
     * 
     * @param eventValues
     *     allowed object is
     *     {@link EventValues }
     *     
     */
    public GeneralRegressionModel setEventValues(EventValues eventValues) {
        this.eventValues = eventValues;
        return this;
    }

    /**
     * Gets the value of the baseCumHazardTables property.
     * 
     * @return
     *     possible object is
     *     {@link BaseCumHazardTables }
     *     
     */
    public BaseCumHazardTables getBaseCumHazardTables() {
        return baseCumHazardTables;
    }

    /**
     * Sets the value of the baseCumHazardTables property.
     * 
     * @param baseCumHazardTables
     *     allowed object is
     *     {@link BaseCumHazardTables }
     *     
     */
    public GeneralRegressionModel setBaseCumHazardTables(BaseCumHazardTables baseCumHazardTables) {
        this.baseCumHazardTables = baseCumHazardTables;
        return this;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param modelVerification
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public GeneralRegressionModel setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public GeneralRegressionModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getParameterList(), getFactorList(), getCovariateList(), getPPMatrix(), getPCovMatrix(), getParamMatrix(), getEventValues(), getBaseCumHazardTables(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="binomial"/>
     *     &lt;enumeration value="gamma"/>
     *     &lt;enumeration value="igauss"/>
     *     &lt;enumeration value="negbin"/>
     *     &lt;enumeration value="normal"/>
     *     &lt;enumeration value="poisson"/>
     *     &lt;enumeration value="tweedie"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_3_2)
    public enum Distribution {

        @XmlEnumValue("binomial")
        BINOMIAL("binomial"),
        @XmlEnumValue("gamma")
        GAMMA("gamma"),
        @XmlEnumValue("igauss")
        IGAUSS("igauss"),
        @XmlEnumValue("negbin")
        NEGBIN("negbin"),
        @XmlEnumValue("normal")
        NORMAL("normal"),
        @XmlEnumValue("poisson")
        POISSON("poisson"),
        @XmlEnumValue("tweedie")
        @Added(Version.PMML_4_0)
        TWEEDIE("tweedie");
        private final String value;

        Distribution(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static GeneralRegressionModel.Distribution fromValue(String v) {
            for (GeneralRegressionModel.Distribution c: GeneralRegressionModel.Distribution.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="regression"/>
     *     &lt;enumeration value="generalLinear"/>
     *     &lt;enumeration value="multinomialLogistic"/>
     *     &lt;enumeration value="ordinalMultinomial"/>
     *     &lt;enumeration value="generalizedLinear"/>
     *     &lt;enumeration value="CoxRegression"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum ModelType {

        @XmlEnumValue("regression")
        REGRESSION("regression"),
        @XmlEnumValue("generalLinear")
        GENERAL_LINEAR("generalLinear"),
        @XmlEnumValue("multinomialLogistic")
        MULTINOMIAL_LOGISTIC("multinomialLogistic"),
        @XmlEnumValue("ordinalMultinomial")
        @Added(Version.PMML_3_1)
        ORDINAL_MULTINOMIAL("ordinalMultinomial"),
        @XmlEnumValue("generalizedLinear")
        @Added(Version.PMML_3_2)
        GENERALIZED_LINEAR("generalizedLinear"),
        @XmlEnumValue("CoxRegression")
        @Added(Version.PMML_4_0)
        COX_REGRESSION("CoxRegression");
        private final String value;

        ModelType(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static GeneralRegressionModel.ModelType fromValue(String v) {
            for (GeneralRegressionModel.ModelType c: GeneralRegressionModel.ModelType.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
