
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Constraints" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Item" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Itemset" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}SetPredicate" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Sequence" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}SequenceRule" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_2}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="numberOfTransactions" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="maxNumberOfItemsPerTransaction" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="avgNumberOfItemsPerTransaction" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="numberOfTransactionGroups" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="maxNumberOfTAsPerTAGroup" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="avgNumberOfTAsPerTAGroup" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="minimumSupport" use="required" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="minimumConfidence" use="required" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="lengthLimit" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="numberOfItems" use="required" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="numberOfSets" use="required" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="numberOfSequences" use="required" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="numberOfRules" use="required" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="timeWindowWidth" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="minimumTime" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="maximumTime" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "modelStats",
    "localTransformations",
    "constraints",
    "items",
    "itemsets",
    "setPredicates",
    "sequences",
    "sequenceRules"
})
@XmlRootElement(name = "SequenceModel", namespace = "http://www.dmg.org/PMML-4_2")
public class SequenceModel
    extends Model
    implements HasExtensions
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "numberOfTransactions")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer numberOfTransactions;
    @XmlAttribute(name = "maxNumberOfItemsPerTransaction")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer maxNumberOfItemsPerTransaction;
    @XmlAttribute(name = "avgNumberOfItemsPerTransaction")
    private Double avgNumberOfItemsPerTransaction;
    @XmlAttribute(name = "numberOfTransactionGroups")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @Added(Version.PMML_3_1)
    private Integer numberOfTransactionGroups;
    @XmlAttribute(name = "maxNumberOfTAsPerTAGroup")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @Added(Version.PMML_3_1)
    private Integer maxNumberOfTAsPerTAGroup;
    @XmlAttribute(name = "avgNumberOfTAsPerTAGroup")
    @Added(Version.PMML_3_1)
    private Double avgNumberOfTAsPerTAGroup;
    @XmlAttribute(name = "minimumSupport", required = true)
    @Removed(Version.PMML_3_1)
    private double minimumSupport;
    @XmlAttribute(name = "minimumConfidence", required = true)
    @Removed(Version.PMML_3_1)
    private double minimumConfidence;
    @XmlAttribute(name = "lengthLimit")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @Removed(Version.PMML_3_1)
    private Integer lengthLimit;
    @XmlAttribute(name = "numberOfItems", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @Removed(Version.PMML_3_1)
    private Integer numberOfItems;
    @XmlAttribute(name = "numberOfSets", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @Removed(Version.PMML_3_1)
    private Integer numberOfSets;
    @XmlAttribute(name = "numberOfSequences", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @Removed(Version.PMML_3_1)
    private Integer numberOfSequences;
    @XmlAttribute(name = "numberOfRules", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @Removed(Version.PMML_3_1)
    private Integer numberOfRules;
    @XmlAttribute(name = "timeWindowWidth")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @Removed(Version.PMML_3_1)
    private Integer timeWindowWidth;
    @XmlAttribute(name = "minimumTime")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @Removed(Version.PMML_3_1)
    private Integer minimumTime;
    @XmlAttribute(name = "maximumTime")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @Removed(Version.PMML_3_1)
    private Integer maximumTime;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name = "Constraints", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_3_1)
    private Constraints constraints;
    @XmlElement(name = "Item", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Item> items;
    @XmlElement(name = "Itemset", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Itemset> itemsets;
    @XmlElement(name = "SetPredicate", namespace = "http://www.dmg.org/PMML-4_2")
    private List<SetPredicate> setPredicates;
    @XmlElement(name = "Sequence", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private List<Sequence> sequences;
    @XmlElement(name = "SequenceRule", namespace = "http://www.dmg.org/PMML-4_2")
    private List<SequenceRule> sequenceRules;
    private final static Boolean DEFAULT_SCORABLE = true;

    public SequenceModel() {
        super();
    }

    public SequenceModel(final MiningFunctionType functionName, final double minimumSupport, final double minimumConfidence, final Integer numberOfItems, final Integer numberOfSets, final Integer numberOfSequences, final Integer numberOfRules, final MiningSchema miningSchema, final List<Sequence> sequences) {
        super();
        this.functionName = functionName;
        this.minimumSupport = minimumSupport;
        this.minimumConfidence = minimumConfidence;
        this.numberOfItems = numberOfItems;
        this.numberOfSets = numberOfSets;
        this.numberOfSequences = numberOfSequences;
        this.numberOfRules = numberOfRules;
        this.miningSchema = miningSchema;
        this.sequences = sequences;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param functionName
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public SequenceModel setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceModel setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the numberOfTransactions property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfTransactions() {
        return numberOfTransactions;
    }

    /**
     * Sets the value of the numberOfTransactions property.
     * 
     * @param numberOfTransactions
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceModel setNumberOfTransactions(Integer numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
        return this;
    }

    /**
     * Gets the value of the maxNumberOfItemsPerTransaction property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getMaxNumberOfItemsPerTransaction() {
        return maxNumberOfItemsPerTransaction;
    }

    /**
     * Sets the value of the maxNumberOfItemsPerTransaction property.
     * 
     * @param maxNumberOfItemsPerTransaction
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceModel setMaxNumberOfItemsPerTransaction(Integer maxNumberOfItemsPerTransaction) {
        this.maxNumberOfItemsPerTransaction = maxNumberOfItemsPerTransaction;
        return this;
    }

    /**
     * Gets the value of the avgNumberOfItemsPerTransaction property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getAvgNumberOfItemsPerTransaction() {
        return avgNumberOfItemsPerTransaction;
    }

    /**
     * Sets the value of the avgNumberOfItemsPerTransaction property.
     * 
     * @param avgNumberOfItemsPerTransaction
     *     allowed object is
     *     {@link Double }
     *     
     */
    public SequenceModel setAvgNumberOfItemsPerTransaction(Double avgNumberOfItemsPerTransaction) {
        this.avgNumberOfItemsPerTransaction = avgNumberOfItemsPerTransaction;
        return this;
    }

    /**
     * Gets the value of the numberOfTransactionGroups property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfTransactionGroups() {
        return numberOfTransactionGroups;
    }

    /**
     * Sets the value of the numberOfTransactionGroups property.
     * 
     * @param numberOfTransactionGroups
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceModel setNumberOfTransactionGroups(Integer numberOfTransactionGroups) {
        this.numberOfTransactionGroups = numberOfTransactionGroups;
        return this;
    }

    /**
     * Gets the value of the maxNumberOfTAsPerTAGroup property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getMaxNumberOfTAsPerTAGroup() {
        return maxNumberOfTAsPerTAGroup;
    }

    /**
     * Sets the value of the maxNumberOfTAsPerTAGroup property.
     * 
     * @param maxNumberOfTAsPerTAGroup
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceModel setMaxNumberOfTAsPerTAGroup(Integer maxNumberOfTAsPerTAGroup) {
        this.maxNumberOfTAsPerTAGroup = maxNumberOfTAsPerTAGroup;
        return this;
    }

    /**
     * Gets the value of the avgNumberOfTAsPerTAGroup property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getAvgNumberOfTAsPerTAGroup() {
        return avgNumberOfTAsPerTAGroup;
    }

    /**
     * Sets the value of the avgNumberOfTAsPerTAGroup property.
     * 
     * @param avgNumberOfTAsPerTAGroup
     *     allowed object is
     *     {@link Double }
     *     
     */
    public SequenceModel setAvgNumberOfTAsPerTAGroup(Double avgNumberOfTAsPerTAGroup) {
        this.avgNumberOfTAsPerTAGroup = avgNumberOfTAsPerTAGroup;
        return this;
    }

    /**
     * Gets the value of the minimumSupport property.
     * 
     */
    public double getMinimumSupport() {
        return minimumSupport;
    }

    /**
     * Sets the value of the minimumSupport property.
     * 
     */
    public SequenceModel setMinimumSupport(double minimumSupport) {
        this.minimumSupport = minimumSupport;
        return this;
    }

    /**
     * Gets the value of the minimumConfidence property.
     * 
     */
    public double getMinimumConfidence() {
        return minimumConfidence;
    }

    /**
     * Sets the value of the minimumConfidence property.
     * 
     */
    public SequenceModel setMinimumConfidence(double minimumConfidence) {
        this.minimumConfidence = minimumConfidence;
        return this;
    }

    /**
     * Gets the value of the lengthLimit property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getLengthLimit() {
        return lengthLimit;
    }

    /**
     * Sets the value of the lengthLimit property.
     * 
     * @param lengthLimit
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceModel setLengthLimit(Integer lengthLimit) {
        this.lengthLimit = lengthLimit;
        return this;
    }

    /**
     * Gets the value of the numberOfItems property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfItems() {
        return numberOfItems;
    }

    /**
     * Sets the value of the numberOfItems property.
     * 
     * @param numberOfItems
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceModel setNumberOfItems(Integer numberOfItems) {
        this.numberOfItems = numberOfItems;
        return this;
    }

    /**
     * Gets the value of the numberOfSets property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfSets() {
        return numberOfSets;
    }

    /**
     * Sets the value of the numberOfSets property.
     * 
     * @param numberOfSets
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceModel setNumberOfSets(Integer numberOfSets) {
        this.numberOfSets = numberOfSets;
        return this;
    }

    /**
     * Gets the value of the numberOfSequences property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfSequences() {
        return numberOfSequences;
    }

    /**
     * Sets the value of the numberOfSequences property.
     * 
     * @param numberOfSequences
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceModel setNumberOfSequences(Integer numberOfSequences) {
        this.numberOfSequences = numberOfSequences;
        return this;
    }

    /**
     * Gets the value of the numberOfRules property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfRules() {
        return numberOfRules;
    }

    /**
     * Sets the value of the numberOfRules property.
     * 
     * @param numberOfRules
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceModel setNumberOfRules(Integer numberOfRules) {
        this.numberOfRules = numberOfRules;
        return this;
    }

    /**
     * Gets the value of the timeWindowWidth property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getTimeWindowWidth() {
        return timeWindowWidth;
    }

    /**
     * Sets the value of the timeWindowWidth property.
     * 
     * @param timeWindowWidth
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceModel setTimeWindowWidth(Integer timeWindowWidth) {
        this.timeWindowWidth = timeWindowWidth;
        return this;
    }

    /**
     * Gets the value of the minimumTime property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getMinimumTime() {
        return minimumTime;
    }

    /**
     * Sets the value of the minimumTime property.
     * 
     * @param minimumTime
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceModel setMinimumTime(Integer minimumTime) {
        this.minimumTime = minimumTime;
        return this;
    }

    /**
     * Gets the value of the maximumTime property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getMaximumTime() {
        return maximumTime;
    }

    /**
     * Sets the value of the maximumTime property.
     * 
     * @param maximumTime
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceModel setMaximumTime(Integer maximumTime) {
        this.maximumTime = maximumTime;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param scorable
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public SequenceModel setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param miningSchema
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public SequenceModel setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public SequenceModel setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public SequenceModel setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the constraints property.
     * 
     * @return
     *     possible object is
     *     {@link Constraints }
     *     
     */
    public Constraints getConstraints() {
        return constraints;
    }

    /**
     * Sets the value of the constraints property.
     * 
     * @param constraints
     *     allowed object is
     *     {@link Constraints }
     *     
     */
    public SequenceModel setConstraints(Constraints constraints) {
        this.constraints = constraints;
        return this;
    }

    /**
     * Gets the value of the items property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the items property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getItems().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Item }
     * 
     * 
     */
    public List<Item> getItems() {
        if (items == null) {
            items = new ArrayList<Item>();
        }
        return this.items;
    }

    /**
     * Gets the value of the itemsets property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the itemsets property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getItemsets().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Itemset }
     * 
     * 
     */
    public List<Itemset> getItemsets() {
        if (itemsets == null) {
            itemsets = new ArrayList<Itemset>();
        }
        return this.itemsets;
    }

    /**
     * Gets the value of the setPredicates property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the setPredicates property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSetPredicates().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SetPredicate }
     * 
     * 
     */
    public List<SetPredicate> getSetPredicates() {
        if (setPredicates == null) {
            setPredicates = new ArrayList<SetPredicate>();
        }
        return this.setPredicates;
    }

    /**
     * Gets the value of the sequences property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the sequences property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSequences().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Sequence }
     * 
     * 
     */
    public List<Sequence> getSequences() {
        if (sequences == null) {
            sequences = new ArrayList<Sequence>();
        }
        return this.sequences;
    }

    /**
     * Gets the value of the sequenceRules property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the sequenceRules property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSequenceRules().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SequenceRule }
     * 
     * 
     */
    public List<SequenceRule> getSequenceRules() {
        if (sequenceRules == null) {
            sequenceRules = new ArrayList<SequenceRule>();
        }
        return this.sequenceRules;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public SequenceModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasItems() {
        return ((this.items!= null)&&(this.items.size()> 0));
    }

    public SequenceModel addItems(Item... items) {
        getItems().addAll(Arrays.asList(items));
        return this;
    }

    public boolean hasItemsets() {
        return ((this.itemsets!= null)&&(this.itemsets.size()> 0));
    }

    public SequenceModel addItemsets(Itemset... itemsets) {
        getItemsets().addAll(Arrays.asList(itemsets));
        return this;
    }

    public boolean hasSetPredicates() {
        return ((this.setPredicates!= null)&&(this.setPredicates.size()> 0));
    }

    public SequenceModel addSetPredicates(SetPredicate... setPredicates) {
        getSetPredicates().addAll(Arrays.asList(setPredicates));
        return this;
    }

    public boolean hasSequences() {
        return ((this.sequences!= null)&&(this.sequences.size()> 0));
    }

    public SequenceModel addSequences(Sequence... sequences) {
        getSequences().addAll(Arrays.asList(sequences));
        return this;
    }

    public boolean hasSequenceRules() {
        return ((this.sequenceRules!= null)&&(this.sequenceRules.size()> 0));
    }

    public SequenceModel addSequenceRules(SequenceRule... sequenceRules) {
        getSequenceRules().addAll(Arrays.asList(sequenceRules));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getModelStats(), getLocalTransformations(), getConstraints());
            }
            if ((status == VisitorAction.CONTINUE)&&hasItems()) {
                status = PMMLObject.traverse(visitor, getItems());
            }
            if ((status == VisitorAction.CONTINUE)&&hasItemsets()) {
                status = PMMLObject.traverse(visitor, getItemsets());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSetPredicates()) {
                status = PMMLObject.traverse(visitor, getSetPredicates());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSequences()) {
                status = PMMLObject.traverse(visitor, getSequences());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSequenceRules()) {
                status = PMMLObject.traverse(visitor, getSequenceRules());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
